/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The comparison display configuration of a KPI or gauge chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComparisonConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComparisonConfiguration.Builder, ComparisonConfiguration> {
    private static final SdkField<String> COMPARISON_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonMethod").getter(getter(ComparisonConfiguration::comparisonMethodAsString))
            .setter(setter(Builder::comparisonMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonMethod").build()).build();

    private static final SdkField<ComparisonFormatConfiguration> COMPARISON_FORMAT_FIELD = SdkField
            .<ComparisonFormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("ComparisonFormat")
            .getter(getter(ComparisonConfiguration::comparisonFormat)).setter(setter(Builder::comparisonFormat))
            .constructor(ComparisonFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_METHOD_FIELD,
            COMPARISON_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String comparisonMethod;

    private final ComparisonFormatConfiguration comparisonFormat;

    private ComparisonConfiguration(BuilderImpl builder) {
        this.comparisonMethod = builder.comparisonMethod;
        this.comparisonFormat = builder.comparisonFormat;
    }

    /**
     * <p>
     * The method of the comparison. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DIFFERENCE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PERCENT_DIFFERENCE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PERCENT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonMethod}
     * will return {@link ComparisonMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #comparisonMethodAsString}.
     * </p>
     * 
     * @return The method of the comparison. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DIFFERENCE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PERCENT_DIFFERENCE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PERCENT</code>
     *         </p>
     *         </li>
     * @see ComparisonMethod
     */
    public final ComparisonMethod comparisonMethod() {
        return ComparisonMethod.fromValue(comparisonMethod);
    }

    /**
     * <p>
     * The method of the comparison. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DIFFERENCE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PERCENT_DIFFERENCE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PERCENT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonMethod}
     * will return {@link ComparisonMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #comparisonMethodAsString}.
     * </p>
     * 
     * @return The method of the comparison. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DIFFERENCE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PERCENT_DIFFERENCE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PERCENT</code>
     *         </p>
     *         </li>
     * @see ComparisonMethod
     */
    public final String comparisonMethodAsString() {
        return comparisonMethod;
    }

    /**
     * <p>
     * The format of the comparison.
     * </p>
     * 
     * @return The format of the comparison.
     */
    public final ComparisonFormatConfiguration comparisonFormat() {
        return comparisonFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparisonConfiguration)) {
            return false;
        }
        ComparisonConfiguration other = (ComparisonConfiguration) obj;
        return Objects.equals(comparisonMethodAsString(), other.comparisonMethodAsString())
                && Objects.equals(comparisonFormat(), other.comparisonFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComparisonConfiguration").add("ComparisonMethod", comparisonMethodAsString())
                .add("ComparisonFormat", comparisonFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComparisonMethod":
            return Optional.ofNullable(clazz.cast(comparisonMethodAsString()));
        case "ComparisonFormat":
            return Optional.ofNullable(clazz.cast(comparisonFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComparisonMethod", COMPARISON_METHOD_FIELD);
        map.put("ComparisonFormat", COMPARISON_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComparisonConfiguration, T> g) {
        return obj -> g.apply((ComparisonConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComparisonConfiguration> {
        /**
         * <p>
         * The method of the comparison. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DIFFERENCE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERCENT_DIFFERENCE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERCENT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param comparisonMethod
         *        The method of the comparison. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DIFFERENCE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PERCENT_DIFFERENCE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PERCENT</code>
         *        </p>
         *        </li>
         * @see ComparisonMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonMethod
         */
        Builder comparisonMethod(String comparisonMethod);

        /**
         * <p>
         * The method of the comparison. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DIFFERENCE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERCENT_DIFFERENCE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERCENT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param comparisonMethod
         *        The method of the comparison. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DIFFERENCE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PERCENT_DIFFERENCE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PERCENT</code>
         *        </p>
         *        </li>
         * @see ComparisonMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonMethod
         */
        Builder comparisonMethod(ComparisonMethod comparisonMethod);

        /**
         * <p>
         * The format of the comparison.
         * </p>
         * 
         * @param comparisonFormat
         *        The format of the comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonFormat(ComparisonFormatConfiguration comparisonFormat);

        /**
         * <p>
         * The format of the comparison.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComparisonFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link ComparisonFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComparisonFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #comparisonFormat(ComparisonFormatConfiguration)}.
         * 
         * @param comparisonFormat
         *        a consumer that will call methods on {@link ComparisonFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparisonFormat(ComparisonFormatConfiguration)
         */
        default Builder comparisonFormat(Consumer<ComparisonFormatConfiguration.Builder> comparisonFormat) {
            return comparisonFormat(ComparisonFormatConfiguration.builder().applyMutation(comparisonFormat).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String comparisonMethod;

        private ComparisonFormatConfiguration comparisonFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparisonConfiguration model) {
            comparisonMethod(model.comparisonMethod);
            comparisonFormat(model.comparisonFormat);
        }

        public final String getComparisonMethod() {
            return comparisonMethod;
        }

        public final void setComparisonMethod(String comparisonMethod) {
            this.comparisonMethod = comparisonMethod;
        }

        @Override
        public final Builder comparisonMethod(String comparisonMethod) {
            this.comparisonMethod = comparisonMethod;
            return this;
        }

        @Override
        public final Builder comparisonMethod(ComparisonMethod comparisonMethod) {
            this.comparisonMethod(comparisonMethod == null ? null : comparisonMethod.toString());
            return this;
        }

        public final ComparisonFormatConfiguration.Builder getComparisonFormat() {
            return comparisonFormat != null ? comparisonFormat.toBuilder() : null;
        }

        public final void setComparisonFormat(ComparisonFormatConfiguration.BuilderImpl comparisonFormat) {
            this.comparisonFormat = comparisonFormat != null ? comparisonFormat.build() : null;
        }

        @Override
        public final Builder comparisonFormat(ComparisonFormatConfiguration comparisonFormat) {
            this.comparisonFormat = comparisonFormat;
            return this;
        }

        @Override
        public ComparisonConfiguration build() {
            return new ComparisonConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
