/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AttributeAggregationFunction;
import software.amazon.awssdk.services.quicksight.model.CategoricalAggregationFunction;
import software.amazon.awssdk.services.quicksight.model.DateAggregationFunction;
import software.amazon.awssdk.services.quicksight.model.NumericalAggregationFunction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationFunction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationFunction> {
    private static final SdkField<NumericalAggregationFunction> NUMERICAL_AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericalAggregationFunction").getter(AggregationFunction.getter(AggregationFunction::numericalAggregationFunction)).setter(AggregationFunction.setter(Builder::numericalAggregationFunction)).constructor(NumericalAggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericalAggregationFunction").build()}).build();
    private static final SdkField<String> CATEGORICAL_AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoricalAggregationFunction").getter(AggregationFunction.getter(AggregationFunction::categoricalAggregationFunctionAsString)).setter(AggregationFunction.setter(Builder::categoricalAggregationFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalAggregationFunction").build()}).build();
    private static final SdkField<String> DATE_AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateAggregationFunction").getter(AggregationFunction.getter(AggregationFunction::dateAggregationFunctionAsString)).setter(AggregationFunction.setter(Builder::dateAggregationFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateAggregationFunction").build()}).build();
    private static final SdkField<AttributeAggregationFunction> ATTRIBUTE_AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeAggregationFunction").getter(AggregationFunction.getter(AggregationFunction::attributeAggregationFunction)).setter(AggregationFunction.setter(Builder::attributeAggregationFunction)).constructor(AttributeAggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeAggregationFunction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERICAL_AGGREGATION_FUNCTION_FIELD, CATEGORICAL_AGGREGATION_FUNCTION_FIELD, DATE_AGGREGATION_FUNCTION_FIELD, ATTRIBUTE_AGGREGATION_FUNCTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregationFunction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NumericalAggregationFunction numericalAggregationFunction;
    private final String categoricalAggregationFunction;
    private final String dateAggregationFunction;
    private final AttributeAggregationFunction attributeAggregationFunction;

    private AggregationFunction(BuilderImpl builder) {
        this.numericalAggregationFunction = builder.numericalAggregationFunction;
        this.categoricalAggregationFunction = builder.categoricalAggregationFunction;
        this.dateAggregationFunction = builder.dateAggregationFunction;
        this.attributeAggregationFunction = builder.attributeAggregationFunction;
    }

    public final NumericalAggregationFunction numericalAggregationFunction() {
        return this.numericalAggregationFunction;
    }

    public final CategoricalAggregationFunction categoricalAggregationFunction() {
        return CategoricalAggregationFunction.fromValue(this.categoricalAggregationFunction);
    }

    public final String categoricalAggregationFunctionAsString() {
        return this.categoricalAggregationFunction;
    }

    public final DateAggregationFunction dateAggregationFunction() {
        return DateAggregationFunction.fromValue(this.dateAggregationFunction);
    }

    public final String dateAggregationFunctionAsString() {
        return this.dateAggregationFunction;
    }

    public final AttributeAggregationFunction attributeAggregationFunction() {
        return this.attributeAggregationFunction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numericalAggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoricalAggregationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateAggregationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAggregationFunction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationFunction)) {
            return false;
        }
        AggregationFunction other = (AggregationFunction)obj;
        return Objects.equals(this.numericalAggregationFunction(), other.numericalAggregationFunction()) && Objects.equals(this.categoricalAggregationFunctionAsString(), other.categoricalAggregationFunctionAsString()) && Objects.equals(this.dateAggregationFunctionAsString(), other.dateAggregationFunctionAsString()) && Objects.equals(this.attributeAggregationFunction(), other.attributeAggregationFunction());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationFunction").add("NumericalAggregationFunction", (Object)this.numericalAggregationFunction()).add("CategoricalAggregationFunction", (Object)this.categoricalAggregationFunctionAsString()).add("DateAggregationFunction", (Object)this.dateAggregationFunctionAsString()).add("AttributeAggregationFunction", (Object)this.attributeAggregationFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumericalAggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.numericalAggregationFunction()));
            }
            case "CategoricalAggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.categoricalAggregationFunctionAsString()));
            }
            case "DateAggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.dateAggregationFunctionAsString()));
            }
            case "AttributeAggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.attributeAggregationFunction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NumericalAggregationFunction", NUMERICAL_AGGREGATION_FUNCTION_FIELD);
        map.put("CategoricalAggregationFunction", CATEGORICAL_AGGREGATION_FUNCTION_FIELD);
        map.put("DateAggregationFunction", DATE_AGGREGATION_FUNCTION_FIELD);
        map.put("AttributeAggregationFunction", ATTRIBUTE_AGGREGATION_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationFunction, T> g) {
        return obj -> g.apply((AggregationFunction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NumericalAggregationFunction numericalAggregationFunction;
        private String categoricalAggregationFunction;
        private String dateAggregationFunction;
        private AttributeAggregationFunction attributeAggregationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationFunction model) {
            this.numericalAggregationFunction(model.numericalAggregationFunction);
            this.categoricalAggregationFunction(model.categoricalAggregationFunction);
            this.dateAggregationFunction(model.dateAggregationFunction);
            this.attributeAggregationFunction(model.attributeAggregationFunction);
        }

        public final NumericalAggregationFunction.Builder getNumericalAggregationFunction() {
            return this.numericalAggregationFunction != null ? this.numericalAggregationFunction.toBuilder() : null;
        }

        public final void setNumericalAggregationFunction(NumericalAggregationFunction.BuilderImpl numericalAggregationFunction) {
            this.numericalAggregationFunction = numericalAggregationFunction != null ? numericalAggregationFunction.build() : null;
        }

        @Override
        public final Builder numericalAggregationFunction(NumericalAggregationFunction numericalAggregationFunction) {
            this.numericalAggregationFunction = numericalAggregationFunction;
            return this;
        }

        public final String getCategoricalAggregationFunction() {
            return this.categoricalAggregationFunction;
        }

        public final void setCategoricalAggregationFunction(String categoricalAggregationFunction) {
            this.categoricalAggregationFunction = categoricalAggregationFunction;
        }

        @Override
        public final Builder categoricalAggregationFunction(String categoricalAggregationFunction) {
            this.categoricalAggregationFunction = categoricalAggregationFunction;
            return this;
        }

        @Override
        public final Builder categoricalAggregationFunction(CategoricalAggregationFunction categoricalAggregationFunction) {
            this.categoricalAggregationFunction(categoricalAggregationFunction == null ? null : categoricalAggregationFunction.toString());
            return this;
        }

        public final String getDateAggregationFunction() {
            return this.dateAggregationFunction;
        }

        public final void setDateAggregationFunction(String dateAggregationFunction) {
            this.dateAggregationFunction = dateAggregationFunction;
        }

        @Override
        public final Builder dateAggregationFunction(String dateAggregationFunction) {
            this.dateAggregationFunction = dateAggregationFunction;
            return this;
        }

        @Override
        public final Builder dateAggregationFunction(DateAggregationFunction dateAggregationFunction) {
            this.dateAggregationFunction(dateAggregationFunction == null ? null : dateAggregationFunction.toString());
            return this;
        }

        public final AttributeAggregationFunction.Builder getAttributeAggregationFunction() {
            return this.attributeAggregationFunction != null ? this.attributeAggregationFunction.toBuilder() : null;
        }

        public final void setAttributeAggregationFunction(AttributeAggregationFunction.BuilderImpl attributeAggregationFunction) {
            this.attributeAggregationFunction = attributeAggregationFunction != null ? attributeAggregationFunction.build() : null;
        }

        @Override
        public final Builder attributeAggregationFunction(AttributeAggregationFunction attributeAggregationFunction) {
            this.attributeAggregationFunction = attributeAggregationFunction;
            return this;
        }

        public AggregationFunction build() {
            return new AggregationFunction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationFunction> {
        public Builder numericalAggregationFunction(NumericalAggregationFunction var1);

        default public Builder numericalAggregationFunction(Consumer<NumericalAggregationFunction.Builder> numericalAggregationFunction) {
            return this.numericalAggregationFunction((NumericalAggregationFunction)((NumericalAggregationFunction.Builder)NumericalAggregationFunction.builder().applyMutation(numericalAggregationFunction)).build());
        }

        public Builder categoricalAggregationFunction(String var1);

        public Builder categoricalAggregationFunction(CategoricalAggregationFunction var1);

        public Builder dateAggregationFunction(String var1);

        public Builder dateAggregationFunction(DateAggregationFunction var1);

        public Builder attributeAggregationFunction(AttributeAggregationFunction var1);

        default public Builder attributeAggregationFunction(Consumer<AttributeAggregationFunction.Builder> attributeAggregationFunction) {
            return this.attributeAggregationFunction((AttributeAggregationFunction)((AttributeAggregationFunction.Builder)AttributeAggregationFunction.builder().applyMutation(attributeAggregationFunction)).build());
        }
    }
}

