/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DashboardsQAStatus;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDashboardsQaConfigurationResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeDashboardsQaConfigurationResponse> {
    private static final SdkField<String> DASHBOARDS_QA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardsQAStatus").getter(DescribeDashboardsQaConfigurationResponse.getter(DescribeDashboardsQaConfigurationResponse::dashboardsQAStatusAsString)).setter(DescribeDashboardsQaConfigurationResponse.setter(Builder::dashboardsQAStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardsQAStatus").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeDashboardsQaConfigurationResponse.getter(DescribeDashboardsQaConfigurationResponse::requestId)).setter(DescribeDashboardsQaConfigurationResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeDashboardsQaConfigurationResponse.getter(DescribeDashboardsQaConfigurationResponse::status)).setter(DescribeDashboardsQaConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARDS_QA_STATUS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDashboardsQaConfigurationResponse.memberNameToFieldInitializer();
    private final String dashboardsQAStatus;
    private final String requestId;
    private final Integer status;

    private DescribeDashboardsQaConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardsQAStatus = builder.dashboardsQAStatus;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final DashboardsQAStatus dashboardsQAStatus() {
        return DashboardsQAStatus.fromValue(this.dashboardsQAStatus);
    }

    public final String dashboardsQAStatusAsString() {
        return this.dashboardsQAStatus;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardsQAStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardsQaConfigurationResponse)) {
            return false;
        }
        DescribeDashboardsQaConfigurationResponse other = (DescribeDashboardsQaConfigurationResponse)((Object)obj);
        return Objects.equals(this.dashboardsQAStatusAsString(), other.dashboardsQAStatusAsString()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDashboardsQaConfigurationResponse").add("DashboardsQAStatus", (Object)this.dashboardsQAStatusAsString()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardsQAStatus": {
                return Optional.ofNullable(clazz.cast(this.dashboardsQAStatusAsString()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DashboardsQAStatus", DASHBOARDS_QA_STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardsQaConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeDashboardsQaConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String dashboardsQAStatus;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardsQaConfigurationResponse model) {
            super(model);
            this.dashboardsQAStatus(model.dashboardsQAStatus);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getDashboardsQAStatus() {
            return this.dashboardsQAStatus;
        }

        public final void setDashboardsQAStatus(String dashboardsQAStatus) {
            this.dashboardsQAStatus = dashboardsQAStatus;
        }

        @Override
        public final Builder dashboardsQAStatus(String dashboardsQAStatus) {
            this.dashboardsQAStatus = dashboardsQAStatus;
            return this;
        }

        @Override
        public final Builder dashboardsQAStatus(DashboardsQAStatus dashboardsQAStatus) {
            this.dashboardsQAStatus(dashboardsQAStatus == null ? null : dashboardsQAStatus.toString());
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeDashboardsQaConfigurationResponse build() {
            return new DescribeDashboardsQaConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDashboardsQaConfigurationResponse> {
        public Builder dashboardsQAStatus(String var1);

        public Builder dashboardsQAStatus(DashboardsQAStatus var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

