/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DateTimeDefaultValueListCopier;
import software.amazon.awssdk.services.quicksight.model.DecimalDefaultValueListCopier;
import software.amazon.awssdk.services.quicksight.model.IntegerDefaultValueListCopier;
import software.amazon.awssdk.services.quicksight.model.StringDefaultValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomParameterValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomParameterValues> {
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringValues").getter(CustomParameterValues.getter(CustomParameterValues::stringValues)).setter(CustomParameterValues.setter(Builder::stringValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Long>> INTEGER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegerValues").getter(CustomParameterValues.getter(CustomParameterValues::integerValues)).setter(CustomParameterValues.setter(Builder::integerValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> DECIMAL_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DecimalValues").getter(CustomParameterValues.getter(CustomParameterValues::decimalValues)).setter(CustomParameterValues.setter(Builder::decimalValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Instant>> DATE_TIME_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DateTimeValues").getter(CustomParameterValues.getter(CustomParameterValues::dateTimeValues)).setter(CustomParameterValues.setter(Builder::dateTimeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUES_FIELD, INTEGER_VALUES_FIELD, DECIMAL_VALUES_FIELD, DATE_TIME_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomParameterValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> stringValues;
    private final List<Long> integerValues;
    private final List<Double> decimalValues;
    private final List<Instant> dateTimeValues;

    private CustomParameterValues(BuilderImpl builder) {
        this.stringValues = builder.stringValues;
        this.integerValues = builder.integerValues;
        this.decimalValues = builder.decimalValues;
        this.dateTimeValues = builder.dateTimeValues;
    }

    public final boolean hasStringValues() {
        return this.stringValues != null && !(this.stringValues instanceof SdkAutoConstructList);
    }

    public final List<String> stringValues() {
        return this.stringValues;
    }

    public final boolean hasIntegerValues() {
        return this.integerValues != null && !(this.integerValues instanceof SdkAutoConstructList);
    }

    public final List<Long> integerValues() {
        return this.integerValues;
    }

    public final boolean hasDecimalValues() {
        return this.decimalValues != null && !(this.decimalValues instanceof SdkAutoConstructList);
    }

    public final List<Double> decimalValues() {
        return this.decimalValues;
    }

    public final boolean hasDateTimeValues() {
        return this.dateTimeValues != null && !(this.dateTimeValues instanceof SdkAutoConstructList);
    }

    public final List<Instant> dateTimeValues() {
        return this.dateTimeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringValues() ? this.stringValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegerValues() ? this.integerValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDecimalValues() ? this.decimalValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDateTimeValues() ? this.dateTimeValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomParameterValues)) {
            return false;
        }
        CustomParameterValues other = (CustomParameterValues)obj;
        return this.hasStringValues() == other.hasStringValues() && Objects.equals(this.stringValues(), other.stringValues()) && this.hasIntegerValues() == other.hasIntegerValues() && Objects.equals(this.integerValues(), other.integerValues()) && this.hasDecimalValues() == other.hasDecimalValues() && Objects.equals(this.decimalValues(), other.decimalValues()) && this.hasDateTimeValues() == other.hasDateTimeValues() && Objects.equals(this.dateTimeValues(), other.dateTimeValues());
    }

    public final String toString() {
        return ToString.builder((String)"CustomParameterValues").add("StringValues", (Object)(this.stringValues() == null ? null : "*** Sensitive Data Redacted ***")).add("IntegerValues", (Object)(this.integerValues() == null ? null : "*** Sensitive Data Redacted ***")).add("DecimalValues", (Object)(this.decimalValues() == null ? null : "*** Sensitive Data Redacted ***")).add("DateTimeValues", (Object)(this.dateTimeValues() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringValues": {
                return Optional.ofNullable(clazz.cast(this.stringValues()));
            }
            case "IntegerValues": {
                return Optional.ofNullable(clazz.cast(this.integerValues()));
            }
            case "DecimalValues": {
                return Optional.ofNullable(clazz.cast(this.decimalValues()));
            }
            case "DateTimeValues": {
                return Optional.ofNullable(clazz.cast(this.dateTimeValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringValues", STRING_VALUES_FIELD);
        map.put("IntegerValues", INTEGER_VALUES_FIELD);
        map.put("DecimalValues", DECIMAL_VALUES_FIELD);
        map.put("DateTimeValues", DATE_TIME_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomParameterValues, T> g) {
        return obj -> g.apply((CustomParameterValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();
        private List<Long> integerValues = DefaultSdkAutoConstructList.getInstance();
        private List<Double> decimalValues = DefaultSdkAutoConstructList.getInstance();
        private List<Instant> dateTimeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomParameterValues model) {
            this.stringValues(model.stringValues);
            this.integerValues(model.integerValues);
            this.decimalValues(model.decimalValues);
            this.dateTimeValues(model.dateTimeValues);
        }

        public final Collection<String> getStringValues() {
            if (this.stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = StringDefaultValueListCopier.copy(stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = StringDefaultValueListCopier.copy(stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String ... stringValues) {
            this.stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final Collection<Long> getIntegerValues() {
            if (this.integerValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.integerValues;
        }

        public final void setIntegerValues(Collection<Long> integerValues) {
            this.integerValues = IntegerDefaultValueListCopier.copy(integerValues);
        }

        @Override
        public final Builder integerValues(Collection<Long> integerValues) {
            this.integerValues = IntegerDefaultValueListCopier.copy(integerValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerValues(Long ... integerValues) {
            this.integerValues(Arrays.asList(integerValues));
            return this;
        }

        public final Collection<Double> getDecimalValues() {
            if (this.decimalValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.decimalValues;
        }

        public final void setDecimalValues(Collection<Double> decimalValues) {
            this.decimalValues = DecimalDefaultValueListCopier.copy(decimalValues);
        }

        @Override
        public final Builder decimalValues(Collection<Double> decimalValues) {
            this.decimalValues = DecimalDefaultValueListCopier.copy(decimalValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decimalValues(Double ... decimalValues) {
            this.decimalValues(Arrays.asList(decimalValues));
            return this;
        }

        public final Collection<Instant> getDateTimeValues() {
            if (this.dateTimeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dateTimeValues;
        }

        public final void setDateTimeValues(Collection<Instant> dateTimeValues) {
            this.dateTimeValues = DateTimeDefaultValueListCopier.copy(dateTimeValues);
        }

        @Override
        public final Builder dateTimeValues(Collection<Instant> dateTimeValues) {
            this.dateTimeValues = DateTimeDefaultValueListCopier.copy(dateTimeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateTimeValues(Instant ... dateTimeValues) {
            this.dateTimeValues(Arrays.asList(dateTimeValues));
            return this;
        }

        public CustomParameterValues build() {
            return new CustomParameterValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomParameterValues> {
        public Builder stringValues(Collection<String> var1);

        public Builder stringValues(String ... var1);

        public Builder integerValues(Collection<Long> var1);

        public Builder integerValues(Long ... var1);

        public Builder decimalValues(Collection<Double> var1);

        public Builder decimalValues(Double ... var1);

        public Builder dateTimeValues(Collection<Instant> var1);

        public Builder dateTimeValues(Instant ... var1);
    }
}

