/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DimensionField;
import software.amazon.awssdk.services.quicksight.model.DimensionFieldListCopier;
import software.amazon.awssdk.services.quicksight.model.MeasureField;
import software.amazon.awssdk.services.quicksight.model.MeasureFieldListCopier;
import software.amazon.awssdk.services.quicksight.model.PluginVisualAxisName;
import software.amazon.awssdk.services.quicksight.model.UnaggregatedField;
import software.amazon.awssdk.services.quicksight.model.UnaggregatedFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PluginVisualFieldWell
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PluginVisualFieldWell> {
    private static final SdkField<String> AXIS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AxisName").getter(PluginVisualFieldWell.getter(PluginVisualFieldWell::axisNameAsString)).setter(PluginVisualFieldWell.setter(Builder::axisName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisName").build()}).build();
    private static final SdkField<List<DimensionField>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(PluginVisualFieldWell.getter(PluginVisualFieldWell::dimensions)).setter(PluginVisualFieldWell.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MeasureField>> MEASURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Measures").getter(PluginVisualFieldWell.getter(PluginVisualFieldWell::measures)).setter(PluginVisualFieldWell.setter(Builder::measures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Measures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnaggregatedField>> UNAGGREGATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Unaggregated").getter(PluginVisualFieldWell.getter(PluginVisualFieldWell::unaggregated)).setter(PluginVisualFieldWell.setter(Builder::unaggregated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unaggregated").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnaggregatedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AXIS_NAME_FIELD, DIMENSIONS_FIELD, MEASURES_FIELD, UNAGGREGATED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AxisName", AXIS_NAME_FIELD);
            this.put("Dimensions", DIMENSIONS_FIELD);
            this.put("Measures", MEASURES_FIELD);
            this.put("Unaggregated", UNAGGREGATED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String axisName;
    private final List<DimensionField> dimensions;
    private final List<MeasureField> measures;
    private final List<UnaggregatedField> unaggregated;

    private PluginVisualFieldWell(BuilderImpl builder) {
        this.axisName = builder.axisName;
        this.dimensions = builder.dimensions;
        this.measures = builder.measures;
        this.unaggregated = builder.unaggregated;
    }

    public final PluginVisualAxisName axisName() {
        return PluginVisualAxisName.fromValue(this.axisName);
    }

    public final String axisNameAsString() {
        return this.axisName;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<DimensionField> dimensions() {
        return this.dimensions;
    }

    public final boolean hasMeasures() {
        return this.measures != null && !(this.measures instanceof SdkAutoConstructList);
    }

    public final List<MeasureField> measures() {
        return this.measures;
    }

    public final boolean hasUnaggregated() {
        return this.unaggregated != null && !(this.unaggregated instanceof SdkAutoConstructList);
    }

    public final List<UnaggregatedField> unaggregated() {
        return this.unaggregated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.axisNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMeasures() ? this.measures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnaggregated() ? this.unaggregated() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisualFieldWell)) {
            return false;
        }
        PluginVisualFieldWell other = (PluginVisualFieldWell)obj;
        return Objects.equals(this.axisNameAsString(), other.axisNameAsString()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && this.hasMeasures() == other.hasMeasures() && Objects.equals(this.measures(), other.measures()) && this.hasUnaggregated() == other.hasUnaggregated() && Objects.equals(this.unaggregated(), other.unaggregated());
    }

    public final String toString() {
        return ToString.builder((String)"PluginVisualFieldWell").add("AxisName", (Object)this.axisNameAsString()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Measures", this.hasMeasures() ? this.measures() : null).add("Unaggregated", this.hasUnaggregated() ? this.unaggregated() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AxisName": {
                return Optional.ofNullable(clazz.cast(this.axisNameAsString()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Measures": {
                return Optional.ofNullable(clazz.cast(this.measures()));
            }
            case "Unaggregated": {
                return Optional.ofNullable(clazz.cast(this.unaggregated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PluginVisualFieldWell, T> g) {
        return obj -> g.apply((PluginVisualFieldWell)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String axisName;
        private List<DimensionField> dimensions = DefaultSdkAutoConstructList.getInstance();
        private List<MeasureField> measures = DefaultSdkAutoConstructList.getInstance();
        private List<UnaggregatedField> unaggregated = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisualFieldWell model) {
            this.axisName(model.axisName);
            this.dimensions(model.dimensions);
            this.measures(model.measures);
            this.unaggregated(model.unaggregated);
        }

        public final String getAxisName() {
            return this.axisName;
        }

        public final void setAxisName(String axisName) {
            this.axisName = axisName;
        }

        @Override
        public final Builder axisName(String axisName) {
            this.axisName = axisName;
            return this;
        }

        @Override
        public final Builder axisName(PluginVisualAxisName axisName) {
            this.axisName(axisName == null ? null : axisName.toString());
            return this;
        }

        public final List<DimensionField.Builder> getDimensions() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<DimensionField.BuilderImpl> dimensions) {
            this.dimensions = DimensionFieldListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<DimensionField> dimensions) {
            this.dimensions = DimensionFieldListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(DimensionField ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<DimensionField.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (DimensionField)((DimensionField.Builder)DimensionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getMeasures() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.measures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMeasures(Collection<MeasureField.BuilderImpl> measures) {
            this.measures = MeasureFieldListCopier.copyFromBuilder(measures);
        }

        @Override
        public final Builder measures(Collection<MeasureField> measures) {
            this.measures = MeasureFieldListCopier.copy(measures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder measures(MeasureField ... measures) {
            this.measures(Arrays.asList(measures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder measures(Consumer<MeasureField.Builder> ... measures) {
            this.measures(Stream.of(measures).map(c -> (MeasureField)((MeasureField.Builder)MeasureField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnaggregatedField.Builder> getUnaggregated() {
            List<UnaggregatedField.Builder> result = UnaggregatedFieldListCopier.copyToBuilder(this.unaggregated);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnaggregated(Collection<UnaggregatedField.BuilderImpl> unaggregated) {
            this.unaggregated = UnaggregatedFieldListCopier.copyFromBuilder(unaggregated);
        }

        @Override
        public final Builder unaggregated(Collection<UnaggregatedField> unaggregated) {
            this.unaggregated = UnaggregatedFieldListCopier.copy(unaggregated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unaggregated(UnaggregatedField ... unaggregated) {
            this.unaggregated(Arrays.asList(unaggregated));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unaggregated(Consumer<UnaggregatedField.Builder> ... unaggregated) {
            this.unaggregated(Stream.of(unaggregated).map(c -> (UnaggregatedField)((UnaggregatedField.Builder)UnaggregatedField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PluginVisualFieldWell build() {
            return new PluginVisualFieldWell(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PluginVisualFieldWell> {
        public Builder axisName(String var1);

        public Builder axisName(PluginVisualAxisName var1);

        public Builder dimensions(Collection<DimensionField> var1);

        public Builder dimensions(DimensionField ... var1);

        public Builder dimensions(Consumer<DimensionField.Builder> ... var1);

        public Builder measures(Collection<MeasureField> var1);

        public Builder measures(MeasureField ... var1);

        public Builder measures(Consumer<MeasureField.Builder> ... var1);

        public Builder unaggregated(Collection<UnaggregatedField> var1);

        public Builder unaggregated(UnaggregatedField ... var1);

        public Builder unaggregated(Consumer<UnaggregatedField.Builder> ... var1);
    }
}

