/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FreeFormLayoutConfiguration;
import software.amazon.awssdk.services.quicksight.model.GridLayoutConfiguration;
import software.amazon.awssdk.services.quicksight.model.SectionBasedLayoutConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LayoutConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LayoutConfiguration> {
    private static final SdkField<GridLayoutConfiguration> GRID_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GridLayout").getter(LayoutConfiguration.getter(LayoutConfiguration::gridLayout)).setter(LayoutConfiguration.setter(Builder::gridLayout)).constructor(GridLayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GridLayout").build()}).build();
    private static final SdkField<FreeFormLayoutConfiguration> FREE_FORM_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FreeFormLayout").getter(LayoutConfiguration.getter(LayoutConfiguration::freeFormLayout)).setter(LayoutConfiguration.setter(Builder::freeFormLayout)).constructor(FreeFormLayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeFormLayout").build()}).build();
    private static final SdkField<SectionBasedLayoutConfiguration> SECTION_BASED_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SectionBasedLayout").getter(LayoutConfiguration.getter(LayoutConfiguration::sectionBasedLayout)).setter(LayoutConfiguration.setter(Builder::sectionBasedLayout)).constructor(SectionBasedLayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionBasedLayout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRID_LAYOUT_FIELD, FREE_FORM_LAYOUT_FIELD, SECTION_BASED_LAYOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GridLayout", GRID_LAYOUT_FIELD);
            this.put("FreeFormLayout", FREE_FORM_LAYOUT_FIELD);
            this.put("SectionBasedLayout", SECTION_BASED_LAYOUT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final GridLayoutConfiguration gridLayout;
    private final FreeFormLayoutConfiguration freeFormLayout;
    private final SectionBasedLayoutConfiguration sectionBasedLayout;

    private LayoutConfiguration(BuilderImpl builder) {
        this.gridLayout = builder.gridLayout;
        this.freeFormLayout = builder.freeFormLayout;
        this.sectionBasedLayout = builder.sectionBasedLayout;
    }

    public final GridLayoutConfiguration gridLayout() {
        return this.gridLayout;
    }

    public final FreeFormLayoutConfiguration freeFormLayout() {
        return this.freeFormLayout;
    }

    public final SectionBasedLayoutConfiguration sectionBasedLayout() {
        return this.sectionBasedLayout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gridLayout());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeFormLayout());
        hashCode = 31 * hashCode + Objects.hashCode(this.sectionBasedLayout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayoutConfiguration)) {
            return false;
        }
        LayoutConfiguration other = (LayoutConfiguration)obj;
        return Objects.equals(this.gridLayout(), other.gridLayout()) && Objects.equals(this.freeFormLayout(), other.freeFormLayout()) && Objects.equals(this.sectionBasedLayout(), other.sectionBasedLayout());
    }

    public final String toString() {
        return ToString.builder((String)"LayoutConfiguration").add("GridLayout", (Object)this.gridLayout()).add("FreeFormLayout", (Object)this.freeFormLayout()).add("SectionBasedLayout", (Object)this.sectionBasedLayout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GridLayout": {
                return Optional.ofNullable(clazz.cast(this.gridLayout()));
            }
            case "FreeFormLayout": {
                return Optional.ofNullable(clazz.cast(this.freeFormLayout()));
            }
            case "SectionBasedLayout": {
                return Optional.ofNullable(clazz.cast(this.sectionBasedLayout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LayoutConfiguration, T> g) {
        return obj -> g.apply((LayoutConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GridLayoutConfiguration gridLayout;
        private FreeFormLayoutConfiguration freeFormLayout;
        private SectionBasedLayoutConfiguration sectionBasedLayout;

        private BuilderImpl() {
        }

        private BuilderImpl(LayoutConfiguration model) {
            this.gridLayout(model.gridLayout);
            this.freeFormLayout(model.freeFormLayout);
            this.sectionBasedLayout(model.sectionBasedLayout);
        }

        public final GridLayoutConfiguration.Builder getGridLayout() {
            return this.gridLayout != null ? this.gridLayout.toBuilder() : null;
        }

        public final void setGridLayout(GridLayoutConfiguration.BuilderImpl gridLayout) {
            this.gridLayout = gridLayout != null ? gridLayout.build() : null;
        }

        @Override
        public final Builder gridLayout(GridLayoutConfiguration gridLayout) {
            this.gridLayout = gridLayout;
            return this;
        }

        public final FreeFormLayoutConfiguration.Builder getFreeFormLayout() {
            return this.freeFormLayout != null ? this.freeFormLayout.toBuilder() : null;
        }

        public final void setFreeFormLayout(FreeFormLayoutConfiguration.BuilderImpl freeFormLayout) {
            this.freeFormLayout = freeFormLayout != null ? freeFormLayout.build() : null;
        }

        @Override
        public final Builder freeFormLayout(FreeFormLayoutConfiguration freeFormLayout) {
            this.freeFormLayout = freeFormLayout;
            return this;
        }

        public final SectionBasedLayoutConfiguration.Builder getSectionBasedLayout() {
            return this.sectionBasedLayout != null ? this.sectionBasedLayout.toBuilder() : null;
        }

        public final void setSectionBasedLayout(SectionBasedLayoutConfiguration.BuilderImpl sectionBasedLayout) {
            this.sectionBasedLayout = sectionBasedLayout != null ? sectionBasedLayout.build() : null;
        }

        @Override
        public final Builder sectionBasedLayout(SectionBasedLayoutConfiguration sectionBasedLayout) {
            this.sectionBasedLayout = sectionBasedLayout;
            return this;
        }

        public LayoutConfiguration build() {
            return new LayoutConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LayoutConfiguration> {
        public Builder gridLayout(GridLayoutConfiguration var1);

        default public Builder gridLayout(Consumer<GridLayoutConfiguration.Builder> gridLayout) {
            return this.gridLayout((GridLayoutConfiguration)((GridLayoutConfiguration.Builder)GridLayoutConfiguration.builder().applyMutation(gridLayout)).build());
        }

        public Builder freeFormLayout(FreeFormLayoutConfiguration var1);

        default public Builder freeFormLayout(Consumer<FreeFormLayoutConfiguration.Builder> freeFormLayout) {
            return this.freeFormLayout((FreeFormLayoutConfiguration)((FreeFormLayoutConfiguration.Builder)FreeFormLayoutConfiguration.builder().applyMutation(freeFormLayout)).build());
        }

        public Builder sectionBasedLayout(SectionBasedLayoutConfiguration var1);

        default public Builder sectionBasedLayout(Consumer<SectionBasedLayoutConfiguration.Builder> sectionBasedLayout) {
            return this.sectionBasedLayout((SectionBasedLayoutConfiguration)((SectionBasedLayoutConfiguration.Builder)SectionBasedLayoutConfiguration.builder().applyMutation(sectionBasedLayout)).build());
        }
    }
}

