/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.RefreshInterval;
import software.amazon.awssdk.services.quicksight.model.ScheduleRefreshOnEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshFrequency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RefreshFrequency> {
    private static final SdkField<String> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Interval").getter(RefreshFrequency.getter(RefreshFrequency::intervalAsString)).setter(RefreshFrequency.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<ScheduleRefreshOnEntity> REFRESH_ON_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RefreshOnDay").getter(RefreshFrequency.getter(RefreshFrequency::refreshOnDay)).setter(RefreshFrequency.setter(Builder::refreshOnDay)).constructor(ScheduleRefreshOnEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshOnDay").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(RefreshFrequency.getter(RefreshFrequency::timezone)).setter(RefreshFrequency.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<String> TIME_OF_THE_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeOfTheDay").getter(RefreshFrequency.getter(RefreshFrequency::timeOfTheDay)).setter(RefreshFrequency.setter(Builder::timeOfTheDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeOfTheDay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD, REFRESH_ON_DAY_FIELD, TIMEZONE_FIELD, TIME_OF_THE_DAY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Interval", INTERVAL_FIELD);
            this.put("RefreshOnDay", REFRESH_ON_DAY_FIELD);
            this.put("Timezone", TIMEZONE_FIELD);
            this.put("TimeOfTheDay", TIME_OF_THE_DAY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String interval;
    private final ScheduleRefreshOnEntity refreshOnDay;
    private final String timezone;
    private final String timeOfTheDay;

    private RefreshFrequency(BuilderImpl builder) {
        this.interval = builder.interval;
        this.refreshOnDay = builder.refreshOnDay;
        this.timezone = builder.timezone;
        this.timeOfTheDay = builder.timeOfTheDay;
    }

    public final RefreshInterval interval() {
        return RefreshInterval.fromValue(this.interval);
    }

    public final String intervalAsString() {
        return this.interval;
    }

    public final ScheduleRefreshOnEntity refreshOnDay() {
        return this.refreshOnDay;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final String timeOfTheDay() {
        return this.timeOfTheDay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshOnDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOfTheDay());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshFrequency)) {
            return false;
        }
        RefreshFrequency other = (RefreshFrequency)obj;
        return Objects.equals(this.intervalAsString(), other.intervalAsString()) && Objects.equals(this.refreshOnDay(), other.refreshOnDay()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.timeOfTheDay(), other.timeOfTheDay());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshFrequency").add("Interval", (Object)this.intervalAsString()).add("RefreshOnDay", (Object)this.refreshOnDay()).add("Timezone", (Object)this.timezone()).add("TimeOfTheDay", (Object)this.timeOfTheDay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.intervalAsString()));
            }
            case "RefreshOnDay": {
                return Optional.ofNullable(clazz.cast(this.refreshOnDay()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "TimeOfTheDay": {
                return Optional.ofNullable(clazz.cast(this.timeOfTheDay()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RefreshFrequency, T> g) {
        return obj -> g.apply((RefreshFrequency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String interval;
        private ScheduleRefreshOnEntity refreshOnDay;
        private String timezone;
        private String timeOfTheDay;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshFrequency model) {
            this.interval(model.interval);
            this.refreshOnDay(model.refreshOnDay);
            this.timezone(model.timezone);
            this.timeOfTheDay(model.timeOfTheDay);
        }

        public final String getInterval() {
            return this.interval;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public final Builder interval(RefreshInterval interval) {
            this.interval(interval == null ? null : interval.toString());
            return this;
        }

        public final ScheduleRefreshOnEntity.Builder getRefreshOnDay() {
            return this.refreshOnDay != null ? this.refreshOnDay.toBuilder() : null;
        }

        public final void setRefreshOnDay(ScheduleRefreshOnEntity.BuilderImpl refreshOnDay) {
            this.refreshOnDay = refreshOnDay != null ? refreshOnDay.build() : null;
        }

        @Override
        public final Builder refreshOnDay(ScheduleRefreshOnEntity refreshOnDay) {
            this.refreshOnDay = refreshOnDay;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getTimeOfTheDay() {
            return this.timeOfTheDay;
        }

        public final void setTimeOfTheDay(String timeOfTheDay) {
            this.timeOfTheDay = timeOfTheDay;
        }

        @Override
        public final Builder timeOfTheDay(String timeOfTheDay) {
            this.timeOfTheDay = timeOfTheDay;
            return this;
        }

        public RefreshFrequency build() {
            return new RefreshFrequency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RefreshFrequency> {
        public Builder interval(String var1);

        public Builder interval(RefreshInterval var1);

        public Builder refreshOnDay(ScheduleRefreshOnEntity var1);

        default public Builder refreshOnDay(Consumer<ScheduleRefreshOnEntity.Builder> refreshOnDay) {
            return this.refreshOnDay((ScheduleRefreshOnEntity)((ScheduleRefreshOnEntity.Builder)ScheduleRefreshOnEntity.builder().applyMutation(refreshOnDay)).build());
        }

        public Builder timezone(String var1);

        public Builder timeOfTheDay(String var1);
    }
}

