/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.ItemsLimitConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineChartSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineChartSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> CATEGORY_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategorySort").getter(LineChartSortConfiguration.getter(LineChartSortConfiguration::categorySort)).setter(LineChartSortConfiguration.setter(Builder::categorySort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategorySort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> CATEGORY_ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryItemsLimitConfiguration").getter(LineChartSortConfiguration.getter(LineChartSortConfiguration::categoryItemsLimitConfiguration)).setter(LineChartSortConfiguration.setter(Builder::categoryItemsLimitConfiguration)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryItemsLimitConfiguration").build()}).build();
    private static final SdkField<ItemsLimitConfiguration> COLOR_ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorItemsLimitConfiguration").getter(LineChartSortConfiguration.getter(LineChartSortConfiguration::colorItemsLimitConfiguration)).setter(LineChartSortConfiguration.setter(Builder::colorItemsLimitConfiguration)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorItemsLimitConfiguration").build()}).build();
    private static final SdkField<List<FieldSortOptions>> SMALL_MULTIPLES_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SmallMultiplesSort").getter(LineChartSortConfiguration.getter(LineChartSortConfiguration::smallMultiplesSort)).setter(LineChartSortConfiguration.setter(Builder::smallMultiplesSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> SMALL_MULTIPLES_LIMIT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmallMultiplesLimitConfiguration").getter(LineChartSortConfiguration.getter(LineChartSortConfiguration::smallMultiplesLimitConfiguration)).setter(LineChartSortConfiguration.setter(Builder::smallMultiplesLimitConfiguration)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesLimitConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_SORT_FIELD, CATEGORY_ITEMS_LIMIT_CONFIGURATION_FIELD, COLOR_ITEMS_LIMIT_CONFIGURATION_FIELD, SMALL_MULTIPLES_SORT_FIELD, SMALL_MULTIPLES_LIMIT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CategorySort", CATEGORY_SORT_FIELD);
            this.put("CategoryItemsLimitConfiguration", CATEGORY_ITEMS_LIMIT_CONFIGURATION_FIELD);
            this.put("ColorItemsLimitConfiguration", COLOR_ITEMS_LIMIT_CONFIGURATION_FIELD);
            this.put("SmallMultiplesSort", SMALL_MULTIPLES_SORT_FIELD);
            this.put("SmallMultiplesLimitConfiguration", SMALL_MULTIPLES_LIMIT_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> categorySort;
    private final ItemsLimitConfiguration categoryItemsLimitConfiguration;
    private final ItemsLimitConfiguration colorItemsLimitConfiguration;
    private final List<FieldSortOptions> smallMultiplesSort;
    private final ItemsLimitConfiguration smallMultiplesLimitConfiguration;

    private LineChartSortConfiguration(BuilderImpl builder) {
        this.categorySort = builder.categorySort;
        this.categoryItemsLimitConfiguration = builder.categoryItemsLimitConfiguration;
        this.colorItemsLimitConfiguration = builder.colorItemsLimitConfiguration;
        this.smallMultiplesSort = builder.smallMultiplesSort;
        this.smallMultiplesLimitConfiguration = builder.smallMultiplesLimitConfiguration;
    }

    public final boolean hasCategorySort() {
        return this.categorySort != null && !(this.categorySort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> categorySort() {
        return this.categorySort;
    }

    public final ItemsLimitConfiguration categoryItemsLimitConfiguration() {
        return this.categoryItemsLimitConfiguration;
    }

    public final ItemsLimitConfiguration colorItemsLimitConfiguration() {
        return this.colorItemsLimitConfiguration;
    }

    public final boolean hasSmallMultiplesSort() {
        return this.smallMultiplesSort != null && !(this.smallMultiplesSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> smallMultiplesSort() {
        return this.smallMultiplesSort;
    }

    public final ItemsLimitConfiguration smallMultiplesLimitConfiguration() {
        return this.smallMultiplesLimitConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategorySort() ? this.categorySort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryItemsLimitConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorItemsLimitConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSmallMultiplesSort() ? this.smallMultiplesSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.smallMultiplesLimitConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartSortConfiguration)) {
            return false;
        }
        LineChartSortConfiguration other = (LineChartSortConfiguration)obj;
        return this.hasCategorySort() == other.hasCategorySort() && Objects.equals(this.categorySort(), other.categorySort()) && Objects.equals(this.categoryItemsLimitConfiguration(), other.categoryItemsLimitConfiguration()) && Objects.equals(this.colorItemsLimitConfiguration(), other.colorItemsLimitConfiguration()) && this.hasSmallMultiplesSort() == other.hasSmallMultiplesSort() && Objects.equals(this.smallMultiplesSort(), other.smallMultiplesSort()) && Objects.equals(this.smallMultiplesLimitConfiguration(), other.smallMultiplesLimitConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"LineChartSortConfiguration").add("CategorySort", this.hasCategorySort() ? this.categorySort() : null).add("CategoryItemsLimitConfiguration", (Object)this.categoryItemsLimitConfiguration()).add("ColorItemsLimitConfiguration", (Object)this.colorItemsLimitConfiguration()).add("SmallMultiplesSort", this.hasSmallMultiplesSort() ? this.smallMultiplesSort() : null).add("SmallMultiplesLimitConfiguration", (Object)this.smallMultiplesLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategorySort": {
                return Optional.ofNullable(clazz.cast(this.categorySort()));
            }
            case "CategoryItemsLimitConfiguration": {
                return Optional.ofNullable(clazz.cast(this.categoryItemsLimitConfiguration()));
            }
            case "ColorItemsLimitConfiguration": {
                return Optional.ofNullable(clazz.cast(this.colorItemsLimitConfiguration()));
            }
            case "SmallMultiplesSort": {
                return Optional.ofNullable(clazz.cast(this.smallMultiplesSort()));
            }
            case "SmallMultiplesLimitConfiguration": {
                return Optional.ofNullable(clazz.cast(this.smallMultiplesLimitConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LineChartSortConfiguration, T> g) {
        return obj -> g.apply((LineChartSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> categorySort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration categoryItemsLimitConfiguration;
        private ItemsLimitConfiguration colorItemsLimitConfiguration;
        private List<FieldSortOptions> smallMultiplesSort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration smallMultiplesLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartSortConfiguration model) {
            this.categorySort(model.categorySort);
            this.categoryItemsLimitConfiguration(model.categoryItemsLimitConfiguration);
            this.colorItemsLimitConfiguration(model.colorItemsLimitConfiguration);
            this.smallMultiplesSort(model.smallMultiplesSort);
            this.smallMultiplesLimitConfiguration(model.smallMultiplesLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getCategorySort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.categorySort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategorySort(Collection<FieldSortOptions.BuilderImpl> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copyFromBuilder(categorySort);
        }

        @Override
        public final Builder categorySort(Collection<FieldSortOptions> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copy(categorySort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(FieldSortOptions ... categorySort) {
            this.categorySort(Arrays.asList(categorySort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(Consumer<FieldSortOptions.Builder> ... categorySort) {
            this.categorySort(Stream.of(categorySort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getCategoryItemsLimitConfiguration() {
            return this.categoryItemsLimitConfiguration != null ? this.categoryItemsLimitConfiguration.toBuilder() : null;
        }

        public final void setCategoryItemsLimitConfiguration(ItemsLimitConfiguration.BuilderImpl categoryItemsLimitConfiguration) {
            this.categoryItemsLimitConfiguration = categoryItemsLimitConfiguration != null ? categoryItemsLimitConfiguration.build() : null;
        }

        @Override
        public final Builder categoryItemsLimitConfiguration(ItemsLimitConfiguration categoryItemsLimitConfiguration) {
            this.categoryItemsLimitConfiguration = categoryItemsLimitConfiguration;
            return this;
        }

        public final ItemsLimitConfiguration.Builder getColorItemsLimitConfiguration() {
            return this.colorItemsLimitConfiguration != null ? this.colorItemsLimitConfiguration.toBuilder() : null;
        }

        public final void setColorItemsLimitConfiguration(ItemsLimitConfiguration.BuilderImpl colorItemsLimitConfiguration) {
            this.colorItemsLimitConfiguration = colorItemsLimitConfiguration != null ? colorItemsLimitConfiguration.build() : null;
        }

        @Override
        public final Builder colorItemsLimitConfiguration(ItemsLimitConfiguration colorItemsLimitConfiguration) {
            this.colorItemsLimitConfiguration = colorItemsLimitConfiguration;
            return this;
        }

        public final List<FieldSortOptions.Builder> getSmallMultiplesSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.smallMultiplesSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSmallMultiplesSort(Collection<FieldSortOptions.BuilderImpl> smallMultiplesSort) {
            this.smallMultiplesSort = FieldSortOptionsListCopier.copyFromBuilder(smallMultiplesSort);
        }

        @Override
        public final Builder smallMultiplesSort(Collection<FieldSortOptions> smallMultiplesSort) {
            this.smallMultiplesSort = FieldSortOptionsListCopier.copy(smallMultiplesSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smallMultiplesSort(FieldSortOptions ... smallMultiplesSort) {
            this.smallMultiplesSort(Arrays.asList(smallMultiplesSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder smallMultiplesSort(Consumer<FieldSortOptions.Builder> ... smallMultiplesSort) {
            this.smallMultiplesSort(Stream.of(smallMultiplesSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getSmallMultiplesLimitConfiguration() {
            return this.smallMultiplesLimitConfiguration != null ? this.smallMultiplesLimitConfiguration.toBuilder() : null;
        }

        public final void setSmallMultiplesLimitConfiguration(ItemsLimitConfiguration.BuilderImpl smallMultiplesLimitConfiguration) {
            this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration != null ? smallMultiplesLimitConfiguration.build() : null;
        }

        @Override
        public final Builder smallMultiplesLimitConfiguration(ItemsLimitConfiguration smallMultiplesLimitConfiguration) {
            this.smallMultiplesLimitConfiguration = smallMultiplesLimitConfiguration;
            return this;
        }

        public LineChartSortConfiguration build() {
            return new LineChartSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineChartSortConfiguration> {
        public Builder categorySort(Collection<FieldSortOptions> var1);

        public Builder categorySort(FieldSortOptions ... var1);

        public Builder categorySort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder categoryItemsLimitConfiguration(ItemsLimitConfiguration var1);

        default public Builder categoryItemsLimitConfiguration(Consumer<ItemsLimitConfiguration.Builder> categoryItemsLimitConfiguration) {
            return this.categoryItemsLimitConfiguration((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(categoryItemsLimitConfiguration)).build());
        }

        public Builder colorItemsLimitConfiguration(ItemsLimitConfiguration var1);

        default public Builder colorItemsLimitConfiguration(Consumer<ItemsLimitConfiguration.Builder> colorItemsLimitConfiguration) {
            return this.colorItemsLimitConfiguration((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(colorItemsLimitConfiguration)).build());
        }

        public Builder smallMultiplesSort(Collection<FieldSortOptions> var1);

        public Builder smallMultiplesSort(FieldSortOptions ... var1);

        public Builder smallMultiplesSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder smallMultiplesLimitConfiguration(ItemsLimitConfiguration var1);

        default public Builder smallMultiplesLimitConfiguration(Consumer<ItemsLimitConfiguration.Builder> smallMultiplesLimitConfiguration) {
            return this.smallMultiplesLimitConfiguration((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(smallMultiplesLimitConfiguration)).build());
        }
    }
}

