/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.PurchaseMode;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSpiceCapacityConfigurationRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateSpiceCapacityConfigurationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateSpiceCapacityConfigurationRequest.getter(UpdateSpiceCapacityConfigurationRequest::awsAccountId)).setter(UpdateSpiceCapacityConfigurationRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> PURCHASE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseMode").getter(UpdateSpiceCapacityConfigurationRequest.getter(UpdateSpiceCapacityConfigurationRequest::purchaseModeAsString)).setter(UpdateSpiceCapacityConfigurationRequest.setter(Builder::purchaseMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, PURCHASE_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("PurchaseMode", PURCHASE_MODE_FIELD);
        }
    });
    private final String awsAccountId;
    private final String purchaseMode;

    private UpdateSpiceCapacityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.purchaseMode = builder.purchaseMode;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final PurchaseMode purchaseMode() {
        return PurchaseMode.fromValue(this.purchaseMode);
    }

    public final String purchaseModeAsString() {
        return this.purchaseMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSpiceCapacityConfigurationRequest)) {
            return false;
        }
        UpdateSpiceCapacityConfigurationRequest other = (UpdateSpiceCapacityConfigurationRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.purchaseModeAsString(), other.purchaseModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSpiceCapacityConfigurationRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("PurchaseMode", (Object)this.purchaseModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "PurchaseMode": {
                return Optional.ofNullable(clazz.cast(this.purchaseModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSpiceCapacityConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateSpiceCapacityConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String purchaseMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSpiceCapacityConfigurationRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.purchaseMode(model.purchaseMode);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getPurchaseMode() {
            return this.purchaseMode;
        }

        public final void setPurchaseMode(String purchaseMode) {
            this.purchaseMode = purchaseMode;
        }

        @Override
        public final Builder purchaseMode(String purchaseMode) {
            this.purchaseMode = purchaseMode;
            return this;
        }

        @Override
        public final Builder purchaseMode(PurchaseMode purchaseMode) {
            this.purchaseMode(purchaseMode == null ? null : purchaseMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSpiceCapacityConfigurationRequest build() {
            return new UpdateSpiceCapacityConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSpiceCapacityConfigurationRequest> {
        public Builder awsAccountId(String var1);

        public Builder purchaseMode(String var1);

        public Builder purchaseMode(PurchaseMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

