/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TopicUserExperienceVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TopicSummary.getter(TopicSummary::arn)).setter(TopicSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicId").getter(TopicSummary.getter(TopicSummary::topicId)).setter(TopicSummary.setter(Builder::topicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TopicSummary.getter(TopicSummary::name)).setter(TopicSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> USER_EXPERIENCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserExperienceVersion").getter(TopicSummary.getter(TopicSummary::userExperienceVersionAsString)).setter(TopicSummary.setter(Builder::userExperienceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserExperienceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TOPIC_ID_FIELD, NAME_FIELD, USER_EXPERIENCE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("TopicId", TOPIC_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("UserExperienceVersion", USER_EXPERIENCE_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String topicId;
    private final String name;
    private final String userExperienceVersion;

    private TopicSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.topicId = builder.topicId;
        this.name = builder.name;
        this.userExperienceVersion = builder.userExperienceVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public final String topicId() {
        return this.topicId;
    }

    public final String name() {
        return this.name;
    }

    public final TopicUserExperienceVersion userExperienceVersion() {
        return TopicUserExperienceVersion.fromValue(this.userExperienceVersion);
    }

    public final String userExperienceVersionAsString() {
        return this.userExperienceVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.userExperienceVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicSummary)) {
            return false;
        }
        TopicSummary other = (TopicSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.topicId(), other.topicId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.userExperienceVersionAsString(), other.userExperienceVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TopicSummary").add("Arn", (Object)this.arn()).add("TopicId", (Object)this.topicId()).add("Name", (Object)this.name()).add("UserExperienceVersion", (Object)this.userExperienceVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "TopicId": {
                return Optional.ofNullable(clazz.cast(this.topicId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "UserExperienceVersion": {
                return Optional.ofNullable(clazz.cast(this.userExperienceVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopicSummary, T> g) {
        return obj -> g.apply((TopicSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String topicId;
        private String name;
        private String userExperienceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicSummary model) {
            this.arn(model.arn);
            this.topicId(model.topicId);
            this.name(model.name);
            this.userExperienceVersion(model.userExperienceVersion);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTopicId() {
            return this.topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUserExperienceVersion() {
            return this.userExperienceVersion;
        }

        public final void setUserExperienceVersion(String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
        }

        @Override
        public final Builder userExperienceVersion(String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
            return this;
        }

        @Override
        public final Builder userExperienceVersion(TopicUserExperienceVersion userExperienceVersion) {
            this.userExperienceVersion(userExperienceVersion == null ? null : userExperienceVersion.toString());
            return this;
        }

        public TopicSummary build() {
            return new TopicSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicSummary> {
        public Builder arn(String var1);

        public Builder topicId(String var1);

        public Builder name(String var1);

        public Builder userExperienceVersion(String var1);

        public Builder userExperienceVersion(TopicUserExperienceVersion var1);
    }
}

