/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.AggFunctionParamMapCopier;
import software.amazon.awssdk.services.quicksight.model.AggType;
import software.amazon.awssdk.services.quicksight.model.AggregationPartitionBy;
import software.amazon.awssdk.services.quicksight.model.AggregationPartitionByListCopier;
import software.amazon.awssdk.services.quicksight.model.Anchor;
import software.amazon.awssdk.services.quicksight.model.FilterAggMetrics;
import software.amazon.awssdk.services.quicksight.model.FilterAggMetricsListCopier;
import software.amazon.awssdk.services.quicksight.model.FilterClass;
import software.amazon.awssdk.services.quicksight.model.Identifier;
import software.amazon.awssdk.services.quicksight.model.NullFilterOption;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.services.quicksight.model.TopicConstantValue;
import software.amazon.awssdk.services.quicksight.model.TopicIRFilterFunction;
import software.amazon.awssdk.services.quicksight.model.TopicIRFilterType;
import software.amazon.awssdk.services.quicksight.model.TopicSortDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicIRFilterOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicIRFilterOption> {
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterType").getter(TopicIRFilterOption.getter(TopicIRFilterOption::filterTypeAsString)).setter(TopicIRFilterOption.setter(Builder::filterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterType").build()}).build();
    private static final SdkField<String> FILTER_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterClass").getter(TopicIRFilterOption.getter(TopicIRFilterOption::filterClassAsString)).setter(TopicIRFilterOption.setter(Builder::filterClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterClass").build()}).build();
    private static final SdkField<Identifier> OPERAND_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperandField").getter(TopicIRFilterOption.getter(TopicIRFilterOption::operandField)).setter(TopicIRFilterOption.setter(Builder::operandField)).constructor(Identifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperandField").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Function").getter(TopicIRFilterOption.getter(TopicIRFilterOption::functionAsString)).setter(TopicIRFilterOption.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()}).build();
    private static final SdkField<TopicConstantValue> CONSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constant").getter(TopicIRFilterOption.getter(TopicIRFilterOption::constant)).setter(TopicIRFilterOption.setter(Builder::constant)).constructor(TopicConstantValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()}).build();
    private static final SdkField<Boolean> INVERSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Inverse").getter(TopicIRFilterOption.getter(TopicIRFilterOption::inverse)).setter(TopicIRFilterOption.setter(Builder::inverse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverse").build()}).build();
    private static final SdkField<String> NULL_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullFilter").getter(TopicIRFilterOption.getter(TopicIRFilterOption::nullFilterAsString)).setter(TopicIRFilterOption.setter(Builder::nullFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullFilter").build()}).build();
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Aggregation").getter(TopicIRFilterOption.getter(TopicIRFilterOption::aggregationAsString)).setter(TopicIRFilterOption.setter(Builder::aggregation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()}).build();
    private static final SdkField<Map<String, String>> AGGREGATION_FUNCTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AggregationFunctionParameters").getter(TopicIRFilterOption.getter(TopicIRFilterOption::aggregationFunctionParameters)).setter(TopicIRFilterOption.setter(Builder::aggregationFunctionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunctionParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AggregationPartitionBy>> AGGREGATION_PARTITION_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggregationPartitionBy").getter(TopicIRFilterOption.getter(TopicIRFilterOption::aggregationPartitionBy)).setter(TopicIRFilterOption.setter(Builder::aggregationPartitionBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPartitionBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationPartitionBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TopicConstantValue> RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Range").getter(TopicIRFilterOption.getter(TopicIRFilterOption::range)).setter(TopicIRFilterOption.setter(Builder::range)).constructor(TopicConstantValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()}).build();
    private static final SdkField<Boolean> INCLUSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Inclusive").getter(TopicIRFilterOption.getter(TopicIRFilterOption::inclusive)).setter(TopicIRFilterOption.setter(Builder::inclusive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inclusive").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(TopicIRFilterOption.getter(TopicIRFilterOption::timeGranularityAsString)).setter(TopicIRFilterOption.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final SdkField<TopicConstantValue> LAST_NEXT_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastNextOffset").getter(TopicIRFilterOption.getter(TopicIRFilterOption::lastNextOffset)).setter(TopicIRFilterOption.setter(Builder::lastNextOffset)).constructor(TopicConstantValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastNextOffset").build()}).build();
    private static final SdkField<List<FilterAggMetrics>> AGG_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggMetrics").getter(TopicIRFilterOption.getter(TopicIRFilterOption::aggMetrics)).setter(TopicIRFilterOption.setter(Builder::aggMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterAggMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TopicConstantValue> TOP_BOTTOM_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TopBottomLimit").getter(TopicIRFilterOption.getter(TopicIRFilterOption::topBottomLimit)).setter(TopicIRFilterOption.setter(Builder::topBottomLimit)).constructor(TopicConstantValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopBottomLimit").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortDirection").getter(TopicIRFilterOption.getter(TopicIRFilterOption::sortDirectionAsString)).setter(TopicIRFilterOption.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()}).build();
    private static final SdkField<Anchor> ANCHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Anchor").getter(TopicIRFilterOption.getter(TopicIRFilterOption::anchor)).setter(TopicIRFilterOption.setter(Builder::anchor)).constructor(Anchor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Anchor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_TYPE_FIELD, FILTER_CLASS_FIELD, OPERAND_FIELD_FIELD, FUNCTION_FIELD, CONSTANT_FIELD, INVERSE_FIELD, NULL_FILTER_FIELD, AGGREGATION_FIELD, AGGREGATION_FUNCTION_PARAMETERS_FIELD, AGGREGATION_PARTITION_BY_FIELD, RANGE_FIELD, INCLUSIVE_FIELD, TIME_GRANULARITY_FIELD, LAST_NEXT_OFFSET_FIELD, AGG_METRICS_FIELD, TOP_BOTTOM_LIMIT_FIELD, SORT_DIRECTION_FIELD, ANCHOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FilterType", FILTER_TYPE_FIELD);
            this.put("FilterClass", FILTER_CLASS_FIELD);
            this.put("OperandField", OPERAND_FIELD_FIELD);
            this.put("Function", FUNCTION_FIELD);
            this.put("Constant", CONSTANT_FIELD);
            this.put("Inverse", INVERSE_FIELD);
            this.put("NullFilter", NULL_FILTER_FIELD);
            this.put("Aggregation", AGGREGATION_FIELD);
            this.put("AggregationFunctionParameters", AGGREGATION_FUNCTION_PARAMETERS_FIELD);
            this.put("AggregationPartitionBy", AGGREGATION_PARTITION_BY_FIELD);
            this.put("Range", RANGE_FIELD);
            this.put("Inclusive", INCLUSIVE_FIELD);
            this.put("TimeGranularity", TIME_GRANULARITY_FIELD);
            this.put("LastNextOffset", LAST_NEXT_OFFSET_FIELD);
            this.put("AggMetrics", AGG_METRICS_FIELD);
            this.put("TopBottomLimit", TOP_BOTTOM_LIMIT_FIELD);
            this.put("SortDirection", SORT_DIRECTION_FIELD);
            this.put("Anchor", ANCHOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String filterType;
    private final String filterClass;
    private final Identifier operandField;
    private final String function;
    private final TopicConstantValue constant;
    private final Boolean inverse;
    private final String nullFilter;
    private final String aggregation;
    private final Map<String, String> aggregationFunctionParameters;
    private final List<AggregationPartitionBy> aggregationPartitionBy;
    private final TopicConstantValue range;
    private final Boolean inclusive;
    private final String timeGranularity;
    private final TopicConstantValue lastNextOffset;
    private final List<FilterAggMetrics> aggMetrics;
    private final TopicConstantValue topBottomLimit;
    private final String sortDirection;
    private final Anchor anchor;

    private TopicIRFilterOption(BuilderImpl builder) {
        this.filterType = builder.filterType;
        this.filterClass = builder.filterClass;
        this.operandField = builder.operandField;
        this.function = builder.function;
        this.constant = builder.constant;
        this.inverse = builder.inverse;
        this.nullFilter = builder.nullFilter;
        this.aggregation = builder.aggregation;
        this.aggregationFunctionParameters = builder.aggregationFunctionParameters;
        this.aggregationPartitionBy = builder.aggregationPartitionBy;
        this.range = builder.range;
        this.inclusive = builder.inclusive;
        this.timeGranularity = builder.timeGranularity;
        this.lastNextOffset = builder.lastNextOffset;
        this.aggMetrics = builder.aggMetrics;
        this.topBottomLimit = builder.topBottomLimit;
        this.sortDirection = builder.sortDirection;
        this.anchor = builder.anchor;
    }

    public final TopicIRFilterType filterType() {
        return TopicIRFilterType.fromValue(this.filterType);
    }

    public final String filterTypeAsString() {
        return this.filterType;
    }

    public final FilterClass filterClass() {
        return FilterClass.fromValue(this.filterClass);
    }

    public final String filterClassAsString() {
        return this.filterClass;
    }

    public final Identifier operandField() {
        return this.operandField;
    }

    public final TopicIRFilterFunction function() {
        return TopicIRFilterFunction.fromValue(this.function);
    }

    public final String functionAsString() {
        return this.function;
    }

    public final TopicConstantValue constant() {
        return this.constant;
    }

    public final Boolean inverse() {
        return this.inverse;
    }

    public final NullFilterOption nullFilter() {
        return NullFilterOption.fromValue(this.nullFilter);
    }

    public final String nullFilterAsString() {
        return this.nullFilter;
    }

    public final AggType aggregation() {
        return AggType.fromValue(this.aggregation);
    }

    public final String aggregationAsString() {
        return this.aggregation;
    }

    public final boolean hasAggregationFunctionParameters() {
        return this.aggregationFunctionParameters != null && !(this.aggregationFunctionParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> aggregationFunctionParameters() {
        return this.aggregationFunctionParameters;
    }

    public final boolean hasAggregationPartitionBy() {
        return this.aggregationPartitionBy != null && !(this.aggregationPartitionBy instanceof SdkAutoConstructList);
    }

    public final List<AggregationPartitionBy> aggregationPartitionBy() {
        return this.aggregationPartitionBy;
    }

    public final TopicConstantValue range() {
        return this.range;
    }

    public final Boolean inclusive() {
        return this.inclusive;
    }

    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public final TopicConstantValue lastNextOffset() {
        return this.lastNextOffset;
    }

    public final boolean hasAggMetrics() {
        return this.aggMetrics != null && !(this.aggMetrics instanceof SdkAutoConstructList);
    }

    public final List<FilterAggMetrics> aggMetrics() {
        return this.aggMetrics;
    }

    public final TopicConstantValue topBottomLimit() {
        return this.topBottomLimit;
    }

    public final TopicSortDirection sortDirection() {
        return TopicSortDirection.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    public final Anchor anchor() {
        return this.anchor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operandField());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.constant());
        hashCode = 31 * hashCode + Objects.hashCode(this.inverse());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregationFunctionParameters() ? this.aggregationFunctionParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregationPartitionBy() ? this.aggregationPartitionBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.range());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusive());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastNextOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggMetrics() ? this.aggMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.topBottomLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.anchor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRFilterOption)) {
            return false;
        }
        TopicIRFilterOption other = (TopicIRFilterOption)obj;
        return Objects.equals(this.filterTypeAsString(), other.filterTypeAsString()) && Objects.equals(this.filterClassAsString(), other.filterClassAsString()) && Objects.equals(this.operandField(), other.operandField()) && Objects.equals(this.functionAsString(), other.functionAsString()) && Objects.equals(this.constant(), other.constant()) && Objects.equals(this.inverse(), other.inverse()) && Objects.equals(this.nullFilterAsString(), other.nullFilterAsString()) && Objects.equals(this.aggregationAsString(), other.aggregationAsString()) && this.hasAggregationFunctionParameters() == other.hasAggregationFunctionParameters() && Objects.equals(this.aggregationFunctionParameters(), other.aggregationFunctionParameters()) && this.hasAggregationPartitionBy() == other.hasAggregationPartitionBy() && Objects.equals(this.aggregationPartitionBy(), other.aggregationPartitionBy()) && Objects.equals(this.range(), other.range()) && Objects.equals(this.inclusive(), other.inclusive()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString()) && Objects.equals(this.lastNextOffset(), other.lastNextOffset()) && this.hasAggMetrics() == other.hasAggMetrics() && Objects.equals(this.aggMetrics(), other.aggMetrics()) && Objects.equals(this.topBottomLimit(), other.topBottomLimit()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString()) && Objects.equals(this.anchor(), other.anchor());
    }

    public final String toString() {
        return ToString.builder((String)"TopicIRFilterOption").add("FilterType", (Object)this.filterTypeAsString()).add("FilterClass", (Object)this.filterClassAsString()).add("OperandField", (Object)this.operandField()).add("Function", (Object)this.functionAsString()).add("Constant", (Object)this.constant()).add("Inverse", (Object)this.inverse()).add("NullFilter", (Object)this.nullFilterAsString()).add("Aggregation", (Object)this.aggregationAsString()).add("AggregationFunctionParameters", this.hasAggregationFunctionParameters() ? this.aggregationFunctionParameters() : null).add("AggregationPartitionBy", this.hasAggregationPartitionBy() ? this.aggregationPartitionBy() : null).add("Range", (Object)this.range()).add("Inclusive", (Object)this.inclusive()).add("TimeGranularity", (Object)this.timeGranularityAsString()).add("LastNextOffset", (Object)this.lastNextOffset()).add("AggMetrics", this.hasAggMetrics() ? this.aggMetrics() : null).add("TopBottomLimit", (Object)this.topBottomLimit()).add("SortDirection", (Object)this.sortDirectionAsString()).add("Anchor", (Object)this.anchor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterType": {
                return Optional.ofNullable(clazz.cast(this.filterTypeAsString()));
            }
            case "FilterClass": {
                return Optional.ofNullable(clazz.cast(this.filterClassAsString()));
            }
            case "OperandField": {
                return Optional.ofNullable(clazz.cast(this.operandField()));
            }
            case "Function": {
                return Optional.ofNullable(clazz.cast(this.functionAsString()));
            }
            case "Constant": {
                return Optional.ofNullable(clazz.cast(this.constant()));
            }
            case "Inverse": {
                return Optional.ofNullable(clazz.cast(this.inverse()));
            }
            case "NullFilter": {
                return Optional.ofNullable(clazz.cast(this.nullFilterAsString()));
            }
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsString()));
            }
            case "AggregationFunctionParameters": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunctionParameters()));
            }
            case "AggregationPartitionBy": {
                return Optional.ofNullable(clazz.cast(this.aggregationPartitionBy()));
            }
            case "Range": {
                return Optional.ofNullable(clazz.cast(this.range()));
            }
            case "Inclusive": {
                return Optional.ofNullable(clazz.cast(this.inclusive()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
            case "LastNextOffset": {
                return Optional.ofNullable(clazz.cast(this.lastNextOffset()));
            }
            case "AggMetrics": {
                return Optional.ofNullable(clazz.cast(this.aggMetrics()));
            }
            case "TopBottomLimit": {
                return Optional.ofNullable(clazz.cast(this.topBottomLimit()));
            }
            case "SortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
            case "Anchor": {
                return Optional.ofNullable(clazz.cast(this.anchor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopicIRFilterOption, T> g) {
        return obj -> g.apply((TopicIRFilterOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterType;
        private String filterClass;
        private Identifier operandField;
        private String function;
        private TopicConstantValue constant;
        private Boolean inverse;
        private String nullFilter;
        private String aggregation;
        private Map<String, String> aggregationFunctionParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<AggregationPartitionBy> aggregationPartitionBy = DefaultSdkAutoConstructList.getInstance();
        private TopicConstantValue range;
        private Boolean inclusive;
        private String timeGranularity;
        private TopicConstantValue lastNextOffset;
        private List<FilterAggMetrics> aggMetrics = DefaultSdkAutoConstructList.getInstance();
        private TopicConstantValue topBottomLimit;
        private String sortDirection;
        private Anchor anchor;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRFilterOption model) {
            this.filterType(model.filterType);
            this.filterClass(model.filterClass);
            this.operandField(model.operandField);
            this.function(model.function);
            this.constant(model.constant);
            this.inverse(model.inverse);
            this.nullFilter(model.nullFilter);
            this.aggregation(model.aggregation);
            this.aggregationFunctionParameters(model.aggregationFunctionParameters);
            this.aggregationPartitionBy(model.aggregationPartitionBy);
            this.range(model.range);
            this.inclusive(model.inclusive);
            this.timeGranularity(model.timeGranularity);
            this.lastNextOffset(model.lastNextOffset);
            this.aggMetrics(model.aggMetrics);
            this.topBottomLimit(model.topBottomLimit);
            this.sortDirection(model.sortDirection);
            this.anchor(model.anchor);
        }

        public final String getFilterType() {
            return this.filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(TopicIRFilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final String getFilterClass() {
            return this.filterClass;
        }

        public final void setFilterClass(String filterClass) {
            this.filterClass = filterClass;
        }

        @Override
        public final Builder filterClass(String filterClass) {
            this.filterClass = filterClass;
            return this;
        }

        @Override
        public final Builder filterClass(FilterClass filterClass) {
            this.filterClass(filterClass == null ? null : filterClass.toString());
            return this;
        }

        public final Identifier.Builder getOperandField() {
            return this.operandField != null ? this.operandField.toBuilder() : null;
        }

        public final void setOperandField(Identifier.BuilderImpl operandField) {
            this.operandField = operandField != null ? operandField.build() : null;
        }

        @Override
        public final Builder operandField(Identifier operandField) {
            this.operandField = operandField;
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public final Builder function(TopicIRFilterFunction function) {
            this.function(function == null ? null : function.toString());
            return this;
        }

        public final TopicConstantValue.Builder getConstant() {
            return this.constant != null ? this.constant.toBuilder() : null;
        }

        public final void setConstant(TopicConstantValue.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicConstantValue constant) {
            this.constant = constant;
            return this;
        }

        public final Boolean getInverse() {
            return this.inverse;
        }

        public final void setInverse(Boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public final Builder inverse(Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public final String getNullFilter() {
            return this.nullFilter;
        }

        public final void setNullFilter(String nullFilter) {
            this.nullFilter = nullFilter;
        }

        @Override
        public final Builder nullFilter(String nullFilter) {
            this.nullFilter = nullFilter;
            return this;
        }

        @Override
        public final Builder nullFilter(NullFilterOption nullFilter) {
            this.nullFilter(nullFilter == null ? null : nullFilter.toString());
            return this;
        }

        public final String getAggregation() {
            return this.aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(AggType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final Map<String, String> getAggregationFunctionParameters() {
            if (this.aggregationFunctionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.aggregationFunctionParameters;
        }

        public final void setAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggFunctionParamMapCopier.copy(aggregationFunctionParameters);
        }

        @Override
        public final Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggFunctionParamMapCopier.copy(aggregationFunctionParameters);
            return this;
        }

        public final List<AggregationPartitionBy.Builder> getAggregationPartitionBy() {
            List<AggregationPartitionBy.Builder> result = AggregationPartitionByListCopier.copyToBuilder(this.aggregationPartitionBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregationPartitionBy(Collection<AggregationPartitionBy.BuilderImpl> aggregationPartitionBy) {
            this.aggregationPartitionBy = AggregationPartitionByListCopier.copyFromBuilder(aggregationPartitionBy);
        }

        @Override
        public final Builder aggregationPartitionBy(Collection<AggregationPartitionBy> aggregationPartitionBy) {
            this.aggregationPartitionBy = AggregationPartitionByListCopier.copy(aggregationPartitionBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationPartitionBy(AggregationPartitionBy ... aggregationPartitionBy) {
            this.aggregationPartitionBy(Arrays.asList(aggregationPartitionBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationPartitionBy(Consumer<AggregationPartitionBy.Builder> ... aggregationPartitionBy) {
            this.aggregationPartitionBy(Stream.of(aggregationPartitionBy).map(c -> (AggregationPartitionBy)((AggregationPartitionBy.Builder)AggregationPartitionBy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TopicConstantValue.Builder getRange() {
            return this.range != null ? this.range.toBuilder() : null;
        }

        public final void setRange(TopicConstantValue.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(TopicConstantValue range) {
            this.range = range;
            return this;
        }

        public final Boolean getInclusive() {
            return this.inclusive;
        }

        public final void setInclusive(Boolean inclusive) {
            this.inclusive = inclusive;
        }

        @Override
        public final Builder inclusive(Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final TopicConstantValue.Builder getLastNextOffset() {
            return this.lastNextOffset != null ? this.lastNextOffset.toBuilder() : null;
        }

        public final void setLastNextOffset(TopicConstantValue.BuilderImpl lastNextOffset) {
            this.lastNextOffset = lastNextOffset != null ? lastNextOffset.build() : null;
        }

        @Override
        public final Builder lastNextOffset(TopicConstantValue lastNextOffset) {
            this.lastNextOffset = lastNextOffset;
            return this;
        }

        public final List<FilterAggMetrics.Builder> getAggMetrics() {
            List<FilterAggMetrics.Builder> result = FilterAggMetricsListCopier.copyToBuilder(this.aggMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggMetrics(Collection<FilterAggMetrics.BuilderImpl> aggMetrics) {
            this.aggMetrics = FilterAggMetricsListCopier.copyFromBuilder(aggMetrics);
        }

        @Override
        public final Builder aggMetrics(Collection<FilterAggMetrics> aggMetrics) {
            this.aggMetrics = FilterAggMetricsListCopier.copy(aggMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggMetrics(FilterAggMetrics ... aggMetrics) {
            this.aggMetrics(Arrays.asList(aggMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggMetrics(Consumer<FilterAggMetrics.Builder> ... aggMetrics) {
            this.aggMetrics(Stream.of(aggMetrics).map(c -> (FilterAggMetrics)((FilterAggMetrics.Builder)FilterAggMetrics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TopicConstantValue.Builder getTopBottomLimit() {
            return this.topBottomLimit != null ? this.topBottomLimit.toBuilder() : null;
        }

        public final void setTopBottomLimit(TopicConstantValue.BuilderImpl topBottomLimit) {
            this.topBottomLimit = topBottomLimit != null ? topBottomLimit.build() : null;
        }

        @Override
        public final Builder topBottomLimit(TopicConstantValue topBottomLimit) {
            this.topBottomLimit = topBottomLimit;
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(TopicSortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public final Anchor.Builder getAnchor() {
            return this.anchor != null ? this.anchor.toBuilder() : null;
        }

        public final void setAnchor(Anchor.BuilderImpl anchor) {
            this.anchor = anchor != null ? anchor.build() : null;
        }

        @Override
        public final Builder anchor(Anchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public TopicIRFilterOption build() {
            return new TopicIRFilterOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicIRFilterOption> {
        public Builder filterType(String var1);

        public Builder filterType(TopicIRFilterType var1);

        public Builder filterClass(String var1);

        public Builder filterClass(FilterClass var1);

        public Builder operandField(Identifier var1);

        default public Builder operandField(Consumer<Identifier.Builder> operandField) {
            return this.operandField((Identifier)((Identifier.Builder)Identifier.builder().applyMutation(operandField)).build());
        }

        public Builder function(String var1);

        public Builder function(TopicIRFilterFunction var1);

        public Builder constant(TopicConstantValue var1);

        default public Builder constant(Consumer<TopicConstantValue.Builder> constant) {
            return this.constant((TopicConstantValue)((TopicConstantValue.Builder)TopicConstantValue.builder().applyMutation(constant)).build());
        }

        public Builder inverse(Boolean var1);

        public Builder nullFilter(String var1);

        public Builder nullFilter(NullFilterOption var1);

        public Builder aggregation(String var1);

        public Builder aggregation(AggType var1);

        public Builder aggregationFunctionParameters(Map<String, String> var1);

        public Builder aggregationPartitionBy(Collection<AggregationPartitionBy> var1);

        public Builder aggregationPartitionBy(AggregationPartitionBy ... var1);

        public Builder aggregationPartitionBy(Consumer<AggregationPartitionBy.Builder> ... var1);

        public Builder range(TopicConstantValue var1);

        default public Builder range(Consumer<TopicConstantValue.Builder> range) {
            return this.range((TopicConstantValue)((TopicConstantValue.Builder)TopicConstantValue.builder().applyMutation(range)).build());
        }

        public Builder inclusive(Boolean var1);

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TimeGranularity var1);

        public Builder lastNextOffset(TopicConstantValue var1);

        default public Builder lastNextOffset(Consumer<TopicConstantValue.Builder> lastNextOffset) {
            return this.lastNextOffset((TopicConstantValue)((TopicConstantValue.Builder)TopicConstantValue.builder().applyMutation(lastNextOffset)).build());
        }

        public Builder aggMetrics(Collection<FilterAggMetrics> var1);

        public Builder aggMetrics(FilterAggMetrics ... var1);

        public Builder aggMetrics(Consumer<FilterAggMetrics.Builder> ... var1);

        public Builder topBottomLimit(TopicConstantValue var1);

        default public Builder topBottomLimit(Consumer<TopicConstantValue.Builder> topBottomLimit) {
            return this.topBottomLimit((TopicConstantValue)((TopicConstantValue.Builder)TopicConstantValue.builder().applyMutation(topBottomLimit)).build());
        }

        public Builder sortDirection(String var1);

        public Builder sortDirection(TopicSortDirection var1);

        public Builder anchor(Anchor var1);

        default public Builder anchor(Consumer<Anchor.Builder> anchor) {
            return this.anchor((Anchor)((Anchor.Builder)Anchor.builder().applyMutation(anchor)).build());
        }
    }
}

