/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QAResult;
import software.amazon.awssdk.services.quicksight.model.QAResultsCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictQaResultsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, PredictQaResultsResponse> {
    private static final SdkField<QAResult> PRIMARY_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryResult").getter(PredictQaResultsResponse.getter(PredictQaResultsResponse::primaryResult)).setter(PredictQaResultsResponse.setter(Builder::primaryResult)).constructor(QAResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryResult").build()}).build();
    private static final SdkField<List<QAResult>> ADDITIONAL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalResults").getter(PredictQaResultsResponse.getter(PredictQaResultsResponse::additionalResults)).setter(PredictQaResultsResponse.setter(Builder::additionalResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QAResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(PredictQaResultsResponse.getter(PredictQaResultsResponse::requestId)).setter(PredictQaResultsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(PredictQaResultsResponse.getter(PredictQaResultsResponse::status)).setter(PredictQaResultsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_RESULT_FIELD, ADDITIONAL_RESULTS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PrimaryResult", PRIMARY_RESULT_FIELD);
            this.put("AdditionalResults", ADDITIONAL_RESULTS_FIELD);
            this.put("RequestId", REQUEST_ID_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final QAResult primaryResult;
    private final List<QAResult> additionalResults;
    private final String requestId;
    private final Integer status;

    private PredictQaResultsResponse(BuilderImpl builder) {
        super(builder);
        this.primaryResult = builder.primaryResult;
        this.additionalResults = builder.additionalResults;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final QAResult primaryResult() {
        return this.primaryResult;
    }

    public final boolean hasAdditionalResults() {
        return this.additionalResults != null && !(this.additionalResults instanceof SdkAutoConstructList);
    }

    public final List<QAResult> additionalResults() {
        return this.additionalResults;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalResults() ? this.additionalResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictQaResultsResponse)) {
            return false;
        }
        PredictQaResultsResponse other = (PredictQaResultsResponse)((Object)obj);
        return Objects.equals(this.primaryResult(), other.primaryResult()) && this.hasAdditionalResults() == other.hasAdditionalResults() && Objects.equals(this.additionalResults(), other.additionalResults()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"PredictQaResultsResponse").add("PrimaryResult", (Object)this.primaryResult()).add("AdditionalResults", this.hasAdditionalResults() ? this.additionalResults() : null).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryResult": {
                return Optional.ofNullable(clazz.cast(this.primaryResult()));
            }
            case "AdditionalResults": {
                return Optional.ofNullable(clazz.cast(this.additionalResults()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PredictQaResultsResponse, T> g) {
        return obj -> g.apply((PredictQaResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private QAResult primaryResult;
        private List<QAResult> additionalResults = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictQaResultsResponse model) {
            super(model);
            this.primaryResult(model.primaryResult);
            this.additionalResults(model.additionalResults);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final QAResult.Builder getPrimaryResult() {
            return this.primaryResult != null ? this.primaryResult.toBuilder() : null;
        }

        public final void setPrimaryResult(QAResult.BuilderImpl primaryResult) {
            this.primaryResult = primaryResult != null ? primaryResult.build() : null;
        }

        @Override
        public final Builder primaryResult(QAResult primaryResult) {
            this.primaryResult = primaryResult;
            return this;
        }

        public final List<QAResult.Builder> getAdditionalResults() {
            List<QAResult.Builder> result = QAResultsCopier.copyToBuilder(this.additionalResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalResults(Collection<QAResult.BuilderImpl> additionalResults) {
            this.additionalResults = QAResultsCopier.copyFromBuilder(additionalResults);
        }

        @Override
        public final Builder additionalResults(Collection<QAResult> additionalResults) {
            this.additionalResults = QAResultsCopier.copy(additionalResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResults(QAResult ... additionalResults) {
            this.additionalResults(Arrays.asList(additionalResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResults(Consumer<QAResult.Builder> ... additionalResults) {
            this.additionalResults(Stream.of(additionalResults).map(c -> (QAResult)((QAResult.Builder)QAResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public PredictQaResultsResponse build() {
            return new PredictQaResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PredictQaResultsResponse> {
        public Builder primaryResult(QAResult var1);

        default public Builder primaryResult(Consumer<QAResult.Builder> primaryResult) {
            return this.primaryResult((QAResult)((QAResult.Builder)QAResult.builder().applyMutation(primaryResult)).build());
        }

        public Builder additionalResults(Collection<QAResult> var1);

        public Builder additionalResults(QAResult ... var1);

        public Builder additionalResults(Consumer<QAResult.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

