/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.GridLayoutCanvasSizeOptions;
import software.amazon.awssdk.services.quicksight.model.GridLayoutElement;
import software.amazon.awssdk.services.quicksight.model.GridLayoutElementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GridLayoutConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GridLayoutConfiguration> {
    private static final SdkField<List<GridLayoutElement>> ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Elements").getter(GridLayoutConfiguration.getter(GridLayoutConfiguration::elements)).setter(GridLayoutConfiguration.setter(Builder::elements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GridLayoutElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GridLayoutCanvasSizeOptions> CANVAS_SIZE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CanvasSizeOptions").getter(GridLayoutConfiguration.getter(GridLayoutConfiguration::canvasSizeOptions)).setter(GridLayoutConfiguration.setter(Builder::canvasSizeOptions)).constructor(GridLayoutCanvasSizeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasSizeOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENTS_FIELD, CANVAS_SIZE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Elements", ELEMENTS_FIELD);
            this.put("CanvasSizeOptions", CANVAS_SIZE_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<GridLayoutElement> elements;
    private final GridLayoutCanvasSizeOptions canvasSizeOptions;

    private GridLayoutConfiguration(BuilderImpl builder) {
        this.elements = builder.elements;
        this.canvasSizeOptions = builder.canvasSizeOptions;
    }

    public final boolean hasElements() {
        return this.elements != null && !(this.elements instanceof SdkAutoConstructList);
    }

    public final List<GridLayoutElement> elements() {
        return this.elements;
    }

    public final GridLayoutCanvasSizeOptions canvasSizeOptions() {
        return this.canvasSizeOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElements() ? this.elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.canvasSizeOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridLayoutConfiguration)) {
            return false;
        }
        GridLayoutConfiguration other = (GridLayoutConfiguration)obj;
        return this.hasElements() == other.hasElements() && Objects.equals(this.elements(), other.elements()) && Objects.equals(this.canvasSizeOptions(), other.canvasSizeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"GridLayoutConfiguration").add("Elements", this.hasElements() ? this.elements() : null).add("CanvasSizeOptions", (Object)this.canvasSizeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Elements": {
                return Optional.ofNullable(clazz.cast(this.elements()));
            }
            case "CanvasSizeOptions": {
                return Optional.ofNullable(clazz.cast(this.canvasSizeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GridLayoutConfiguration, T> g) {
        return obj -> g.apply((GridLayoutConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GridLayoutElement> elements = DefaultSdkAutoConstructList.getInstance();
        private GridLayoutCanvasSizeOptions canvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(GridLayoutConfiguration model) {
            this.elements(model.elements);
            this.canvasSizeOptions(model.canvasSizeOptions);
        }

        public final List<GridLayoutElement.Builder> getElements() {
            List<GridLayoutElement.Builder> result = GridLayoutElementListCopier.copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<GridLayoutElement.BuilderImpl> elements) {
            this.elements = GridLayoutElementListCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<GridLayoutElement> elements) {
            this.elements = GridLayoutElementListCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(GridLayoutElement ... elements) {
            this.elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<GridLayoutElement.Builder> ... elements) {
            this.elements(Stream.of(elements).map(c -> (GridLayoutElement)((GridLayoutElement.Builder)GridLayoutElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GridLayoutCanvasSizeOptions.Builder getCanvasSizeOptions() {
            return this.canvasSizeOptions != null ? this.canvasSizeOptions.toBuilder() : null;
        }

        public final void setCanvasSizeOptions(GridLayoutCanvasSizeOptions.BuilderImpl canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions != null ? canvasSizeOptions.build() : null;
        }

        @Override
        public final Builder canvasSizeOptions(GridLayoutCanvasSizeOptions canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions;
            return this;
        }

        public GridLayoutConfiguration build() {
            return new GridLayoutConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GridLayoutConfiguration> {
        public Builder elements(Collection<GridLayoutElement> var1);

        public Builder elements(GridLayoutElement ... var1);

        public Builder elements(Consumer<GridLayoutElement.Builder> ... var1);

        public Builder canvasSizeOptions(GridLayoutCanvasSizeOptions var1);

        default public Builder canvasSizeOptions(Consumer<GridLayoutCanvasSizeOptions.Builder> canvasSizeOptions) {
            return this.canvasSizeOptions((GridLayoutCanvasSizeOptions)((GridLayoutCanvasSizeOptions.Builder)GridLayoutCanvasSizeOptions.builder().applyMutation(canvasSizeOptions)).build());
        }
    }
}

