/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DashboardErrorType {
    ACCESS_DENIED("ACCESS_DENIED"),
    SOURCE_NOT_FOUND("SOURCE_NOT_FOUND"),
    DATA_SET_NOT_FOUND("DATA_SET_NOT_FOUND"),
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    PARAMETER_VALUE_INCOMPATIBLE("PARAMETER_VALUE_INCOMPATIBLE"),
    PARAMETER_TYPE_INVALID("PARAMETER_TYPE_INVALID"),
    PARAMETER_NOT_FOUND("PARAMETER_NOT_FOUND"),
    COLUMN_TYPE_MISMATCH("COLUMN_TYPE_MISMATCH"),
    COLUMN_GEOGRAPHIC_ROLE_MISMATCH("COLUMN_GEOGRAPHIC_ROLE_MISMATCH"),
    COLUMN_REPLACEMENT_MISSING("COLUMN_REPLACEMENT_MISSING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DashboardErrorType> VALUE_MAP;
    private final String value;

    private DashboardErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DashboardErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DashboardErrorType> knownValues() {
        EnumSet<DashboardErrorType> knownValues = EnumSet.allOf(DashboardErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DashboardErrorType.class, DashboardErrorType::toString);
    }
}

