/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ArcOptions;
import software.amazon.awssdk.services.quicksight.model.DonutCenterOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DonutOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DonutOptions> {
    private static final SdkField<ArcOptions> ARC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArcOptions").getter(DonutOptions.getter(DonutOptions::arcOptions)).setter(DonutOptions.setter(Builder::arcOptions)).constructor(ArcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArcOptions").build()}).build();
    private static final SdkField<DonutCenterOptions> DONUT_CENTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DonutCenterOptions").getter(DonutOptions.getter(DonutOptions::donutCenterOptions)).setter(DonutOptions.setter(Builder::donutCenterOptions)).constructor(DonutCenterOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DonutCenterOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARC_OPTIONS_FIELD, DONUT_CENTER_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ArcOptions", ARC_OPTIONS_FIELD);
            this.put("DonutCenterOptions", DONUT_CENTER_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ArcOptions arcOptions;
    private final DonutCenterOptions donutCenterOptions;

    private DonutOptions(BuilderImpl builder) {
        this.arcOptions = builder.arcOptions;
        this.donutCenterOptions = builder.donutCenterOptions;
    }

    public final ArcOptions arcOptions() {
        return this.arcOptions;
    }

    public final DonutCenterOptions donutCenterOptions() {
        return this.donutCenterOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.donutCenterOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DonutOptions)) {
            return false;
        }
        DonutOptions other = (DonutOptions)obj;
        return Objects.equals(this.arcOptions(), other.arcOptions()) && Objects.equals(this.donutCenterOptions(), other.donutCenterOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DonutOptions").add("ArcOptions", (Object)this.arcOptions()).add("DonutCenterOptions", (Object)this.donutCenterOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArcOptions": {
                return Optional.ofNullable(clazz.cast(this.arcOptions()));
            }
            case "DonutCenterOptions": {
                return Optional.ofNullable(clazz.cast(this.donutCenterOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DonutOptions, T> g) {
        return obj -> g.apply((DonutOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ArcOptions arcOptions;
        private DonutCenterOptions donutCenterOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DonutOptions model) {
            this.arcOptions(model.arcOptions);
            this.donutCenterOptions(model.donutCenterOptions);
        }

        public final ArcOptions.Builder getArcOptions() {
            return this.arcOptions != null ? this.arcOptions.toBuilder() : null;
        }

        public final void setArcOptions(ArcOptions.BuilderImpl arcOptions) {
            this.arcOptions = arcOptions != null ? arcOptions.build() : null;
        }

        @Override
        public final Builder arcOptions(ArcOptions arcOptions) {
            this.arcOptions = arcOptions;
            return this;
        }

        public final DonutCenterOptions.Builder getDonutCenterOptions() {
            return this.donutCenterOptions != null ? this.donutCenterOptions.toBuilder() : null;
        }

        public final void setDonutCenterOptions(DonutCenterOptions.BuilderImpl donutCenterOptions) {
            this.donutCenterOptions = donutCenterOptions != null ? donutCenterOptions.build() : null;
        }

        @Override
        public final Builder donutCenterOptions(DonutCenterOptions donutCenterOptions) {
            this.donutCenterOptions = donutCenterOptions;
            return this;
        }

        public DonutOptions build() {
            return new DonutOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DonutOptions> {
        public Builder arcOptions(ArcOptions var1);

        default public Builder arcOptions(Consumer<ArcOptions.Builder> arcOptions) {
            return this.arcOptions((ArcOptions)((ArcOptions.Builder)ArcOptions.builder().applyMutation(arcOptions)).build());
        }

        public Builder donutCenterOptions(DonutCenterOptions var1);

        default public Builder donutCenterOptions(Consumer<DonutCenterOptions.Builder> donutCenterOptions) {
            return this.donutCenterOptions((DonutCenterOptions)((DonutCenterOptions.Builder)DonutCenterOptions.builder().applyMutation(donutCenterOptions)).build());
        }
    }
}

