/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TopicTimeGranularity {
    SECOND("SECOND"),
    MINUTE("MINUTE"),
    HOUR("HOUR"),
    DAY("DAY"),
    WEEK("WEEK"),
    MONTH("MONTH"),
    QUARTER("QUARTER"),
    YEAR("YEAR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TopicTimeGranularity> VALUE_MAP;
    private final String value;

    private TopicTimeGranularity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TopicTimeGranularity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TopicTimeGranularity> knownValues() {
        EnumSet<TopicTimeGranularity> knownValues = EnumSet.allOf(TopicTimeGranularity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TopicTimeGranularity.class, TopicTimeGranularity::toString);
    }
}

