/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TextAreaControlDisplayOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterTextAreaControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterTextAreaControl> {
    private static final SdkField<String> FILTER_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterControlId").getter(FilterTextAreaControl.getter(FilterTextAreaControl::filterControlId)).setter(FilterTextAreaControl.setter(Builder::filterControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterControlId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(FilterTextAreaControl.getter(FilterTextAreaControl::title)).setter(FilterTextAreaControl.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> SOURCE_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFilterId").getter(FilterTextAreaControl.getter(FilterTextAreaControl::sourceFilterId)).setter(FilterTextAreaControl.setter(Builder::sourceFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFilterId").build()}).build();
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(FilterTextAreaControl.getter(FilterTextAreaControl::delimiter)).setter(FilterTextAreaControl.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final SdkField<TextAreaControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayOptions").getter(FilterTextAreaControl.getter(FilterTextAreaControl::displayOptions)).setter(FilterTextAreaControl.setter(Builder::displayOptions)).constructor(TextAreaControlDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONTROL_ID_FIELD, TITLE_FIELD, SOURCE_FILTER_ID_FIELD, DELIMITER_FIELD, DISPLAY_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FilterControlId", FILTER_CONTROL_ID_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("SourceFilterId", SOURCE_FILTER_ID_FIELD);
            this.put("Delimiter", DELIMITER_FIELD);
            this.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String filterControlId;
    private final String title;
    private final String sourceFilterId;
    private final String delimiter;
    private final TextAreaControlDisplayOptions displayOptions;

    private FilterTextAreaControl(BuilderImpl builder) {
        this.filterControlId = builder.filterControlId;
        this.title = builder.title;
        this.sourceFilterId = builder.sourceFilterId;
        this.delimiter = builder.delimiter;
        this.displayOptions = builder.displayOptions;
    }

    public final String filterControlId() {
        return this.filterControlId;
    }

    public final String title() {
        return this.title;
    }

    public final String sourceFilterId() {
        return this.sourceFilterId;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final TextAreaControlDisplayOptions displayOptions() {
        return this.displayOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterTextAreaControl)) {
            return false;
        }
        FilterTextAreaControl other = (FilterTextAreaControl)obj;
        return Objects.equals(this.filterControlId(), other.filterControlId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.sourceFilterId(), other.sourceFilterId()) && Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.displayOptions(), other.displayOptions());
    }

    public final String toString() {
        return ToString.builder((String)"FilterTextAreaControl").add("FilterControlId", (Object)this.filterControlId()).add("Title", (Object)this.title()).add("SourceFilterId", (Object)this.sourceFilterId()).add("Delimiter", (Object)this.delimiter()).add("DisplayOptions", (Object)this.displayOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterControlId": {
                return Optional.ofNullable(clazz.cast(this.filterControlId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "SourceFilterId": {
                return Optional.ofNullable(clazz.cast(this.sourceFilterId()));
            }
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "DisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.displayOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FilterTextAreaControl, T> g) {
        return obj -> g.apply((FilterTextAreaControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterControlId;
        private String title;
        private String sourceFilterId;
        private String delimiter;
        private TextAreaControlDisplayOptions displayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterTextAreaControl model) {
            this.filterControlId(model.filterControlId);
            this.title(model.title);
            this.sourceFilterId(model.sourceFilterId);
            this.delimiter(model.delimiter);
            this.displayOptions(model.displayOptions);
        }

        public final String getFilterControlId() {
            return this.filterControlId;
        }

        public final void setFilterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
        }

        @Override
        public final Builder filterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceFilterId() {
            return this.sourceFilterId;
        }

        public final void setSourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
        }

        @Override
        public final Builder sourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
            return this;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final TextAreaControlDisplayOptions.Builder getDisplayOptions() {
            return this.displayOptions != null ? this.displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(TextAreaControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(TextAreaControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public FilterTextAreaControl build() {
            return new FilterTextAreaControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterTextAreaControl> {
        public Builder filterControlId(String var1);

        public Builder title(String var1);

        public Builder sourceFilterId(String var1);

        public Builder delimiter(String var1);

        public Builder displayOptions(TextAreaControlDisplayOptions var1);

        default public Builder displayOptions(Consumer<TextAreaControlDisplayOptions.Builder> displayOptions) {
            return this.displayOptions((TextAreaControlDisplayOptions)((TextAreaControlDisplayOptions.Builder)TextAreaControlDisplayOptions.builder().applyMutation(displayOptions)).build());
        }
    }
}

