/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BigQueryParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BigQueryParameters> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectId").getter(BigQueryParameters.getter(BigQueryParameters::projectId)).setter(BigQueryParameters.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()}).build();
    private static final SdkField<String> DATA_SET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetRegion").getter(BigQueryParameters.getter(BigQueryParameters::dataSetRegion)).setter(BigQueryParameters.setter(Builder::dataSetRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD, DATA_SET_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProjectId", PROJECT_ID_FIELD);
            this.put("DataSetRegion", DATA_SET_REGION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String projectId;
    private final String dataSetRegion;

    private BigQueryParameters(BuilderImpl builder) {
        this.projectId = builder.projectId;
        this.dataSetRegion = builder.dataSetRegion;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String dataSetRegion() {
        return this.dataSetRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BigQueryParameters)) {
            return false;
        }
        BigQueryParameters other = (BigQueryParameters)obj;
        return Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.dataSetRegion(), other.dataSetRegion());
    }

    public final String toString() {
        return ToString.builder((String)"BigQueryParameters").add("ProjectId", (Object)this.projectId()).add("DataSetRegion", (Object)this.dataSetRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "DataSetRegion": {
                return Optional.ofNullable(clazz.cast(this.dataSetRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BigQueryParameters, T> g) {
        return obj -> g.apply((BigQueryParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectId;
        private String dataSetRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(BigQueryParameters model) {
            this.projectId(model.projectId);
            this.dataSetRegion(model.dataSetRegion);
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getDataSetRegion() {
            return this.dataSetRegion;
        }

        public final void setDataSetRegion(String dataSetRegion) {
            this.dataSetRegion = dataSetRegion;
        }

        @Override
        public final Builder dataSetRegion(String dataSetRegion) {
            this.dataSetRegion = dataSetRegion;
            return this;
        }

        public BigQueryParameters build() {
            return new BigQueryParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BigQueryParameters> {
        public Builder projectId(String var1);

        public Builder dataSetRegion(String var1);
    }
}

