/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataPathColor;
import software.amazon.awssdk.services.quicksight.model.DataPathColorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VisualPalette
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VisualPalette> {
    private static final SdkField<String> CHART_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChartColor").getter(VisualPalette.getter(VisualPalette::chartColor)).setter(VisualPalette.setter(Builder::chartColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChartColor").build()}).build();
    private static final SdkField<List<DataPathColor>> COLOR_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColorMap").getter(VisualPalette.getter(VisualPalette::colorMap)).setter(VisualPalette.setter(Builder::colorMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorMap").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataPathColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHART_COLOR_FIELD, COLOR_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChartColor", CHART_COLOR_FIELD);
            this.put("ColorMap", COLOR_MAP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String chartColor;
    private final List<DataPathColor> colorMap;

    private VisualPalette(BuilderImpl builder) {
        this.chartColor = builder.chartColor;
        this.colorMap = builder.colorMap;
    }

    public final String chartColor() {
        return this.chartColor;
    }

    public final boolean hasColorMap() {
        return this.colorMap != null && !(this.colorMap instanceof SdkAutoConstructList);
    }

    public final List<DataPathColor> colorMap() {
        return this.colorMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.chartColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColorMap() ? this.colorMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualPalette)) {
            return false;
        }
        VisualPalette other = (VisualPalette)obj;
        return Objects.equals(this.chartColor(), other.chartColor()) && this.hasColorMap() == other.hasColorMap() && Objects.equals(this.colorMap(), other.colorMap());
    }

    public final String toString() {
        return ToString.builder((String)"VisualPalette").add("ChartColor", (Object)this.chartColor()).add("ColorMap", this.hasColorMap() ? this.colorMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChartColor": {
                return Optional.ofNullable(clazz.cast(this.chartColor()));
            }
            case "ColorMap": {
                return Optional.ofNullable(clazz.cast(this.colorMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VisualPalette, T> g) {
        return obj -> g.apply((VisualPalette)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String chartColor;
        private List<DataPathColor> colorMap = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VisualPalette model) {
            this.chartColor(model.chartColor);
            this.colorMap(model.colorMap);
        }

        public final String getChartColor() {
            return this.chartColor;
        }

        public final void setChartColor(String chartColor) {
            this.chartColor = chartColor;
        }

        @Override
        public final Builder chartColor(String chartColor) {
            this.chartColor = chartColor;
            return this;
        }

        public final List<DataPathColor.Builder> getColorMap() {
            List<DataPathColor.Builder> result = DataPathColorListCopier.copyToBuilder(this.colorMap);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColorMap(Collection<DataPathColor.BuilderImpl> colorMap) {
            this.colorMap = DataPathColorListCopier.copyFromBuilder(colorMap);
        }

        @Override
        public final Builder colorMap(Collection<DataPathColor> colorMap) {
            this.colorMap = DataPathColorListCopier.copy(colorMap);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorMap(DataPathColor ... colorMap) {
            this.colorMap(Arrays.asList(colorMap));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorMap(Consumer<DataPathColor.Builder> ... colorMap) {
            this.colorMap(Stream.of(colorMap).map(c -> (DataPathColor)((DataPathColor.Builder)DataPathColor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VisualPalette build() {
            return new VisualPalette(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VisualPalette> {
        public Builder chartColor(String var1);

        public Builder colorMap(Collection<DataPathColor> var1);

        public Builder colorMap(DataPathColor ... var1);

        public Builder colorMap(Consumer<DataPathColor.Builder> ... var1);
    }
}

