/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.GeospatialLayerItem;
import software.amazon.awssdk.services.quicksight.model.GeospatialMapLayerListCopier;
import software.amazon.awssdk.services.quicksight.model.GeospatialMapState;
import software.amazon.awssdk.services.quicksight.model.GeospatialMapStyle;
import software.amazon.awssdk.services.quicksight.model.LegendOptions;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialLayerMapConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialLayerMapConfiguration> {
    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Legend").getter(GeospatialLayerMapConfiguration.getter(GeospatialLayerMapConfiguration::legend)).setter(GeospatialLayerMapConfiguration.setter(Builder::legend)).constructor(LegendOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()}).build();
    private static final SdkField<List<GeospatialLayerItem>> MAP_LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MapLayers").getter(GeospatialLayerMapConfiguration.getter(GeospatialLayerMapConfiguration::mapLayers)).setter(GeospatialLayerMapConfiguration.setter(Builder::mapLayers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapLayers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeospatialLayerItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GeospatialMapState> MAP_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MapState").getter(GeospatialLayerMapConfiguration.getter(GeospatialLayerMapConfiguration::mapState)).setter(GeospatialLayerMapConfiguration.setter(Builder::mapState)).constructor(GeospatialMapState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapState").build()}).build();
    private static final SdkField<GeospatialMapStyle> MAP_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MapStyle").getter(GeospatialLayerMapConfiguration.getter(GeospatialLayerMapConfiguration::mapStyle)).setter(GeospatialLayerMapConfiguration.setter(Builder::mapStyle)).constructor(GeospatialMapStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapStyle").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(GeospatialLayerMapConfiguration.getter(GeospatialLayerMapConfiguration::interactions)).setter(GeospatialLayerMapConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEGEND_FIELD, MAP_LAYERS_FIELD, MAP_STATE_FIELD, MAP_STYLE_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Legend", LEGEND_FIELD);
            this.put("MapLayers", MAP_LAYERS_FIELD);
            this.put("MapState", MAP_STATE_FIELD);
            this.put("MapStyle", MAP_STYLE_FIELD);
            this.put("Interactions", INTERACTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final LegendOptions legend;
    private final List<GeospatialLayerItem> mapLayers;
    private final GeospatialMapState mapState;
    private final GeospatialMapStyle mapStyle;
    private final VisualInteractionOptions interactions;

    private GeospatialLayerMapConfiguration(BuilderImpl builder) {
        this.legend = builder.legend;
        this.mapLayers = builder.mapLayers;
        this.mapState = builder.mapState;
        this.mapStyle = builder.mapStyle;
        this.interactions = builder.interactions;
    }

    public final LegendOptions legend() {
        return this.legend;
    }

    public final boolean hasMapLayers() {
        return this.mapLayers != null && !(this.mapLayers instanceof SdkAutoConstructList);
    }

    public final List<GeospatialLayerItem> mapLayers() {
        return this.mapLayers;
    }

    public final GeospatialMapState mapState() {
        return this.mapState;
    }

    public final GeospatialMapStyle mapStyle() {
        return this.mapStyle;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.legend());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapLayers() ? this.mapLayers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mapState());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLayerMapConfiguration)) {
            return false;
        }
        GeospatialLayerMapConfiguration other = (GeospatialLayerMapConfiguration)obj;
        return Objects.equals(this.legend(), other.legend()) && this.hasMapLayers() == other.hasMapLayers() && Objects.equals(this.mapLayers(), other.mapLayers()) && Objects.equals(this.mapState(), other.mapState()) && Objects.equals(this.mapStyle(), other.mapStyle()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialLayerMapConfiguration").add("Legend", (Object)this.legend()).add("MapLayers", this.hasMapLayers() ? this.mapLayers() : null).add("MapState", (Object)this.mapState()).add("MapStyle", (Object)this.mapStyle()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Legend": {
                return Optional.ofNullable(clazz.cast(this.legend()));
            }
            case "MapLayers": {
                return Optional.ofNullable(clazz.cast(this.mapLayers()));
            }
            case "MapState": {
                return Optional.ofNullable(clazz.cast(this.mapState()));
            }
            case "MapStyle": {
                return Optional.ofNullable(clazz.cast(this.mapStyle()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLayerMapConfiguration, T> g) {
        return obj -> g.apply((GeospatialLayerMapConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LegendOptions legend;
        private List<GeospatialLayerItem> mapLayers = DefaultSdkAutoConstructList.getInstance();
        private GeospatialMapState mapState;
        private GeospatialMapStyle mapStyle;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLayerMapConfiguration model) {
            this.legend(model.legend);
            this.mapLayers(model.mapLayers);
            this.mapState(model.mapState);
            this.mapStyle(model.mapStyle);
            this.interactions(model.interactions);
        }

        public final LegendOptions.Builder getLegend() {
            return this.legend != null ? this.legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final List<GeospatialLayerItem.Builder> getMapLayers() {
            List<GeospatialLayerItem.Builder> result = GeospatialMapLayerListCopier.copyToBuilder(this.mapLayers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapLayers(Collection<GeospatialLayerItem.BuilderImpl> mapLayers) {
            this.mapLayers = GeospatialMapLayerListCopier.copyFromBuilder(mapLayers);
        }

        @Override
        public final Builder mapLayers(Collection<GeospatialLayerItem> mapLayers) {
            this.mapLayers = GeospatialMapLayerListCopier.copy(mapLayers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapLayers(GeospatialLayerItem ... mapLayers) {
            this.mapLayers(Arrays.asList(mapLayers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapLayers(Consumer<GeospatialLayerItem.Builder> ... mapLayers) {
            this.mapLayers(Stream.of(mapLayers).map(c -> (GeospatialLayerItem)((GeospatialLayerItem.Builder)GeospatialLayerItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GeospatialMapState.Builder getMapState() {
            return this.mapState != null ? this.mapState.toBuilder() : null;
        }

        public final void setMapState(GeospatialMapState.BuilderImpl mapState) {
            this.mapState = mapState != null ? mapState.build() : null;
        }

        @Override
        public final Builder mapState(GeospatialMapState mapState) {
            this.mapState = mapState;
            return this;
        }

        public final GeospatialMapStyle.Builder getMapStyle() {
            return this.mapStyle != null ? this.mapStyle.toBuilder() : null;
        }

        public final void setMapStyle(GeospatialMapStyle.BuilderImpl mapStyle) {
            this.mapStyle = mapStyle != null ? mapStyle.build() : null;
        }

        @Override
        public final Builder mapStyle(GeospatialMapStyle mapStyle) {
            this.mapStyle = mapStyle;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public GeospatialLayerMapConfiguration build() {
            return new GeospatialLayerMapConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialLayerMapConfiguration> {
        public Builder legend(LegendOptions var1);

        default public Builder legend(Consumer<LegendOptions.Builder> legend) {
            return this.legend((LegendOptions)((LegendOptions.Builder)LegendOptions.builder().applyMutation(legend)).build());
        }

        public Builder mapLayers(Collection<GeospatialLayerItem> var1);

        public Builder mapLayers(GeospatialLayerItem ... var1);

        public Builder mapLayers(Consumer<GeospatialLayerItem.Builder> ... var1);

        public Builder mapState(GeospatialMapState var1);

        default public Builder mapState(Consumer<GeospatialMapState.Builder> mapState) {
            return this.mapState((GeospatialMapState)((GeospatialMapState.Builder)GeospatialMapState.builder().applyMutation(mapState)).build());
        }

        public Builder mapStyle(GeospatialMapStyle var1);

        default public Builder mapStyle(Consumer<GeospatialMapStyle.Builder> mapStyle) {
            return this.mapStyle((GeospatialMapStyle)((GeospatialMapStyle.Builder)GeospatialMapStyle.builder().applyMutation(mapStyle)).build());
        }

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

