/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TopicTimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataAggregation> {
    private static final SdkField<String> DATASET_ROW_DATE_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetRowDateGranularity").getter(DataAggregation.getter(DataAggregation::datasetRowDateGranularityAsString)).setter(DataAggregation.setter(Builder::datasetRowDateGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetRowDateGranularity").build()}).build();
    private static final SdkField<String> DEFAULT_DATE_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultDateColumnName").getter(DataAggregation.getter(DataAggregation::defaultDateColumnName)).setter(DataAggregation.setter(Builder::defaultDateColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDateColumnName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ROW_DATE_GRANULARITY_FIELD, DEFAULT_DATE_COLUMN_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatasetRowDateGranularity", DATASET_ROW_DATE_GRANULARITY_FIELD);
            this.put("DefaultDateColumnName", DEFAULT_DATE_COLUMN_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String datasetRowDateGranularity;
    private final String defaultDateColumnName;

    private DataAggregation(BuilderImpl builder) {
        this.datasetRowDateGranularity = builder.datasetRowDateGranularity;
        this.defaultDateColumnName = builder.defaultDateColumnName;
    }

    public final TopicTimeGranularity datasetRowDateGranularity() {
        return TopicTimeGranularity.fromValue(this.datasetRowDateGranularity);
    }

    public final String datasetRowDateGranularityAsString() {
        return this.datasetRowDateGranularity;
    }

    public final String defaultDateColumnName() {
        return this.defaultDateColumnName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetRowDateGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultDateColumnName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataAggregation)) {
            return false;
        }
        DataAggregation other = (DataAggregation)obj;
        return Objects.equals(this.datasetRowDateGranularityAsString(), other.datasetRowDateGranularityAsString()) && Objects.equals(this.defaultDateColumnName(), other.defaultDateColumnName());
    }

    public final String toString() {
        return ToString.builder((String)"DataAggregation").add("DatasetRowDateGranularity", (Object)this.datasetRowDateGranularityAsString()).add("DefaultDateColumnName", (Object)this.defaultDateColumnName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetRowDateGranularity": {
                return Optional.ofNullable(clazz.cast(this.datasetRowDateGranularityAsString()));
            }
            case "DefaultDateColumnName": {
                return Optional.ofNullable(clazz.cast(this.defaultDateColumnName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataAggregation, T> g) {
        return obj -> g.apply((DataAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetRowDateGranularity;
        private String defaultDateColumnName;

        private BuilderImpl() {
        }

        private BuilderImpl(DataAggregation model) {
            this.datasetRowDateGranularity(model.datasetRowDateGranularity);
            this.defaultDateColumnName(model.defaultDateColumnName);
        }

        public final String getDatasetRowDateGranularity() {
            return this.datasetRowDateGranularity;
        }

        public final void setDatasetRowDateGranularity(String datasetRowDateGranularity) {
            this.datasetRowDateGranularity = datasetRowDateGranularity;
        }

        @Override
        public final Builder datasetRowDateGranularity(String datasetRowDateGranularity) {
            this.datasetRowDateGranularity = datasetRowDateGranularity;
            return this;
        }

        @Override
        public final Builder datasetRowDateGranularity(TopicTimeGranularity datasetRowDateGranularity) {
            this.datasetRowDateGranularity(datasetRowDateGranularity == null ? null : datasetRowDateGranularity.toString());
            return this;
        }

        public final String getDefaultDateColumnName() {
            return this.defaultDateColumnName;
        }

        public final void setDefaultDateColumnName(String defaultDateColumnName) {
            this.defaultDateColumnName = defaultDateColumnName;
        }

        @Override
        public final Builder defaultDateColumnName(String defaultDateColumnName) {
            this.defaultDateColumnName = defaultDateColumnName;
            return this;
        }

        public DataAggregation build() {
            return new DataAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataAggregation> {
        public Builder datasetRowDateGranularity(String var1);

        public Builder datasetRowDateGranularity(TopicTimeGranularity var1);

        public Builder defaultDateColumnName(String var1);
    }
}

