/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AxisDataOptions;
import software.amazon.awssdk.services.quicksight.model.AxisTickLabelOptions;
import software.amazon.awssdk.services.quicksight.model.ScrollBarOptions;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AxisDisplayOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AxisDisplayOptions> {
    private static final SdkField<AxisTickLabelOptions> TICK_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TickLabelOptions").getter(AxisDisplayOptions.getter(AxisDisplayOptions::tickLabelOptions)).setter(AxisDisplayOptions.setter(Builder::tickLabelOptions)).constructor(AxisTickLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TickLabelOptions").build()}).build();
    private static final SdkField<String> AXIS_LINE_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AxisLineVisibility").getter(AxisDisplayOptions.getter(AxisDisplayOptions::axisLineVisibilityAsString)).setter(AxisDisplayOptions.setter(Builder::axisLineVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisLineVisibility").build()}).build();
    private static final SdkField<String> GRID_LINE_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GridLineVisibility").getter(AxisDisplayOptions.getter(AxisDisplayOptions::gridLineVisibilityAsString)).setter(AxisDisplayOptions.setter(Builder::gridLineVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GridLineVisibility").build()}).build();
    private static final SdkField<AxisDataOptions> DATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataOptions").getter(AxisDisplayOptions.getter(AxisDisplayOptions::dataOptions)).setter(AxisDisplayOptions.setter(Builder::dataOptions)).constructor(AxisDataOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOptions").build()}).build();
    private static final SdkField<ScrollBarOptions> SCROLLBAR_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScrollbarOptions").getter(AxisDisplayOptions.getter(AxisDisplayOptions::scrollbarOptions)).setter(AxisDisplayOptions.setter(Builder::scrollbarOptions)).constructor(ScrollBarOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScrollbarOptions").build()}).build();
    private static final SdkField<String> AXIS_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AxisOffset").getter(AxisDisplayOptions.getter(AxisDisplayOptions::axisOffset)).setter(AxisDisplayOptions.setter(Builder::axisOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisOffset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICK_LABEL_OPTIONS_FIELD, AXIS_LINE_VISIBILITY_FIELD, GRID_LINE_VISIBILITY_FIELD, DATA_OPTIONS_FIELD, SCROLLBAR_OPTIONS_FIELD, AXIS_OFFSET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TickLabelOptions", TICK_LABEL_OPTIONS_FIELD);
            this.put("AxisLineVisibility", AXIS_LINE_VISIBILITY_FIELD);
            this.put("GridLineVisibility", GRID_LINE_VISIBILITY_FIELD);
            this.put("DataOptions", DATA_OPTIONS_FIELD);
            this.put("ScrollbarOptions", SCROLLBAR_OPTIONS_FIELD);
            this.put("AxisOffset", AXIS_OFFSET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AxisTickLabelOptions tickLabelOptions;
    private final String axisLineVisibility;
    private final String gridLineVisibility;
    private final AxisDataOptions dataOptions;
    private final ScrollBarOptions scrollbarOptions;
    private final String axisOffset;

    private AxisDisplayOptions(BuilderImpl builder) {
        this.tickLabelOptions = builder.tickLabelOptions;
        this.axisLineVisibility = builder.axisLineVisibility;
        this.gridLineVisibility = builder.gridLineVisibility;
        this.dataOptions = builder.dataOptions;
        this.scrollbarOptions = builder.scrollbarOptions;
        this.axisOffset = builder.axisOffset;
    }

    public final AxisTickLabelOptions tickLabelOptions() {
        return this.tickLabelOptions;
    }

    public final Visibility axisLineVisibility() {
        return Visibility.fromValue(this.axisLineVisibility);
    }

    public final String axisLineVisibilityAsString() {
        return this.axisLineVisibility;
    }

    public final Visibility gridLineVisibility() {
        return Visibility.fromValue(this.gridLineVisibility);
    }

    public final String gridLineVisibilityAsString() {
        return this.gridLineVisibility;
    }

    public final AxisDataOptions dataOptions() {
        return this.dataOptions;
    }

    public final ScrollBarOptions scrollbarOptions() {
        return this.scrollbarOptions;
    }

    public final String axisOffset() {
        return this.axisOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tickLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.axisLineVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gridLineVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.scrollbarOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.axisOffset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisDisplayOptions)) {
            return false;
        }
        AxisDisplayOptions other = (AxisDisplayOptions)obj;
        return Objects.equals(this.tickLabelOptions(), other.tickLabelOptions()) && Objects.equals(this.axisLineVisibilityAsString(), other.axisLineVisibilityAsString()) && Objects.equals(this.gridLineVisibilityAsString(), other.gridLineVisibilityAsString()) && Objects.equals(this.dataOptions(), other.dataOptions()) && Objects.equals(this.scrollbarOptions(), other.scrollbarOptions()) && Objects.equals(this.axisOffset(), other.axisOffset());
    }

    public final String toString() {
        return ToString.builder((String)"AxisDisplayOptions").add("TickLabelOptions", (Object)this.tickLabelOptions()).add("AxisLineVisibility", (Object)this.axisLineVisibilityAsString()).add("GridLineVisibility", (Object)this.gridLineVisibilityAsString()).add("DataOptions", (Object)this.dataOptions()).add("ScrollbarOptions", (Object)this.scrollbarOptions()).add("AxisOffset", (Object)this.axisOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TickLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.tickLabelOptions()));
            }
            case "AxisLineVisibility": {
                return Optional.ofNullable(clazz.cast(this.axisLineVisibilityAsString()));
            }
            case "GridLineVisibility": {
                return Optional.ofNullable(clazz.cast(this.gridLineVisibilityAsString()));
            }
            case "DataOptions": {
                return Optional.ofNullable(clazz.cast(this.dataOptions()));
            }
            case "ScrollbarOptions": {
                return Optional.ofNullable(clazz.cast(this.scrollbarOptions()));
            }
            case "AxisOffset": {
                return Optional.ofNullable(clazz.cast(this.axisOffset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AxisDisplayOptions, T> g) {
        return obj -> g.apply((AxisDisplayOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AxisTickLabelOptions tickLabelOptions;
        private String axisLineVisibility;
        private String gridLineVisibility;
        private AxisDataOptions dataOptions;
        private ScrollBarOptions scrollbarOptions;
        private String axisOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisDisplayOptions model) {
            this.tickLabelOptions(model.tickLabelOptions);
            this.axisLineVisibility(model.axisLineVisibility);
            this.gridLineVisibility(model.gridLineVisibility);
            this.dataOptions(model.dataOptions);
            this.scrollbarOptions(model.scrollbarOptions);
            this.axisOffset(model.axisOffset);
        }

        public final AxisTickLabelOptions.Builder getTickLabelOptions() {
            return this.tickLabelOptions != null ? this.tickLabelOptions.toBuilder() : null;
        }

        public final void setTickLabelOptions(AxisTickLabelOptions.BuilderImpl tickLabelOptions) {
            this.tickLabelOptions = tickLabelOptions != null ? tickLabelOptions.build() : null;
        }

        @Override
        public final Builder tickLabelOptions(AxisTickLabelOptions tickLabelOptions) {
            this.tickLabelOptions = tickLabelOptions;
            return this;
        }

        public final String getAxisLineVisibility() {
            return this.axisLineVisibility;
        }

        public final void setAxisLineVisibility(String axisLineVisibility) {
            this.axisLineVisibility = axisLineVisibility;
        }

        @Override
        public final Builder axisLineVisibility(String axisLineVisibility) {
            this.axisLineVisibility = axisLineVisibility;
            return this;
        }

        @Override
        public final Builder axisLineVisibility(Visibility axisLineVisibility) {
            this.axisLineVisibility(axisLineVisibility == null ? null : axisLineVisibility.toString());
            return this;
        }

        public final String getGridLineVisibility() {
            return this.gridLineVisibility;
        }

        public final void setGridLineVisibility(String gridLineVisibility) {
            this.gridLineVisibility = gridLineVisibility;
        }

        @Override
        public final Builder gridLineVisibility(String gridLineVisibility) {
            this.gridLineVisibility = gridLineVisibility;
            return this;
        }

        @Override
        public final Builder gridLineVisibility(Visibility gridLineVisibility) {
            this.gridLineVisibility(gridLineVisibility == null ? null : gridLineVisibility.toString());
            return this;
        }

        public final AxisDataOptions.Builder getDataOptions() {
            return this.dataOptions != null ? this.dataOptions.toBuilder() : null;
        }

        public final void setDataOptions(AxisDataOptions.BuilderImpl dataOptions) {
            this.dataOptions = dataOptions != null ? dataOptions.build() : null;
        }

        @Override
        public final Builder dataOptions(AxisDataOptions dataOptions) {
            this.dataOptions = dataOptions;
            return this;
        }

        public final ScrollBarOptions.Builder getScrollbarOptions() {
            return this.scrollbarOptions != null ? this.scrollbarOptions.toBuilder() : null;
        }

        public final void setScrollbarOptions(ScrollBarOptions.BuilderImpl scrollbarOptions) {
            this.scrollbarOptions = scrollbarOptions != null ? scrollbarOptions.build() : null;
        }

        @Override
        public final Builder scrollbarOptions(ScrollBarOptions scrollbarOptions) {
            this.scrollbarOptions = scrollbarOptions;
            return this;
        }

        public final String getAxisOffset() {
            return this.axisOffset;
        }

        public final void setAxisOffset(String axisOffset) {
            this.axisOffset = axisOffset;
        }

        @Override
        public final Builder axisOffset(String axisOffset) {
            this.axisOffset = axisOffset;
            return this;
        }

        public AxisDisplayOptions build() {
            return new AxisDisplayOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AxisDisplayOptions> {
        public Builder tickLabelOptions(AxisTickLabelOptions var1);

        default public Builder tickLabelOptions(Consumer<AxisTickLabelOptions.Builder> tickLabelOptions) {
            return this.tickLabelOptions((AxisTickLabelOptions)((AxisTickLabelOptions.Builder)AxisTickLabelOptions.builder().applyMutation(tickLabelOptions)).build());
        }

        public Builder axisLineVisibility(String var1);

        public Builder axisLineVisibility(Visibility var1);

        public Builder gridLineVisibility(String var1);

        public Builder gridLineVisibility(Visibility var1);

        public Builder dataOptions(AxisDataOptions var1);

        default public Builder dataOptions(Consumer<AxisDataOptions.Builder> dataOptions) {
            return this.dataOptions((AxisDataOptions)((AxisDataOptions.Builder)AxisDataOptions.builder().applyMutation(dataOptions)).build());
        }

        public Builder scrollbarOptions(ScrollBarOptions var1);

        default public Builder scrollbarOptions(Consumer<ScrollBarOptions.Builder> scrollbarOptions) {
            return this.scrollbarOptions((ScrollBarOptions)((ScrollBarOptions.Builder)ScrollBarOptions.builder().applyMutation(scrollbarOptions)).build());
        }

        public Builder axisOffset(String var1);
    }
}

