/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.UpdateLinkPermissionListCopier;
import software.amazon.awssdk.services.quicksight.model.UpdateResourcePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardPermissionsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateDashboardPermissionsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateDashboardPermissionsRequest.getter(UpdateDashboardPermissionsRequest::awsAccountId)).setter(UpdateDashboardPermissionsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(UpdateDashboardPermissionsRequest.getter(UpdateDashboardPermissionsRequest::dashboardId)).setter(UpdateDashboardPermissionsRequest.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()}).build();
    private static final SdkField<List<ResourcePermission>> GRANT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantPermissions").getter(UpdateDashboardPermissionsRequest.getter(UpdateDashboardPermissionsRequest::grantPermissions)).setter(UpdateDashboardPermissionsRequest.setter(Builder::grantPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcePermission>> REVOKE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevokePermissions").getter(UpdateDashboardPermissionsRequest.getter(UpdateDashboardPermissionsRequest::revokePermissions)).setter(UpdateDashboardPermissionsRequest.setter(Builder::revokePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokePermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcePermission>> GRANT_LINK_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantLinkPermissions").getter(UpdateDashboardPermissionsRequest.getter(UpdateDashboardPermissionsRequest::grantLinkPermissions)).setter(UpdateDashboardPermissionsRequest.setter(Builder::grantLinkPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantLinkPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcePermission>> REVOKE_LINK_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevokeLinkPermissions").getter(UpdateDashboardPermissionsRequest.getter(UpdateDashboardPermissionsRequest::revokeLinkPermissions)).setter(UpdateDashboardPermissionsRequest.setter(Builder::revokeLinkPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokeLinkPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DASHBOARD_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD, GRANT_LINK_PERMISSIONS_FIELD, REVOKE_LINK_PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("DashboardId", DASHBOARD_ID_FIELD);
            this.put("GrantPermissions", GRANT_PERMISSIONS_FIELD);
            this.put("RevokePermissions", REVOKE_PERMISSIONS_FIELD);
            this.put("GrantLinkPermissions", GRANT_LINK_PERMISSIONS_FIELD);
            this.put("RevokeLinkPermissions", REVOKE_LINK_PERMISSIONS_FIELD);
        }
    });
    private final String awsAccountId;
    private final String dashboardId;
    private final List<ResourcePermission> grantPermissions;
    private final List<ResourcePermission> revokePermissions;
    private final List<ResourcePermission> grantLinkPermissions;
    private final List<ResourcePermission> revokeLinkPermissions;

    private UpdateDashboardPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
        this.grantLinkPermissions = builder.grantLinkPermissions;
        this.revokeLinkPermissions = builder.revokeLinkPermissions;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final boolean hasGrantPermissions() {
        return this.grantPermissions != null && !(this.grantPermissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> grantPermissions() {
        return this.grantPermissions;
    }

    public final boolean hasRevokePermissions() {
        return this.revokePermissions != null && !(this.revokePermissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> revokePermissions() {
        return this.revokePermissions;
    }

    public final boolean hasGrantLinkPermissions() {
        return this.grantLinkPermissions != null && !(this.grantLinkPermissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> grantLinkPermissions() {
        return this.grantLinkPermissions;
    }

    public final boolean hasRevokeLinkPermissions() {
        return this.revokeLinkPermissions != null && !(this.revokeLinkPermissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> revokeLinkPermissions() {
        return this.revokeLinkPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantPermissions() ? this.grantPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevokePermissions() ? this.revokePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantLinkPermissions() ? this.grantLinkPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevokeLinkPermissions() ? this.revokeLinkPermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardPermissionsRequest)) {
            return false;
        }
        UpdateDashboardPermissionsRequest other = (UpdateDashboardPermissionsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dashboardId(), other.dashboardId()) && this.hasGrantPermissions() == other.hasGrantPermissions() && Objects.equals(this.grantPermissions(), other.grantPermissions()) && this.hasRevokePermissions() == other.hasRevokePermissions() && Objects.equals(this.revokePermissions(), other.revokePermissions()) && this.hasGrantLinkPermissions() == other.hasGrantLinkPermissions() && Objects.equals(this.grantLinkPermissions(), other.grantLinkPermissions()) && this.hasRevokeLinkPermissions() == other.hasRevokeLinkPermissions() && Objects.equals(this.revokeLinkPermissions(), other.revokeLinkPermissions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDashboardPermissionsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DashboardId", (Object)this.dashboardId()).add("GrantPermissions", this.hasGrantPermissions() ? this.grantPermissions() : null).add("RevokePermissions", this.hasRevokePermissions() ? this.revokePermissions() : null).add("GrantLinkPermissions", this.hasGrantLinkPermissions() ? this.grantLinkPermissions() : null).add("RevokeLinkPermissions", this.hasRevokeLinkPermissions() ? this.revokeLinkPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "GrantPermissions": {
                return Optional.ofNullable(clazz.cast(this.grantPermissions()));
            }
            case "RevokePermissions": {
                return Optional.ofNullable(clazz.cast(this.revokePermissions()));
            }
            case "GrantLinkPermissions": {
                return Optional.ofNullable(clazz.cast(this.grantLinkPermissions()));
            }
            case "RevokeLinkPermissions": {
                return Optional.ofNullable(clazz.cast(this.revokeLinkPermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateDashboardPermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dashboardId;
        private List<ResourcePermission> grantPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcePermission> revokePermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcePermission> grantLinkPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcePermission> revokeLinkPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardPermissionsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dashboardId(model.dashboardId);
            this.grantPermissions(model.grantPermissions);
            this.revokePermissions(model.revokePermissions);
            this.grantLinkPermissions(model.grantLinkPermissions);
            this.revokeLinkPermissions(model.revokeLinkPermissions);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final List<ResourcePermission.Builder> getGrantPermissions() {
            List<ResourcePermission.Builder> result = UpdateResourcePermissionListCopier.copyToBuilder(this.grantPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantPermissions(Collection<ResourcePermission.BuilderImpl> grantPermissions) {
            this.grantPermissions = UpdateResourcePermissionListCopier.copyFromBuilder(grantPermissions);
        }

        @Override
        public final Builder grantPermissions(Collection<ResourcePermission> grantPermissions) {
            this.grantPermissions = UpdateResourcePermissionListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(ResourcePermission ... grantPermissions) {
            this.grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Consumer<ResourcePermission.Builder> ... grantPermissions) {
            this.grantPermissions(Stream.of(grantPermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcePermission.Builder> getRevokePermissions() {
            List<ResourcePermission.Builder> result = UpdateResourcePermissionListCopier.copyToBuilder(this.revokePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokePermissions(Collection<ResourcePermission.BuilderImpl> revokePermissions) {
            this.revokePermissions = UpdateResourcePermissionListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        public final Builder revokePermissions(Collection<ResourcePermission> revokePermissions) {
            this.revokePermissions = UpdateResourcePermissionListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(ResourcePermission ... revokePermissions) {
            this.revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Consumer<ResourcePermission.Builder> ... revokePermissions) {
            this.revokePermissions(Stream.of(revokePermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcePermission.Builder> getGrantLinkPermissions() {
            List<ResourcePermission.Builder> result = UpdateLinkPermissionListCopier.copyToBuilder(this.grantLinkPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantLinkPermissions(Collection<ResourcePermission.BuilderImpl> grantLinkPermissions) {
            this.grantLinkPermissions = UpdateLinkPermissionListCopier.copyFromBuilder(grantLinkPermissions);
        }

        @Override
        public final Builder grantLinkPermissions(Collection<ResourcePermission> grantLinkPermissions) {
            this.grantLinkPermissions = UpdateLinkPermissionListCopier.copy(grantLinkPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantLinkPermissions(ResourcePermission ... grantLinkPermissions) {
            this.grantLinkPermissions(Arrays.asList(grantLinkPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantLinkPermissions(Consumer<ResourcePermission.Builder> ... grantLinkPermissions) {
            this.grantLinkPermissions(Stream.of(grantLinkPermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcePermission.Builder> getRevokeLinkPermissions() {
            List<ResourcePermission.Builder> result = UpdateLinkPermissionListCopier.copyToBuilder(this.revokeLinkPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokeLinkPermissions(Collection<ResourcePermission.BuilderImpl> revokeLinkPermissions) {
            this.revokeLinkPermissions = UpdateLinkPermissionListCopier.copyFromBuilder(revokeLinkPermissions);
        }

        @Override
        public final Builder revokeLinkPermissions(Collection<ResourcePermission> revokeLinkPermissions) {
            this.revokeLinkPermissions = UpdateLinkPermissionListCopier.copy(revokeLinkPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokeLinkPermissions(ResourcePermission ... revokeLinkPermissions) {
            this.revokeLinkPermissions(Arrays.asList(revokeLinkPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokeLinkPermissions(Consumer<ResourcePermission.Builder> ... revokeLinkPermissions) {
            this.revokeLinkPermissions(Stream.of(revokeLinkPermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardPermissionsRequest build() {
            return new UpdateDashboardPermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardPermissionsRequest> {
        public Builder awsAccountId(String var1);

        public Builder dashboardId(String var1);

        public Builder grantPermissions(Collection<ResourcePermission> var1);

        public Builder grantPermissions(ResourcePermission ... var1);

        public Builder grantPermissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder revokePermissions(Collection<ResourcePermission> var1);

        public Builder revokePermissions(ResourcePermission ... var1);

        public Builder revokePermissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder grantLinkPermissions(Collection<ResourcePermission> var1);

        public Builder grantLinkPermissions(ResourcePermission ... var1);

        public Builder grantLinkPermissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder revokeLinkPermissions(Collection<ResourcePermission> var1);

        public Builder revokeLinkPermissions(ResourcePermission ... var1);

        public Builder revokeLinkPermissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

