/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrinoParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrinoParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(TrinoParameters.getter(TrinoParameters::host)).setter(TrinoParameters.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(TrinoParameters.getter(TrinoParameters::port)).setter(TrinoParameters.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(TrinoParameters.getter(TrinoParameters::catalog)).setter(TrinoParameters.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD, CATALOG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Host", HOST_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("Catalog", CATALOG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String host;
    private final Integer port;
    private final String catalog;

    private TrinoParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.catalog = builder.catalog;
    }

    public final String host() {
        return this.host;
    }

    public final Integer port() {
        return this.port;
    }

    public final String catalog() {
        return this.catalog;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrinoParameters)) {
            return false;
        }
        TrinoParameters other = (TrinoParameters)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.catalog(), other.catalog());
    }

    public final String toString() {
        return ToString.builder((String)"TrinoParameters").add("Host", (Object)this.host()).add("Port", (Object)this.port()).add("Catalog", (Object)this.catalog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrinoParameters, T> g) {
        return obj -> g.apply((TrinoParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private Integer port;
        private String catalog;

        private BuilderImpl() {
        }

        private BuilderImpl(TrinoParameters model) {
            this.host(model.host);
            this.port(model.port);
            this.catalog(model.catalog);
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public TrinoParameters build() {
            return new TrinoParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrinoParameters> {
        public Builder host(String var1);

        public Builder port(Integer var1);

        public Builder catalog(String var1);
    }
}

