/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.DateTimeFormatConfiguration;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateDimensionField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateDimensionField> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(DateDimensionField.getter(DateDimensionField::fieldId)).setter(DateDimensionField.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(DateDimensionField.getter(DateDimensionField::column)).setter(DateDimensionField.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<String> DATE_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateGranularity").getter(DateDimensionField.getter(DateDimensionField::dateGranularityAsString)).setter(DateDimensionField.setter(Builder::dateGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateGranularity").build()}).build();
    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HierarchyId").getter(DateDimensionField.getter(DateDimensionField::hierarchyId)).setter(DateDimensionField.setter(Builder::hierarchyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyId").build()}).build();
    private static final SdkField<DateTimeFormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FormatConfiguration").getter(DateDimensionField.getter(DateDimensionField::formatConfiguration)).setter(DateDimensionField.setter(Builder::formatConfiguration)).constructor(DateTimeFormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, COLUMN_FIELD, DATE_GRANULARITY_FIELD, HIERARCHY_ID_FIELD, FORMAT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FieldId", FIELD_ID_FIELD);
            this.put("Column", COLUMN_FIELD);
            this.put("DateGranularity", DATE_GRANULARITY_FIELD);
            this.put("HierarchyId", HIERARCHY_ID_FIELD);
            this.put("FormatConfiguration", FORMAT_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final ColumnIdentifier column;
    private final String dateGranularity;
    private final String hierarchyId;
    private final DateTimeFormatConfiguration formatConfiguration;

    private DateDimensionField(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.column = builder.column;
        this.dateGranularity = builder.dateGranularity;
        this.hierarchyId = builder.hierarchyId;
        this.formatConfiguration = builder.formatConfiguration;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final TimeGranularity dateGranularity() {
        return TimeGranularity.fromValue(this.dateGranularity);
    }

    public final String dateGranularityAsString() {
        return this.dateGranularity;
    }

    public final String hierarchyId() {
        return this.hierarchyId;
    }

    public final DateTimeFormatConfiguration formatConfiguration() {
        return this.formatConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateDimensionField)) {
            return false;
        }
        DateDimensionField other = (DateDimensionField)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.dateGranularityAsString(), other.dateGranularityAsString()) && Objects.equals(this.hierarchyId(), other.hierarchyId()) && Objects.equals(this.formatConfiguration(), other.formatConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DateDimensionField").add("FieldId", (Object)this.fieldId()).add("Column", (Object)this.column()).add("DateGranularity", (Object)this.dateGranularityAsString()).add("HierarchyId", (Object)this.hierarchyId()).add("FormatConfiguration", (Object)this.formatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "DateGranularity": {
                return Optional.ofNullable(clazz.cast(this.dateGranularityAsString()));
            }
            case "HierarchyId": {
                return Optional.ofNullable(clazz.cast(this.hierarchyId()));
            }
            case "FormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.formatConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DateDimensionField, T> g) {
        return obj -> g.apply((DateDimensionField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private ColumnIdentifier column;
        private String dateGranularity;
        private String hierarchyId;
        private DateTimeFormatConfiguration formatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DateDimensionField model) {
            this.fieldId(model.fieldId);
            this.column(model.column);
            this.dateGranularity(model.dateGranularity);
            this.hierarchyId(model.hierarchyId);
            this.formatConfiguration(model.formatConfiguration);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final String getDateGranularity() {
            return this.dateGranularity;
        }

        public final void setDateGranularity(String dateGranularity) {
            this.dateGranularity = dateGranularity;
        }

        @Override
        public final Builder dateGranularity(String dateGranularity) {
            this.dateGranularity = dateGranularity;
            return this;
        }

        @Override
        public final Builder dateGranularity(TimeGranularity dateGranularity) {
            this.dateGranularity(dateGranularity == null ? null : dateGranularity.toString());
            return this;
        }

        public final String getHierarchyId() {
            return this.hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        public final DateTimeFormatConfiguration.Builder getFormatConfiguration() {
            return this.formatConfiguration != null ? this.formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(DateTimeFormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(DateTimeFormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        public DateDimensionField build() {
            return new DateDimensionField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateDimensionField> {
        public Builder fieldId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder dateGranularity(String var1);

        public Builder dateGranularity(TimeGranularity var1);

        public Builder hierarchyId(String var1);

        public Builder formatConfiguration(DateTimeFormatConfiguration var1);

        default public Builder formatConfiguration(Consumer<DateTimeFormatConfiguration.Builder> formatConfiguration) {
            return this.formatConfiguration((DateTimeFormatConfiguration)((DateTimeFormatConfiguration.Builder)DateTimeFormatConfiguration.builder().applyMutation(formatConfiguration)).build());
        }
    }
}

