/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DnsResolverListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.quicksight.model.SubnetIdListCopier;
import software.amazon.awssdk.services.quicksight.model.Tag;
import software.amazon.awssdk.services.quicksight.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcConnectionRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateVpcConnectionRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::awsAccountId)).setter(CreateVpcConnectionRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> VPC_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCConnectionId").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::vpcConnectionId)).setter(CreateVpcConnectionRequest.setter(Builder::vpcConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnectionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::name)).setter(CreateVpcConnectionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::subnetIds)).setter(CreateVpcConnectionRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::securityGroupIds)).setter(CreateVpcConnectionRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DNS_RESOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsResolvers").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::dnsResolvers)).setter(CreateVpcConnectionRequest.setter(Builder::dnsResolvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsResolvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::roleArn)).setter(CreateVpcConnectionRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateVpcConnectionRequest.getter(CreateVpcConnectionRequest::tags)).setter(CreateVpcConnectionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, VPC_CONNECTION_ID_FIELD, NAME_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, DNS_RESOLVERS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("VPCConnectionId", VPC_CONNECTION_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("SubnetIds", SUBNET_IDS_FIELD);
            this.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
            this.put("DnsResolvers", DNS_RESOLVERS_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String awsAccountId;
    private final String vpcConnectionId;
    private final String name;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final List<String> dnsResolvers;
    private final String roleArn;
    private final List<Tag> tags;

    private CreateVpcConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.vpcConnectionId = builder.vpcConnectionId;
        this.name = builder.name;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.dnsResolvers = builder.dnsResolvers;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String vpcConnectionId() {
        return this.vpcConnectionId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasDnsResolvers() {
        return this.dnsResolvers != null && !(this.dnsResolvers instanceof SdkAutoConstructList);
    }

    public final List<String> dnsResolvers() {
        return this.dnsResolvers;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsResolvers() ? this.dnsResolvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcConnectionRequest)) {
            return false;
        }
        CreateVpcConnectionRequest other = (CreateVpcConnectionRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.vpcConnectionId(), other.vpcConnectionId()) && Objects.equals(this.name(), other.name()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasDnsResolvers() == other.hasDnsResolvers() && Objects.equals(this.dnsResolvers(), other.dnsResolvers()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcConnectionRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("VPCConnectionId", (Object)this.vpcConnectionId()).add("Name", (Object)this.name()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("DnsResolvers", this.hasDnsResolvers() ? this.dnsResolvers() : null).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "VPCConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "DnsResolvers": {
                return Optional.ofNullable(clazz.cast(this.dnsResolvers()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpcConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String vpcConnectionId;
        private String name;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> dnsResolvers = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcConnectionRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.vpcConnectionId(model.vpcConnectionId);
            this.name(model.name);
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.dnsResolvers(model.dnsResolvers);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getVpcConnectionId() {
            return this.vpcConnectionId;
        }

        public final void setVpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
        }

        @Override
        public final Builder vpcConnectionId(String vpcConnectionId) {
            this.vpcConnectionId = vpcConnectionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getDnsResolvers() {
            if (this.dnsResolvers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsResolvers;
        }

        public final void setDnsResolvers(Collection<String> dnsResolvers) {
            this.dnsResolvers = DnsResolverListCopier.copy(dnsResolvers);
        }

        @Override
        public final Builder dnsResolvers(Collection<String> dnsResolvers) {
            this.dnsResolvers = DnsResolverListCopier.copy(dnsResolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsResolvers(String ... dnsResolvers) {
            this.dnsResolvers(Arrays.asList(dnsResolvers));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcConnectionRequest build() {
            return new CreateVpcConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcConnectionRequest> {
        public Builder awsAccountId(String var1);

        public Builder vpcConnectionId(String var1);

        public Builder name(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder dnsResolvers(Collection<String> var1);

        public Builder dnsResolvers(String ... var1);

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

