/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleCloudFormationOverridePropertyConfiguration;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportFormat;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobValidationStrategy;
import software.amazon.awssdk.services.quicksight.model.AssetBundleResourceArnsCopier;
import software.amazon.awssdk.services.quicksight.model.IncludeFolderMembers;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAssetBundleExportJobRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, StartAssetBundleExportJobRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::awsAccountId)).setter(StartAssetBundleExportJobRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ASSET_BUNDLE_EXPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetBundleExportJobId").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::assetBundleExportJobId)).setter(StartAssetBundleExportJobRequest.setter(Builder::assetBundleExportJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleExportJobId").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceArns").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::resourceArns)).setter(StartAssetBundleExportJobRequest.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeAllDependencies").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::includeAllDependencies)).setter(StartAssetBundleExportJobRequest.setter(Builder::includeAllDependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllDependencies").build()}).build();
    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportFormat").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::exportFormatAsString)).setter(StartAssetBundleExportJobRequest.setter(Builder::exportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()}).build();
    private static final SdkField<AssetBundleCloudFormationOverridePropertyConfiguration> CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudFormationOverridePropertyConfiguration").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::cloudFormationOverridePropertyConfiguration)).setter(StartAssetBundleExportJobRequest.setter(Builder::cloudFormationOverridePropertyConfiguration)).constructor(AssetBundleCloudFormationOverridePropertyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormationOverridePropertyConfiguration").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludePermissions").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::includePermissions)).setter(StartAssetBundleExportJobRequest.setter(Builder::includePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePermissions").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTags").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::includeTags)).setter(StartAssetBundleExportJobRequest.setter(Builder::includeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTags").build()}).build();
    private static final SdkField<AssetBundleExportJobValidationStrategy> VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationStrategy").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::validationStrategy)).setter(StartAssetBundleExportJobRequest.setter(Builder::validationStrategy)).constructor(AssetBundleExportJobValidationStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStrategy").build()}).build();
    private static final SdkField<Boolean> INCLUDE_FOLDER_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeFolderMemberships").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::includeFolderMemberships)).setter(StartAssetBundleExportJobRequest.setter(Builder::includeFolderMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFolderMemberships").build()}).build();
    private static final SdkField<String> INCLUDE_FOLDER_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncludeFolderMembers").getter(StartAssetBundleExportJobRequest.getter(StartAssetBundleExportJobRequest::includeFolderMembersAsString)).setter(StartAssetBundleExportJobRequest.setter(Builder::includeFolderMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFolderMembers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ASSET_BUNDLE_EXPORT_JOB_ID_FIELD, RESOURCE_ARNS_FIELD, INCLUDE_ALL_DEPENDENCIES_FIELD, EXPORT_FORMAT_FIELD, CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD, INCLUDE_PERMISSIONS_FIELD, INCLUDE_TAGS_FIELD, VALIDATION_STRATEGY_FIELD, INCLUDE_FOLDER_MEMBERSHIPS_FIELD, INCLUDE_FOLDER_MEMBERS_FIELD));
    private final String awsAccountId;
    private final String assetBundleExportJobId;
    private final List<String> resourceArns;
    private final Boolean includeAllDependencies;
    private final String exportFormat;
    private final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;
    private final Boolean includePermissions;
    private final Boolean includeTags;
    private final AssetBundleExportJobValidationStrategy validationStrategy;
    private final Boolean includeFolderMemberships;
    private final String includeFolderMembers;

    private StartAssetBundleExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assetBundleExportJobId = builder.assetBundleExportJobId;
        this.resourceArns = builder.resourceArns;
        this.includeAllDependencies = builder.includeAllDependencies;
        this.exportFormat = builder.exportFormat;
        this.cloudFormationOverridePropertyConfiguration = builder.cloudFormationOverridePropertyConfiguration;
        this.includePermissions = builder.includePermissions;
        this.includeTags = builder.includeTags;
        this.validationStrategy = builder.validationStrategy;
        this.includeFolderMemberships = builder.includeFolderMemberships;
        this.includeFolderMembers = builder.includeFolderMembers;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String assetBundleExportJobId() {
        return this.assetBundleExportJobId;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final Boolean includeAllDependencies() {
        return this.includeAllDependencies;
    }

    public final AssetBundleExportFormat exportFormat() {
        return AssetBundleExportFormat.fromValue(this.exportFormat);
    }

    public final String exportFormatAsString() {
        return this.exportFormat;
    }

    public final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration() {
        return this.cloudFormationOverridePropertyConfiguration;
    }

    public final Boolean includePermissions() {
        return this.includePermissions;
    }

    public final Boolean includeTags() {
        return this.includeTags;
    }

    public final AssetBundleExportJobValidationStrategy validationStrategy() {
        return this.validationStrategy;
    }

    public final Boolean includeFolderMemberships() {
        return this.includeFolderMemberships;
    }

    public final IncludeFolderMembers includeFolderMembers() {
        return IncludeFolderMembers.fromValue(this.includeFolderMembers);
    }

    public final String includeFolderMembersAsString() {
        return this.includeFolderMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleExportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllDependencies());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormationOverridePropertyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.includePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeFolderMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeFolderMembersAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssetBundleExportJobRequest)) {
            return false;
        }
        StartAssetBundleExportJobRequest other = (StartAssetBundleExportJobRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.assetBundleExportJobId(), other.assetBundleExportJobId()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && Objects.equals(this.includeAllDependencies(), other.includeAllDependencies()) && Objects.equals(this.exportFormatAsString(), other.exportFormatAsString()) && Objects.equals(this.cloudFormationOverridePropertyConfiguration(), other.cloudFormationOverridePropertyConfiguration()) && Objects.equals(this.includePermissions(), other.includePermissions()) && Objects.equals(this.includeTags(), other.includeTags()) && Objects.equals(this.validationStrategy(), other.validationStrategy()) && Objects.equals(this.includeFolderMemberships(), other.includeFolderMemberships()) && Objects.equals(this.includeFolderMembersAsString(), other.includeFolderMembersAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartAssetBundleExportJobRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AssetBundleExportJobId", (Object)this.assetBundleExportJobId()).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("IncludeAllDependencies", (Object)this.includeAllDependencies()).add("ExportFormat", (Object)this.exportFormatAsString()).add("CloudFormationOverridePropertyConfiguration", (Object)this.cloudFormationOverridePropertyConfiguration()).add("IncludePermissions", (Object)this.includePermissions()).add("IncludeTags", (Object)this.includeTags()).add("ValidationStrategy", (Object)this.validationStrategy()).add("IncludeFolderMemberships", (Object)this.includeFolderMemberships()).add("IncludeFolderMembers", (Object)this.includeFolderMembersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AssetBundleExportJobId": {
                return Optional.ofNullable(clazz.cast(this.assetBundleExportJobId()));
            }
            case "ResourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "IncludeAllDependencies": {
                return Optional.ofNullable(clazz.cast(this.includeAllDependencies()));
            }
            case "ExportFormat": {
                return Optional.ofNullable(clazz.cast(this.exportFormatAsString()));
            }
            case "CloudFormationOverridePropertyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudFormationOverridePropertyConfiguration()));
            }
            case "IncludePermissions": {
                return Optional.ofNullable(clazz.cast(this.includePermissions()));
            }
            case "IncludeTags": {
                return Optional.ofNullable(clazz.cast(this.includeTags()));
            }
            case "ValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.validationStrategy()));
            }
            case "IncludeFolderMemberships": {
                return Optional.ofNullable(clazz.cast(this.includeFolderMemberships()));
            }
            case "IncludeFolderMembers": {
                return Optional.ofNullable(clazz.cast(this.includeFolderMembersAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssetBundleExportJobRequest, T> g) {
        return obj -> g.apply((StartAssetBundleExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String assetBundleExportJobId;
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeAllDependencies;
        private String exportFormat;
        private AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;
        private Boolean includePermissions;
        private Boolean includeTags;
        private AssetBundleExportJobValidationStrategy validationStrategy;
        private Boolean includeFolderMemberships;
        private String includeFolderMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssetBundleExportJobRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.assetBundleExportJobId(model.assetBundleExportJobId);
            this.resourceArns(model.resourceArns);
            this.includeAllDependencies(model.includeAllDependencies);
            this.exportFormat(model.exportFormat);
            this.cloudFormationOverridePropertyConfiguration(model.cloudFormationOverridePropertyConfiguration);
            this.includePermissions(model.includePermissions);
            this.includeTags(model.includeTags);
            this.validationStrategy(model.validationStrategy);
            this.includeFolderMemberships(model.includeFolderMemberships);
            this.includeFolderMembers(model.includeFolderMembers);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssetBundleExportJobId() {
            return this.assetBundleExportJobId;
        }

        public final void setAssetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
        }

        @Override
        public final Builder assetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Boolean getIncludeAllDependencies() {
            return this.includeAllDependencies;
        }

        public final void setIncludeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
        }

        @Override
        public final Builder includeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
            return this;
        }

        public final String getExportFormat() {
            return this.exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(AssetBundleExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final AssetBundleCloudFormationOverridePropertyConfiguration.Builder getCloudFormationOverridePropertyConfiguration() {
            return this.cloudFormationOverridePropertyConfiguration != null ? this.cloudFormationOverridePropertyConfiguration.toBuilder() : null;
        }

        public final void setCloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration.BuilderImpl cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration != null ? cloudFormationOverridePropertyConfiguration.build() : null;
        }

        @Override
        public final Builder cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration;
            return this;
        }

        public final Boolean getIncludePermissions() {
            return this.includePermissions;
        }

        public final void setIncludePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
        }

        @Override
        public final Builder includePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
            return this;
        }

        public final Boolean getIncludeTags() {
            return this.includeTags;
        }

        public final void setIncludeTags(Boolean includeTags) {
            this.includeTags = includeTags;
        }

        @Override
        public final Builder includeTags(Boolean includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        public final AssetBundleExportJobValidationStrategy.Builder getValidationStrategy() {
            return this.validationStrategy != null ? this.validationStrategy.toBuilder() : null;
        }

        public final void setValidationStrategy(AssetBundleExportJobValidationStrategy.BuilderImpl validationStrategy) {
            this.validationStrategy = validationStrategy != null ? validationStrategy.build() : null;
        }

        @Override
        public final Builder validationStrategy(AssetBundleExportJobValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        public final Boolean getIncludeFolderMemberships() {
            return this.includeFolderMemberships;
        }

        public final void setIncludeFolderMemberships(Boolean includeFolderMemberships) {
            this.includeFolderMemberships = includeFolderMemberships;
        }

        @Override
        public final Builder includeFolderMemberships(Boolean includeFolderMemberships) {
            this.includeFolderMemberships = includeFolderMemberships;
            return this;
        }

        public final String getIncludeFolderMembers() {
            return this.includeFolderMembers;
        }

        public final void setIncludeFolderMembers(String includeFolderMembers) {
            this.includeFolderMembers = includeFolderMembers;
        }

        @Override
        public final Builder includeFolderMembers(String includeFolderMembers) {
            this.includeFolderMembers = includeFolderMembers;
            return this;
        }

        @Override
        public final Builder includeFolderMembers(IncludeFolderMembers includeFolderMembers) {
            this.includeFolderMembers(includeFolderMembers == null ? null : includeFolderMembers.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssetBundleExportJobRequest build() {
            return new StartAssetBundleExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAssetBundleExportJobRequest> {
        public Builder awsAccountId(String var1);

        public Builder assetBundleExportJobId(String var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder includeAllDependencies(Boolean var1);

        public Builder exportFormat(String var1);

        public Builder exportFormat(AssetBundleExportFormat var1);

        public Builder cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration var1);

        default public Builder cloudFormationOverridePropertyConfiguration(Consumer<AssetBundleCloudFormationOverridePropertyConfiguration.Builder> cloudFormationOverridePropertyConfiguration) {
            return this.cloudFormationOverridePropertyConfiguration((AssetBundleCloudFormationOverridePropertyConfiguration)((AssetBundleCloudFormationOverridePropertyConfiguration.Builder)AssetBundleCloudFormationOverridePropertyConfiguration.builder().applyMutation(cloudFormationOverridePropertyConfiguration)).build());
        }

        public Builder includePermissions(Boolean var1);

        public Builder includeTags(Boolean var1);

        public Builder validationStrategy(AssetBundleExportJobValidationStrategy var1);

        default public Builder validationStrategy(Consumer<AssetBundleExportJobValidationStrategy.Builder> validationStrategy) {
            return this.validationStrategy((AssetBundleExportJobValidationStrategy)((AssetBundleExportJobValidationStrategy.Builder)AssetBundleExportJobValidationStrategy.builder().applyMutation(validationStrategy)).build());
        }

        public Builder includeFolderMemberships(Boolean var1);

        public Builder includeFolderMembers(String var1);

        public Builder includeFolderMembers(IncludeFolderMembers var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

