/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.CollectiveConstantEntry;
import software.amazon.awssdk.services.quicksight.model.CollectiveConstantEntryListCopier;
import software.amazon.awssdk.services.quicksight.model.ConstantType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicConstantValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicConstantValue> {
    private static final SdkField<String> CONSTANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstantType").getter(TopicConstantValue.getter(TopicConstantValue::constantTypeAsString)).setter(TopicConstantValue.setter(Builder::constantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstantType").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(TopicConstantValue.getter(TopicConstantValue::value)).setter(TopicConstantValue.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Minimum").getter(TopicConstantValue.getter(TopicConstantValue::minimum)).setter(TopicConstantValue.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()}).build();
    private static final SdkField<String> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Maximum").getter(TopicConstantValue.getter(TopicConstantValue::maximum)).setter(TopicConstantValue.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()}).build();
    private static final SdkField<List<CollectiveConstantEntry>> VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValueList").getter(TopicConstantValue.getter(TopicConstantValue::valueList)).setter(TopicConstantValue.setter(Builder::valueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollectiveConstantEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_TYPE_FIELD, VALUE_FIELD, MINIMUM_FIELD, MAXIMUM_FIELD, VALUE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String constantType;
    private final String value;
    private final String minimum;
    private final String maximum;
    private final List<CollectiveConstantEntry> valueList;

    private TopicConstantValue(BuilderImpl builder) {
        this.constantType = builder.constantType;
        this.value = builder.value;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.valueList = builder.valueList;
    }

    public final ConstantType constantType() {
        return ConstantType.fromValue(this.constantType);
    }

    public final String constantTypeAsString() {
        return this.constantType;
    }

    public final String value() {
        return this.value;
    }

    public final String minimum() {
        return this.minimum;
    }

    public final String maximum() {
        return this.maximum;
    }

    public final boolean hasValueList() {
        return this.valueList != null && !(this.valueList instanceof SdkAutoConstructList);
    }

    public final List<CollectiveConstantEntry> valueList() {
        return this.valueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueList() ? this.valueList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConstantValue)) {
            return false;
        }
        TopicConstantValue other = (TopicConstantValue)obj;
        return Objects.equals(this.constantTypeAsString(), other.constantTypeAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.maximum(), other.maximum()) && this.hasValueList() == other.hasValueList() && Objects.equals(this.valueList(), other.valueList());
    }

    public final String toString() {
        return ToString.builder((String)"TopicConstantValue").add("ConstantType", (Object)this.constantTypeAsString()).add("Value", (Object)this.value()).add("Minimum", (Object)this.minimum()).add("Maximum", (Object)this.maximum()).add("ValueList", this.hasValueList() ? this.valueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstantType": {
                return Optional.ofNullable(clazz.cast(this.constantTypeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "Maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "ValueList": {
                return Optional.ofNullable(clazz.cast(this.valueList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicConstantValue, T> g) {
        return obj -> g.apply((TopicConstantValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String constantType;
        private String value;
        private String minimum;
        private String maximum;
        private List<CollectiveConstantEntry> valueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConstantValue model) {
            this.constantType(model.constantType);
            this.value(model.value);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
            this.valueList(model.valueList);
        }

        public final String getConstantType() {
            return this.constantType;
        }

        public final void setConstantType(String constantType) {
            this.constantType = constantType;
        }

        @Override
        public final Builder constantType(String constantType) {
            this.constantType = constantType;
            return this;
        }

        @Override
        public final Builder constantType(ConstantType constantType) {
            this.constantType(constantType == null ? null : constantType.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getMinimum() {
            return this.minimum;
        }

        public final void setMinimum(String minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(String minimum) {
            this.minimum = minimum;
            return this;
        }

        public final String getMaximum() {
            return this.maximum;
        }

        public final void setMaximum(String maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(String maximum) {
            this.maximum = maximum;
            return this;
        }

        public final List<CollectiveConstantEntry.Builder> getValueList() {
            List<CollectiveConstantEntry.Builder> result = CollectiveConstantEntryListCopier.copyToBuilder(this.valueList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValueList(Collection<CollectiveConstantEntry.BuilderImpl> valueList) {
            this.valueList = CollectiveConstantEntryListCopier.copyFromBuilder(valueList);
        }

        @Override
        public final Builder valueList(Collection<CollectiveConstantEntry> valueList) {
            this.valueList = CollectiveConstantEntryListCopier.copy(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(CollectiveConstantEntry ... valueList) {
            this.valueList(Arrays.asList(valueList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(Consumer<CollectiveConstantEntry.Builder> ... valueList) {
            this.valueList(Stream.of(valueList).map(c -> (CollectiveConstantEntry)((CollectiveConstantEntry.Builder)CollectiveConstantEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TopicConstantValue build() {
            return new TopicConstantValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicConstantValue> {
        public Builder constantType(String var1);

        public Builder constantType(ConstantType var1);

        public Builder value(String var1);

        public Builder minimum(String var1);

        public Builder maximum(String var1);

        public Builder valueList(Collection<CollectiveConstantEntry> var1);

        public Builder valueList(CollectiveConstantEntry ... var1);

        public Builder valueList(Consumer<CollectiveConstantEntry.Builder> ... var1);
    }
}

