/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ThemeVersionSummary;
import software.amazon.awssdk.services.quicksight.model.ThemeVersionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThemeVersionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListThemeVersionsResponse> {
    private static final SdkField<List<ThemeVersionSummary>> THEME_VERSION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThemeVersionSummaryList").getter(ListThemeVersionsResponse.getter(ListThemeVersionsResponse::themeVersionSummaryList)).setter(ListThemeVersionsResponse.setter(Builder::themeVersionSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeVersionSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThemeVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListThemeVersionsResponse.getter(ListThemeVersionsResponse::nextToken)).setter(ListThemeVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListThemeVersionsResponse.getter(ListThemeVersionsResponse::status)).setter(ListThemeVersionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListThemeVersionsResponse.getter(ListThemeVersionsResponse::requestId)).setter(ListThemeVersionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THEME_VERSION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final List<ThemeVersionSummary> themeVersionSummaryList;
    private final String nextToken;
    private final Integer status;
    private final String requestId;

    private ListThemeVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.themeVersionSummaryList = builder.themeVersionSummaryList;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final boolean hasThemeVersionSummaryList() {
        return this.themeVersionSummaryList != null && !(this.themeVersionSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ThemeVersionSummary> themeVersionSummaryList() {
        return this.themeVersionSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThemeVersionSummaryList() ? this.themeVersionSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThemeVersionsResponse)) {
            return false;
        }
        ListThemeVersionsResponse other = (ListThemeVersionsResponse)((Object)obj);
        return this.hasThemeVersionSummaryList() == other.hasThemeVersionSummaryList() && Objects.equals(this.themeVersionSummaryList(), other.themeVersionSummaryList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"ListThemeVersionsResponse").add("ThemeVersionSummaryList", this.hasThemeVersionSummaryList() ? this.themeVersionSummaryList() : null).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThemeVersionSummaryList": {
                return Optional.ofNullable(clazz.cast(this.themeVersionSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThemeVersionsResponse, T> g) {
        return obj -> g.apply((ListThemeVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<ThemeVersionSummary> themeVersionSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThemeVersionsResponse model) {
            super(model);
            this.themeVersionSummaryList(model.themeVersionSummaryList);
            this.nextToken(model.nextToken);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final List<ThemeVersionSummary.Builder> getThemeVersionSummaryList() {
            List<ThemeVersionSummary.Builder> result = ThemeVersionSummaryListCopier.copyToBuilder(this.themeVersionSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThemeVersionSummaryList(Collection<ThemeVersionSummary.BuilderImpl> themeVersionSummaryList) {
            this.themeVersionSummaryList = ThemeVersionSummaryListCopier.copyFromBuilder(themeVersionSummaryList);
        }

        @Override
        public final Builder themeVersionSummaryList(Collection<ThemeVersionSummary> themeVersionSummaryList) {
            this.themeVersionSummaryList = ThemeVersionSummaryListCopier.copy(themeVersionSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themeVersionSummaryList(ThemeVersionSummary ... themeVersionSummaryList) {
            this.themeVersionSummaryList(Arrays.asList(themeVersionSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themeVersionSummaryList(Consumer<ThemeVersionSummary.Builder> ... themeVersionSummaryList) {
            this.themeVersionSummaryList(Stream.of(themeVersionSummaryList).map(c -> (ThemeVersionSummary)((ThemeVersionSummary.Builder)ThemeVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListThemeVersionsResponse build() {
            return new ListThemeVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThemeVersionsResponse> {
        public Builder themeVersionSummaryList(Collection<ThemeVersionSummary> var1);

        public Builder themeVersionSummaryList(ThemeVersionSummary ... var1);

        public Builder themeVersionSummaryList(Consumer<ThemeVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

