/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTopicResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateTopicResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateTopicResponse.getter(CreateTopicResponse::arn)).setter(CreateTopicResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicId").getter(CreateTopicResponse.getter(CreateTopicResponse::topicId)).setter(CreateTopicResponse.setter(Builder::topicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()}).build();
    private static final SdkField<String> REFRESH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshArn").getter(CreateTopicResponse.getter(CreateTopicResponse::refreshArn)).setter(CreateTopicResponse.setter(Builder::refreshArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshArn").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateTopicResponse.getter(CreateTopicResponse::requestId)).setter(CreateTopicResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(CreateTopicResponse.getter(CreateTopicResponse::status)).setter(CreateTopicResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TOPIC_ID_FIELD, REFRESH_ARN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String arn;
    private final String topicId;
    private final String refreshArn;
    private final String requestId;
    private final Integer status;

    private CreateTopicResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.topicId = builder.topicId;
        this.refreshArn = builder.refreshArn;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String topicId() {
        return this.topicId;
    }

    public final String refreshArn() {
        return this.refreshArn;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicResponse)) {
            return false;
        }
        CreateTopicResponse other = (CreateTopicResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.topicId(), other.topicId()) && Objects.equals(this.refreshArn(), other.refreshArn()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTopicResponse").add("Arn", (Object)this.arn()).add("TopicId", (Object)this.topicId()).add("RefreshArn", (Object)this.refreshArn()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "TopicId": {
                return Optional.ofNullable(clazz.cast(this.topicId()));
            }
            case "RefreshArn": {
                return Optional.ofNullable(clazz.cast(this.refreshArn()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTopicResponse, T> g) {
        return obj -> g.apply((CreateTopicResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String topicId;
        private String refreshArn;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicResponse model) {
            super(model);
            this.arn(model.arn);
            this.topicId(model.topicId);
            this.refreshArn(model.refreshArn);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTopicId() {
            return this.topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getRefreshArn() {
            return this.refreshArn;
        }

        public final void setRefreshArn(String refreshArn) {
            this.refreshArn = refreshArn;
        }

        @Override
        public final Builder refreshArn(String refreshArn) {
            this.refreshArn = refreshArn;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateTopicResponse build() {
            return new CreateTopicResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTopicResponse> {
        public Builder arn(String var1);

        public Builder topicId(String var1);

        public Builder refreshArn(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

