/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ConstantType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollectiveConstantEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollectiveConstantEntry> {
    private static final SdkField<String> CONSTANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstantType").getter(CollectiveConstantEntry.getter(CollectiveConstantEntry::constantTypeAsString)).setter(CollectiveConstantEntry.setter(Builder::constantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstantType").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(CollectiveConstantEntry.getter(CollectiveConstantEntry::value)).setter(CollectiveConstantEntry.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_TYPE_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String constantType;
    private final String value;

    private CollectiveConstantEntry(BuilderImpl builder) {
        this.constantType = builder.constantType;
        this.value = builder.value;
    }

    public final ConstantType constantType() {
        return ConstantType.fromValue(this.constantType);
    }

    public final String constantTypeAsString() {
        return this.constantType;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectiveConstantEntry)) {
            return false;
        }
        CollectiveConstantEntry other = (CollectiveConstantEntry)obj;
        return Objects.equals(this.constantTypeAsString(), other.constantTypeAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"CollectiveConstantEntry").add("ConstantType", (Object)this.constantTypeAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstantType": {
                return Optional.ofNullable(clazz.cast(this.constantTypeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CollectiveConstantEntry, T> g) {
        return obj -> g.apply((CollectiveConstantEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String constantType;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CollectiveConstantEntry model) {
            this.constantType(model.constantType);
            this.value(model.value);
        }

        public final String getConstantType() {
            return this.constantType;
        }

        public final void setConstantType(String constantType) {
            this.constantType = constantType;
        }

        @Override
        public final Builder constantType(String constantType) {
            this.constantType = constantType;
            return this;
        }

        @Override
        public final Builder constantType(ConstantType constantType) {
            this.constantType(constantType == null ? null : constantType.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public CollectiveConstantEntry build() {
            return new CollectiveConstantEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollectiveConstantEntry> {
        public Builder constantType(String var1);

        public Builder constantType(ConstantType var1);

        public Builder value(String var1);
    }
}

