/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineDataConfiguration;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineLabelConfiguration;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineStyleConfiguration;
import software.amazon.awssdk.services.quicksight.model.WidgetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceLine
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceLine> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReferenceLine.getter(ReferenceLine::statusAsString)).setter(ReferenceLine.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ReferenceLineDataConfiguration> DATA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataConfiguration").getter(ReferenceLine.getter(ReferenceLine::dataConfiguration)).setter(ReferenceLine.setter(Builder::dataConfiguration)).constructor(ReferenceLineDataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataConfiguration").build()}).build();
    private static final SdkField<ReferenceLineStyleConfiguration> STYLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StyleConfiguration").getter(ReferenceLine.getter(ReferenceLine::styleConfiguration)).setter(ReferenceLine.setter(Builder::styleConfiguration)).constructor(ReferenceLineStyleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StyleConfiguration").build()}).build();
    private static final SdkField<ReferenceLineLabelConfiguration> LABEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelConfiguration").getter(ReferenceLine.getter(ReferenceLine::labelConfiguration)).setter(ReferenceLine.setter(Builder::labelConfiguration)).constructor(ReferenceLineLabelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, DATA_CONFIGURATION_FIELD, STYLE_CONFIGURATION_FIELD, LABEL_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final ReferenceLineDataConfiguration dataConfiguration;
    private final ReferenceLineStyleConfiguration styleConfiguration;
    private final ReferenceLineLabelConfiguration labelConfiguration;

    private ReferenceLine(BuilderImpl builder) {
        this.status = builder.status;
        this.dataConfiguration = builder.dataConfiguration;
        this.styleConfiguration = builder.styleConfiguration;
        this.labelConfiguration = builder.labelConfiguration;
    }

    public final WidgetStatus status() {
        return WidgetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ReferenceLineDataConfiguration dataConfiguration() {
        return this.dataConfiguration;
    }

    public final ReferenceLineStyleConfiguration styleConfiguration() {
        return this.styleConfiguration;
    }

    public final ReferenceLineLabelConfiguration labelConfiguration() {
        return this.labelConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.styleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLine)) {
            return false;
        }
        ReferenceLine other = (ReferenceLine)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.dataConfiguration(), other.dataConfiguration()) && Objects.equals(this.styleConfiguration(), other.styleConfiguration()) && Objects.equals(this.labelConfiguration(), other.labelConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceLine").add("Status", (Object)this.statusAsString()).add("DataConfiguration", (Object)this.dataConfiguration()).add("StyleConfiguration", (Object)this.styleConfiguration()).add("LabelConfiguration", (Object)this.labelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DataConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataConfiguration()));
            }
            case "StyleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.styleConfiguration()));
            }
            case "LabelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.labelConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLine, T> g) {
        return obj -> g.apply((ReferenceLine)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private ReferenceLineDataConfiguration dataConfiguration;
        private ReferenceLineStyleConfiguration styleConfiguration;
        private ReferenceLineLabelConfiguration labelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLine model) {
            this.status(model.status);
            this.dataConfiguration(model.dataConfiguration);
            this.styleConfiguration(model.styleConfiguration);
            this.labelConfiguration(model.labelConfiguration);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ReferenceLineDataConfiguration.Builder getDataConfiguration() {
            return this.dataConfiguration != null ? this.dataConfiguration.toBuilder() : null;
        }

        public final void setDataConfiguration(ReferenceLineDataConfiguration.BuilderImpl dataConfiguration) {
            this.dataConfiguration = dataConfiguration != null ? dataConfiguration.build() : null;
        }

        @Override
        public final Builder dataConfiguration(ReferenceLineDataConfiguration dataConfiguration) {
            this.dataConfiguration = dataConfiguration;
            return this;
        }

        public final ReferenceLineStyleConfiguration.Builder getStyleConfiguration() {
            return this.styleConfiguration != null ? this.styleConfiguration.toBuilder() : null;
        }

        public final void setStyleConfiguration(ReferenceLineStyleConfiguration.BuilderImpl styleConfiguration) {
            this.styleConfiguration = styleConfiguration != null ? styleConfiguration.build() : null;
        }

        @Override
        public final Builder styleConfiguration(ReferenceLineStyleConfiguration styleConfiguration) {
            this.styleConfiguration = styleConfiguration;
            return this;
        }

        public final ReferenceLineLabelConfiguration.Builder getLabelConfiguration() {
            return this.labelConfiguration != null ? this.labelConfiguration.toBuilder() : null;
        }

        public final void setLabelConfiguration(ReferenceLineLabelConfiguration.BuilderImpl labelConfiguration) {
            this.labelConfiguration = labelConfiguration != null ? labelConfiguration.build() : null;
        }

        @Override
        public final Builder labelConfiguration(ReferenceLineLabelConfiguration labelConfiguration) {
            this.labelConfiguration = labelConfiguration;
            return this;
        }

        public ReferenceLine build() {
            return new ReferenceLine(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceLine> {
        public Builder status(String var1);

        public Builder status(WidgetStatus var1);

        public Builder dataConfiguration(ReferenceLineDataConfiguration var1);

        default public Builder dataConfiguration(Consumer<ReferenceLineDataConfiguration.Builder> dataConfiguration) {
            return this.dataConfiguration((ReferenceLineDataConfiguration)((ReferenceLineDataConfiguration.Builder)ReferenceLineDataConfiguration.builder().applyMutation(dataConfiguration)).build());
        }

        public Builder styleConfiguration(ReferenceLineStyleConfiguration var1);

        default public Builder styleConfiguration(Consumer<ReferenceLineStyleConfiguration.Builder> styleConfiguration) {
            return this.styleConfiguration((ReferenceLineStyleConfiguration)((ReferenceLineStyleConfiguration.Builder)ReferenceLineStyleConfiguration.builder().applyMutation(styleConfiguration)).build());
        }

        public Builder labelConfiguration(ReferenceLineLabelConfiguration var1);

        default public Builder labelConfiguration(Consumer<ReferenceLineLabelConfiguration.Builder> labelConfiguration) {
            return this.labelConfiguration((ReferenceLineLabelConfiguration)((ReferenceLineLabelConfiguration.Builder)ReferenceLineLabelConfiguration.builder().applyMutation(labelConfiguration)).build());
        }
    }
}

