/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleResourcePermissions;
import software.amazon.awssdk.services.quicksight.model.AssetBundleRestrictiveResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobDataSetOverridePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobDataSetOverridePermissions> {
    private static final SdkField<List<String>> DATA_SET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSetIds").getter(AssetBundleImportJobDataSetOverridePermissions.getter(AssetBundleImportJobDataSetOverridePermissions::dataSetIds)).setter(AssetBundleImportJobDataSetOverridePermissions.setter(Builder::dataSetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssetBundleResourcePermissions> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(AssetBundleImportJobDataSetOverridePermissions.getter(AssetBundleImportJobDataSetOverridePermissions::permissions)).setter(AssetBundleImportJobDataSetOverridePermissions.setter(Builder::permissions)).constructor(AssetBundleResourcePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IDS_FIELD, PERMISSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> dataSetIds;
    private final AssetBundleResourcePermissions permissions;

    private AssetBundleImportJobDataSetOverridePermissions(BuilderImpl builder) {
        this.dataSetIds = builder.dataSetIds;
        this.permissions = builder.permissions;
    }

    public final boolean hasDataSetIds() {
        return this.dataSetIds != null && !(this.dataSetIds instanceof SdkAutoConstructList);
    }

    public final List<String> dataSetIds() {
        return this.dataSetIds;
    }

    public final AssetBundleResourcePermissions permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetIds() ? this.dataSetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDataSetOverridePermissions)) {
            return false;
        }
        AssetBundleImportJobDataSetOverridePermissions other = (AssetBundleImportJobDataSetOverridePermissions)obj;
        return this.hasDataSetIds() == other.hasDataSetIds() && Objects.equals(this.dataSetIds(), other.dataSetIds()) && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobDataSetOverridePermissions").add("DataSetIds", this.hasDataSetIds() ? this.dataSetIds() : null).add("Permissions", (Object)this.permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetIds": {
                return Optional.ofNullable(clazz.cast(this.dataSetIds()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDataSetOverridePermissions, T> g) {
        return obj -> g.apply((AssetBundleImportJobDataSetOverridePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> dataSetIds = DefaultSdkAutoConstructList.getInstance();
        private AssetBundleResourcePermissions permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDataSetOverridePermissions model) {
            this.dataSetIds(model.dataSetIds);
            this.permissions(model.permissions);
        }

        public final Collection<String> getDataSetIds() {
            if (this.dataSetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataSetIds;
        }

        public final void setDataSetIds(Collection<String> dataSetIds) {
            this.dataSetIds = AssetBundleRestrictiveResourceIdListCopier.copy(dataSetIds);
        }

        @Override
        public final Builder dataSetIds(Collection<String> dataSetIds) {
            this.dataSetIds = AssetBundleRestrictiveResourceIdListCopier.copy(dataSetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetIds(String ... dataSetIds) {
            this.dataSetIds(Arrays.asList(dataSetIds));
            return this;
        }

        public final AssetBundleResourcePermissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(AssetBundleResourcePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(AssetBundleResourcePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public AssetBundleImportJobDataSetOverridePermissions build() {
            return new AssetBundleImportJobDataSetOverridePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobDataSetOverridePermissions> {
        public Builder dataSetIds(Collection<String> var1);

        public Builder dataSetIds(String ... var1);

        public Builder permissions(AssetBundleResourcePermissions var1);

        default public Builder permissions(Consumer<AssetBundleResourcePermissions.Builder> permissions) {
            return this.permissions((AssetBundleResourcePermissions)((AssetBundleResourcePermissions.Builder)AssetBundleResourcePermissions.builder().applyMutation(permissions)).build());
        }
    }
}

