/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListThemesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemesResponse;
import software.amazon.awssdk.services.quicksight.model.ThemeSummary;

public class ListThemesIterable
implements SdkIterable<ListThemesResponse> {
    private final QuickSightClient client;
    private final ListThemesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThemesIterable(QuickSightClient client, ListThemesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListThemesResponseFetcher();
    }

    public Iterator<ListThemesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ThemeSummary> themeSummaryList() {
        Function<ListThemesResponse, Iterator> getIterator = response -> {
            if (response != null && response.themeSummaryList() != null) {
                return response.themeSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThemesResponseFetcher
    implements SyncPageFetcher<ListThemesResponse> {
        private ListThemesResponseFetcher() {
        }

        public boolean hasNextPage(ListThemesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThemesResponse nextPage(ListThemesResponse previousPage) {
            if (previousPage == null) {
                return ListThemesIterable.this.client.listThemes(ListThemesIterable.this.firstRequest);
            }
            return ListThemesIterable.this.client.listThemes((ListThemesRequest)((Object)ListThemesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

