/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a semantic entity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SemanticEntityType implements SdkPojo, Serializable,
        ToCopyableBuilder<SemanticEntityType.Builder, SemanticEntityType> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(SemanticEntityType::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> SUB_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubTypeName").getter(getter(SemanticEntityType::subTypeName)).setter(setter(Builder::subTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubTypeName").build()).build();

    private static final SdkField<Map<String, String>> TYPE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TypeParameters")
            .getter(getter(SemanticEntityType::typeParameters))
            .setter(setter(Builder::typeParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            SUB_TYPE_NAME_FIELD, TYPE_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String typeName;

    private final String subTypeName;

    private final Map<String, String> typeParameters;

    private SemanticEntityType(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.subTypeName = builder.subTypeName;
        this.typeParameters = builder.typeParameters;
    }

    /**
     * <p>
     * The semantic entity type name.
     * </p>
     * 
     * @return The semantic entity type name.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The semantic entity sub type name.
     * </p>
     * 
     * @return The semantic entity sub type name.
     */
    public final String subTypeName() {
        return subTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the TypeParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTypeParameters() {
        return typeParameters != null && !(typeParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The semantic entity type parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypeParameters} method.
     * </p>
     * 
     * @return The semantic entity type parameters.
     */
    public final Map<String, String> typeParameters() {
        return typeParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(subTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypeParameters() ? typeParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticEntityType)) {
            return false;
        }
        SemanticEntityType other = (SemanticEntityType) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(subTypeName(), other.subTypeName())
                && hasTypeParameters() == other.hasTypeParameters() && Objects.equals(typeParameters(), other.typeParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SemanticEntityType").add("TypeName", typeName()).add("SubTypeName", subTypeName())
                .add("TypeParameters", hasTypeParameters() ? typeParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "SubTypeName":
            return Optional.ofNullable(clazz.cast(subTypeName()));
        case "TypeParameters":
            return Optional.ofNullable(clazz.cast(typeParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SemanticEntityType, T> g) {
        return obj -> g.apply((SemanticEntityType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SemanticEntityType> {
        /**
         * <p>
         * The semantic entity type name.
         * </p>
         * 
         * @param typeName
         *        The semantic entity type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The semantic entity sub type name.
         * </p>
         * 
         * @param subTypeName
         *        The semantic entity sub type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subTypeName(String subTypeName);

        /**
         * <p>
         * The semantic entity type parameters.
         * </p>
         * 
         * @param typeParameters
         *        The semantic entity type parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeParameters(Map<String, String> typeParameters);
    }

    static final class BuilderImpl implements Builder {
        private String typeName;

        private String subTypeName;

        private Map<String, String> typeParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticEntityType model) {
            typeName(model.typeName);
            subTypeName(model.subTypeName);
            typeParameters(model.typeParameters);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getSubTypeName() {
            return subTypeName;
        }

        public final void setSubTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
        }

        @Override
        public final Builder subTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
            return this;
        }

        public final Map<String, String> getTypeParameters() {
            if (typeParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return typeParameters;
        }

        public final void setTypeParameters(Map<String, String> typeParameters) {
            this.typeParameters = TypeParametersCopier.copy(typeParameters);
        }

        @Override
        public final Builder typeParameters(Map<String, String> typeParameters) {
            this.typeParameters = TypeParametersCopier.copy(typeParameters);
            return this;
        }

        @Override
        public SemanticEntityType build() {
            return new SemanticEntityType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
