/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a sankey diagram.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SankeyDiagramChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SankeyDiagramChartConfiguration.Builder, SankeyDiagramChartConfiguration> {
    private static final SdkField<SankeyDiagramFieldWells> FIELD_WELLS_FIELD = SdkField
            .<SankeyDiagramFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(SankeyDiagramChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(SankeyDiagramFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<SankeyDiagramSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<SankeyDiagramSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(SankeyDiagramChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(SankeyDiagramSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(SankeyDiagramChartConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(SankeyDiagramChartConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, DATA_LABELS_FIELD, INTERACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SankeyDiagramFieldWells fieldWells;

    private final SankeyDiagramSortConfiguration sortConfiguration;

    private final DataLabelOptions dataLabels;

    private final VisualInteractionOptions interactions;

    private SankeyDiagramChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.dataLabels = builder.dataLabels;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field well configuration of a sankey diagram.
     * </p>
     * 
     * @return The field well configuration of a sankey diagram.
     */
    public final SankeyDiagramFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a sankey diagram.
     * </p>
     * 
     * @return The sort configuration of a sankey diagram.
     */
    public final SankeyDiagramSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The data label configuration of a sankey diagram.
     * </p>
     * 
     * @return The data label configuration of a sankey diagram.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SankeyDiagramChartConfiguration)) {
            return false;
        }
        SankeyDiagramChartConfiguration other = (SankeyDiagramChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(dataLabels(), other.dataLabels()) && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SankeyDiagramChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("DataLabels", dataLabels())
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SankeyDiagramChartConfiguration, T> g) {
        return obj -> g.apply((SankeyDiagramChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SankeyDiagramChartConfiguration> {
        /**
         * <p>
         * The field well configuration of a sankey diagram.
         * </p>
         * 
         * @param fieldWells
         *        The field well configuration of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(SankeyDiagramFieldWells fieldWells);

        /**
         * <p>
         * The field well configuration of a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the {@link SankeyDiagramFieldWells.Builder} avoiding
         * the need to create one manually via {@link SankeyDiagramFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SankeyDiagramFieldWells.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldWells(SankeyDiagramFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link SankeyDiagramFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(SankeyDiagramFieldWells)
         */
        default Builder fieldWells(Consumer<SankeyDiagramFieldWells.Builder> fieldWells) {
            return fieldWells(SankeyDiagramFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a sankey diagram.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(SankeyDiagramSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the {@link SankeyDiagramSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link SankeyDiagramSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SankeyDiagramSortConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortConfiguration(SankeyDiagramSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link SankeyDiagramSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(SankeyDiagramSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<SankeyDiagramSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(SankeyDiagramSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The data label configuration of a sankey diagram.
         * </p>
         * 
         * @param dataLabels
         *        The data label configuration of a sankey diagram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The data label configuration of a sankey diagram.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SankeyDiagramFieldWells fieldWells;

        private SankeyDiagramSortConfiguration sortConfiguration;

        private DataLabelOptions dataLabels;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(SankeyDiagramChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            dataLabels(model.dataLabels);
            interactions(model.interactions);
        }

        public final SankeyDiagramFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(SankeyDiagramFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(SankeyDiagramFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final SankeyDiagramSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(SankeyDiagramSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(SankeyDiagramSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public SankeyDiagramChartConfiguration build() {
            return new SankeyDiagramChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
