/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the presentation of the data labels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunnelChartDataLabelOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<FunnelChartDataLabelOptions.Builder, FunnelChartDataLabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(FunnelChartDataLabelOptions::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> CATEGORY_LABEL_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CategoryLabelVisibility").getter(getter(FunnelChartDataLabelOptions::categoryLabelVisibilityAsString))
            .setter(setter(Builder::categoryLabelVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelVisibility").build())
            .build();

    private static final SdkField<String> MEASURE_LABEL_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureLabelVisibility").getter(getter(FunnelChartDataLabelOptions::measureLabelVisibilityAsString))
            .setter(setter(Builder::measureLabelVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureLabelVisibility").build())
            .build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Position").getter(getter(FunnelChartDataLabelOptions::positionAsString))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build()).build();

    private static final SdkField<FontConfiguration> LABEL_FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO).memberName("LabelFontConfiguration")
            .getter(getter(FunnelChartDataLabelOptions::labelFontConfiguration)).setter(setter(Builder::labelFontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelFontConfiguration").build())
            .build();

    private static final SdkField<String> LABEL_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelColor").getter(getter(FunnelChartDataLabelOptions::labelColor)).setter(setter(Builder::labelColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelColor").build()).build();

    private static final SdkField<String> MEASURE_DATA_LABEL_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureDataLabelStyle").getter(getter(FunnelChartDataLabelOptions::measureDataLabelStyleAsString))
            .setter(setter(Builder::measureDataLabelStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureDataLabelStyle").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD,
            CATEGORY_LABEL_VISIBILITY_FIELD, MEASURE_LABEL_VISIBILITY_FIELD, POSITION_FIELD, LABEL_FONT_CONFIGURATION_FIELD,
            LABEL_COLOR_FIELD, MEASURE_DATA_LABEL_STYLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final String categoryLabelVisibility;

    private final String measureLabelVisibility;

    private final String position;

    private final FontConfiguration labelFontConfiguration;

    private final String labelColor;

    private final String measureDataLabelStyle;

    private FunnelChartDataLabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.categoryLabelVisibility = builder.categoryLabelVisibility;
        this.measureLabelVisibility = builder.measureLabelVisibility;
        this.position = builder.position;
        this.labelFontConfiguration = builder.labelFontConfiguration;
        this.labelColor = builder.labelColor;
        this.measureDataLabelStyle = builder.measureDataLabelStyle;
    }

    /**
     * <p>
     * The visibility option that determines if data labels are displayed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility option that determines if data labels are displayed.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility option that determines if data labels are displayed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility option that determines if data labels are displayed.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The visibility of the category labels within the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoryLabelVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #categoryLabelVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the category labels within the data labels.
     * @see Visibility
     */
    public final Visibility categoryLabelVisibility() {
        return Visibility.fromValue(categoryLabelVisibility);
    }

    /**
     * <p>
     * The visibility of the category labels within the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoryLabelVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #categoryLabelVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the category labels within the data labels.
     * @see Visibility
     */
    public final String categoryLabelVisibilityAsString() {
        return categoryLabelVisibility;
    }

    /**
     * <p>
     * The visibility of the measure labels within the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #measureLabelVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #measureLabelVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the measure labels within the data labels.
     * @see Visibility
     */
    public final Visibility measureLabelVisibility() {
        return Visibility.fromValue(measureLabelVisibility);
    }

    /**
     * <p>
     * The visibility of the measure labels within the data labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #measureLabelVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #measureLabelVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the measure labels within the data labels.
     * @see Visibility
     */
    public final String measureLabelVisibilityAsString() {
        return measureLabelVisibility;
    }

    /**
     * <p>
     * Determines the positioning of the data label relative to a section of the funnel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link DataLabelPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #positionAsString}.
     * </p>
     * 
     * @return Determines the positioning of the data label relative to a section of the funnel.
     * @see DataLabelPosition
     */
    public final DataLabelPosition position() {
        return DataLabelPosition.fromValue(position);
    }

    /**
     * <p>
     * Determines the positioning of the data label relative to a section of the funnel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link DataLabelPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #positionAsString}.
     * </p>
     * 
     * @return Determines the positioning of the data label relative to a section of the funnel.
     * @see DataLabelPosition
     */
    public final String positionAsString() {
        return position;
    }

    /**
     * <p>
     * The font configuration for the data labels.
     * </p>
     * <p>
     * Only the <code>FontSize</code> attribute of the font configuration is used for data labels.
     * </p>
     * 
     * @return The font configuration for the data labels.</p>
     *         <p>
     *         Only the <code>FontSize</code> attribute of the font configuration is used for data labels.
     */
    public final FontConfiguration labelFontConfiguration() {
        return labelFontConfiguration;
    }

    /**
     * <p>
     * The color of the data label text.
     * </p>
     * 
     * @return The color of the data label text.
     */
    public final String labelColor() {
        return labelColor;
    }

    /**
     * <p>
     * Determines the style of the metric labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #measureDataLabelStyle} will return {@link FunnelChartMeasureDataLabelStyle#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #measureDataLabelStyleAsString}.
     * </p>
     * 
     * @return Determines the style of the metric labels.
     * @see FunnelChartMeasureDataLabelStyle
     */
    public final FunnelChartMeasureDataLabelStyle measureDataLabelStyle() {
        return FunnelChartMeasureDataLabelStyle.fromValue(measureDataLabelStyle);
    }

    /**
     * <p>
     * Determines the style of the metric labels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #measureDataLabelStyle} will return {@link FunnelChartMeasureDataLabelStyle#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #measureDataLabelStyleAsString}.
     * </p>
     * 
     * @return Determines the style of the metric labels.
     * @see FunnelChartMeasureDataLabelStyle
     */
    public final String measureDataLabelStyleAsString() {
        return measureDataLabelStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(measureLabelVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(labelFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(labelColor());
        hashCode = 31 * hashCode + Objects.hashCode(measureDataLabelStyleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunnelChartDataLabelOptions)) {
            return false;
        }
        FunnelChartDataLabelOptions other = (FunnelChartDataLabelOptions) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(categoryLabelVisibilityAsString(), other.categoryLabelVisibilityAsString())
                && Objects.equals(measureLabelVisibilityAsString(), other.measureLabelVisibilityAsString())
                && Objects.equals(positionAsString(), other.positionAsString())
                && Objects.equals(labelFontConfiguration(), other.labelFontConfiguration())
                && Objects.equals(labelColor(), other.labelColor())
                && Objects.equals(measureDataLabelStyleAsString(), other.measureDataLabelStyleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunnelChartDataLabelOptions").add("Visibility", visibilityAsString())
                .add("CategoryLabelVisibility", categoryLabelVisibilityAsString())
                .add("MeasureLabelVisibility", measureLabelVisibilityAsString()).add("Position", positionAsString())
                .add("LabelFontConfiguration", labelFontConfiguration()).add("LabelColor", labelColor())
                .add("MeasureDataLabelStyle", measureDataLabelStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "CategoryLabelVisibility":
            return Optional.ofNullable(clazz.cast(categoryLabelVisibilityAsString()));
        case "MeasureLabelVisibility":
            return Optional.ofNullable(clazz.cast(measureLabelVisibilityAsString()));
        case "Position":
            return Optional.ofNullable(clazz.cast(positionAsString()));
        case "LabelFontConfiguration":
            return Optional.ofNullable(clazz.cast(labelFontConfiguration()));
        case "LabelColor":
            return Optional.ofNullable(clazz.cast(labelColor()));
        case "MeasureDataLabelStyle":
            return Optional.ofNullable(clazz.cast(measureDataLabelStyleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunnelChartDataLabelOptions, T> g) {
        return obj -> g.apply((FunnelChartDataLabelOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunnelChartDataLabelOptions> {
        /**
         * <p>
         * The visibility option that determines if data labels are displayed.
         * </p>
         * 
         * @param visibility
         *        The visibility option that determines if data labels are displayed.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility option that determines if data labels are displayed.
         * </p>
         * 
         * @param visibility
         *        The visibility option that determines if data labels are displayed.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The visibility of the category labels within the data labels.
         * </p>
         * 
         * @param categoryLabelVisibility
         *        The visibility of the category labels within the data labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder categoryLabelVisibility(String categoryLabelVisibility);

        /**
         * <p>
         * The visibility of the category labels within the data labels.
         * </p>
         * 
         * @param categoryLabelVisibility
         *        The visibility of the category labels within the data labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder categoryLabelVisibility(Visibility categoryLabelVisibility);

        /**
         * <p>
         * The visibility of the measure labels within the data labels.
         * </p>
         * 
         * @param measureLabelVisibility
         *        The visibility of the measure labels within the data labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder measureLabelVisibility(String measureLabelVisibility);

        /**
         * <p>
         * The visibility of the measure labels within the data labels.
         * </p>
         * 
         * @param measureLabelVisibility
         *        The visibility of the measure labels within the data labels.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder measureLabelVisibility(Visibility measureLabelVisibility);

        /**
         * <p>
         * Determines the positioning of the data label relative to a section of the funnel.
         * </p>
         * 
         * @param position
         *        Determines the positioning of the data label relative to a section of the funnel.
         * @see DataLabelPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLabelPosition
         */
        Builder position(String position);

        /**
         * <p>
         * Determines the positioning of the data label relative to a section of the funnel.
         * </p>
         * 
         * @param position
         *        Determines the positioning of the data label relative to a section of the funnel.
         * @see DataLabelPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLabelPosition
         */
        Builder position(DataLabelPosition position);

        /**
         * <p>
         * The font configuration for the data labels.
         * </p>
         * <p>
         * Only the <code>FontSize</code> attribute of the font configuration is used for data labels.
         * </p>
         * 
         * @param labelFontConfiguration
         *        The font configuration for the data labels.</p>
         *        <p>
         *        Only the <code>FontSize</code> attribute of the font configuration is used for data labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelFontConfiguration(FontConfiguration labelFontConfiguration);

        /**
         * <p>
         * The font configuration for the data labels.
         * </p>
         * <p>
         * Only the <code>FontSize</code> attribute of the font configuration is used for data labels.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #labelFontConfiguration(FontConfiguration)}.
         * 
         * @param labelFontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelFontConfiguration(FontConfiguration)
         */
        default Builder labelFontConfiguration(Consumer<FontConfiguration.Builder> labelFontConfiguration) {
            return labelFontConfiguration(FontConfiguration.builder().applyMutation(labelFontConfiguration).build());
        }

        /**
         * <p>
         * The color of the data label text.
         * </p>
         * 
         * @param labelColor
         *        The color of the data label text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelColor(String labelColor);

        /**
         * <p>
         * Determines the style of the metric labels.
         * </p>
         * 
         * @param measureDataLabelStyle
         *        Determines the style of the metric labels.
         * @see FunnelChartMeasureDataLabelStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunnelChartMeasureDataLabelStyle
         */
        Builder measureDataLabelStyle(String measureDataLabelStyle);

        /**
         * <p>
         * Determines the style of the metric labels.
         * </p>
         * 
         * @param measureDataLabelStyle
         *        Determines the style of the metric labels.
         * @see FunnelChartMeasureDataLabelStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunnelChartMeasureDataLabelStyle
         */
        Builder measureDataLabelStyle(FunnelChartMeasureDataLabelStyle measureDataLabelStyle);
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private String categoryLabelVisibility;

        private String measureLabelVisibility;

        private String position;

        private FontConfiguration labelFontConfiguration;

        private String labelColor;

        private String measureDataLabelStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(FunnelChartDataLabelOptions model) {
            visibility(model.visibility);
            categoryLabelVisibility(model.categoryLabelVisibility);
            measureLabelVisibility(model.measureLabelVisibility);
            position(model.position);
            labelFontConfiguration(model.labelFontConfiguration);
            labelColor(model.labelColor);
            measureDataLabelStyle(model.measureDataLabelStyle);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getCategoryLabelVisibility() {
            return categoryLabelVisibility;
        }

        public final void setCategoryLabelVisibility(String categoryLabelVisibility) {
            this.categoryLabelVisibility = categoryLabelVisibility;
        }

        @Override
        public final Builder categoryLabelVisibility(String categoryLabelVisibility) {
            this.categoryLabelVisibility = categoryLabelVisibility;
            return this;
        }

        @Override
        public final Builder categoryLabelVisibility(Visibility categoryLabelVisibility) {
            this.categoryLabelVisibility(categoryLabelVisibility == null ? null : categoryLabelVisibility.toString());
            return this;
        }

        public final String getMeasureLabelVisibility() {
            return measureLabelVisibility;
        }

        public final void setMeasureLabelVisibility(String measureLabelVisibility) {
            this.measureLabelVisibility = measureLabelVisibility;
        }

        @Override
        public final Builder measureLabelVisibility(String measureLabelVisibility) {
            this.measureLabelVisibility = measureLabelVisibility;
            return this;
        }

        @Override
        public final Builder measureLabelVisibility(Visibility measureLabelVisibility) {
            this.measureLabelVisibility(measureLabelVisibility == null ? null : measureLabelVisibility.toString());
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(DataLabelPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final FontConfiguration.Builder getLabelFontConfiguration() {
            return labelFontConfiguration != null ? labelFontConfiguration.toBuilder() : null;
        }

        public final void setLabelFontConfiguration(FontConfiguration.BuilderImpl labelFontConfiguration) {
            this.labelFontConfiguration = labelFontConfiguration != null ? labelFontConfiguration.build() : null;
        }

        @Override
        public final Builder labelFontConfiguration(FontConfiguration labelFontConfiguration) {
            this.labelFontConfiguration = labelFontConfiguration;
            return this;
        }

        public final String getLabelColor() {
            return labelColor;
        }

        public final void setLabelColor(String labelColor) {
            this.labelColor = labelColor;
        }

        @Override
        public final Builder labelColor(String labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public final String getMeasureDataLabelStyle() {
            return measureDataLabelStyle;
        }

        public final void setMeasureDataLabelStyle(String measureDataLabelStyle) {
            this.measureDataLabelStyle = measureDataLabelStyle;
        }

        @Override
        public final Builder measureDataLabelStyle(String measureDataLabelStyle) {
            this.measureDataLabelStyle = measureDataLabelStyle;
            return this;
        }

        @Override
        public final Builder measureDataLabelStyle(FunnelChartMeasureDataLabelStyle measureDataLabelStyle) {
            this.measureDataLabelStyle(measureDataLabelStyle == null ? null : measureDataLabelStyle.toString());
            return this;
        }

        @Override
        public FunnelChartDataLabelOptions build() {
            return new FunnelChartDataLabelOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
