/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>CategoryFilter</code> filters text values.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html">Adding text filters</a> in
 * the <i>Amazon QuickSight User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CategoryFilter implements SdkPojo, Serializable, ToCopyableBuilder<CategoryFilter.Builder, CategoryFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterId").getter(getter(CategoryFilter::filterId)).setter(setter(Builder::filterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(CategoryFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<CategoryFilterConfiguration> CONFIGURATION_FIELD = SdkField
            .<CategoryFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(CategoryFilter::configuration)).setter(setter(Builder::configuration))
            .constructor(CategoryFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField
            .<DefaultFilterControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultFilterControlConfiguration")
            .getter(getter(CategoryFilter::defaultFilterControlConfiguration))
            .setter(setter(Builder::defaultFilterControlConfiguration))
            .constructor(DefaultFilterControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD,
            CONFIGURATION_FIELD, DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterId;

    private final ColumnIdentifier column;

    private final CategoryFilterConfiguration configuration;

    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private CategoryFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.configuration = builder.configuration;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public final String filterId() {
        return filterId;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The configuration for a <code>CategoryFilter</code>.
     * </p>
     * 
     * @return The configuration for a <code>CategoryFilter</code>.
     */
    public final CategoryFilterConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     * 
     * @return The default configurations for the associated controls. This applies only for filters that are scoped to
     *         multiple sheets.
     */
    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return defaultFilterControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(defaultFilterControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryFilter)) {
            return false;
        }
        CategoryFilter other = (CategoryFilter) obj;
        return Objects.equals(filterId(), other.filterId()) && Objects.equals(column(), other.column())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CategoryFilter").add("FilterId", filterId()).add("Column", column())
                .add("Configuration", configuration())
                .add("DefaultFilterControlConfiguration", defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterId":
            return Optional.ofNullable(clazz.cast(filterId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "DefaultFilterControlConfiguration":
            return Optional.ofNullable(clazz.cast(defaultFilterControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CategoryFilter, T> g) {
        return obj -> g.apply((CategoryFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CategoryFilter> {
        /**
         * <p>
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * </p>
         * 
         * @param filterId
         *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterId(String filterId);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The configuration for a <code>CategoryFilter</code>.
         * </p>
         * 
         * @param configuration
         *        The configuration for a <code>CategoryFilter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CategoryFilterConfiguration configuration);

        /**
         * <p>
         * The configuration for a <code>CategoryFilter</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CategoryFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link CategoryFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CategoryFilterConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(CategoryFilterConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link CategoryFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(CategoryFilterConfiguration)
         */
        default Builder configuration(Consumer<CategoryFilterConfiguration.Builder> configuration) {
            return configuration(CategoryFilterConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * 
         * @param defaultFilterControlConfiguration
         *        The default configurations for the associated controls. This applies only for filters that are scoped
         *        to multiple sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultFilterControlConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultFilterControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFilterControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)}.
         * 
         * @param defaultFilterControlConfiguration
         *        a consumer that will call methods on {@link DefaultFilterControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)
         */
        default Builder defaultFilterControlConfiguration(
                Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return defaultFilterControlConfiguration(DefaultFilterControlConfiguration.builder()
                    .applyMutation(defaultFilterControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterId;

        private ColumnIdentifier column;

        private CategoryFilterConfiguration configuration;

        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryFilter model) {
            filterId(model.filterId);
            column(model.column);
            configuration(model.configuration);
            defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final String getFilterId() {
            return filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final CategoryFilterConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(CategoryFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CategoryFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(
                DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration
                    .build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        @Override
        public CategoryFilter build() {
            return new CategoryFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
