/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TimeGranularity {
    YEAR("YEAR"),
    QUARTER("QUARTER"),
    MONTH("MONTH"),
    WEEK("WEEK"),
    DAY("DAY"),
    HOUR("HOUR"),
    MINUTE("MINUTE"),
    SECOND("SECOND"),
    MILLISECOND("MILLISECOND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimeGranularity> VALUE_MAP;
    private final String value;

    private TimeGranularity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimeGranularity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimeGranularity> knownValues() {
        EnumSet<TimeGranularity> knownValues = EnumSet.allOf(TimeGranularity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TimeGranularity.class, TimeGranularity::toString);
    }
}

