/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AggregationFunction;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.DefaultFilterControlConfiguration;
import software.amazon.awssdk.services.quicksight.model.FilterNullOption;
import software.amazon.awssdk.services.quicksight.model.NumericEqualityMatchOperator;
import software.amazon.awssdk.services.quicksight.model.NumericFilterSelectAllOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NumericEqualityFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NumericEqualityFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterId").getter(NumericEqualityFilter.getter(NumericEqualityFilter::filterId)).setter(NumericEqualityFilter.setter(Builder::filterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(NumericEqualityFilter.getter(NumericEqualityFilter::column)).setter(NumericEqualityFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(NumericEqualityFilter.getter(NumericEqualityFilter::value)).setter(NumericEqualityFilter.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> SELECT_ALL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectAllOptions").getter(NumericEqualityFilter.getter(NumericEqualityFilter::selectAllOptionsAsString)).setter(NumericEqualityFilter.setter(Builder::selectAllOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()}).build();
    private static final SdkField<String> MATCH_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchOperator").getter(NumericEqualityFilter.getter(NumericEqualityFilter::matchOperatorAsString)).setter(NumericEqualityFilter.setter(Builder::matchOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOperator").build()}).build();
    private static final SdkField<AggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AggregationFunction").getter(NumericEqualityFilter.getter(NumericEqualityFilter::aggregationFunction)).setter(NumericEqualityFilter.setter(Builder::aggregationFunction)).constructor(AggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build()}).build();
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterName").getter(NumericEqualityFilter.getter(NumericEqualityFilter::parameterName)).setter(NumericEqualityFilter.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullOption").getter(NumericEqualityFilter.getter(NumericEqualityFilter::nullOptionAsString)).setter(NumericEqualityFilter.setter(Builder::nullOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()}).build();
    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultFilterControlConfiguration").getter(NumericEqualityFilter.getter(NumericEqualityFilter::defaultFilterControlConfiguration)).setter(NumericEqualityFilter.setter(Builder::defaultFilterControlConfiguration)).constructor(DefaultFilterControlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD, VALUE_FIELD, SELECT_ALL_OPTIONS_FIELD, MATCH_OPERATOR_FIELD, AGGREGATION_FUNCTION_FIELD, PARAMETER_NAME_FIELD, NULL_OPTION_FIELD, DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterId;
    private final ColumnIdentifier column;
    private final Double value;
    private final String selectAllOptions;
    private final String matchOperator;
    private final AggregationFunction aggregationFunction;
    private final String parameterName;
    private final String nullOption;
    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private NumericEqualityFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.value = builder.value;
        this.selectAllOptions = builder.selectAllOptions;
        this.matchOperator = builder.matchOperator;
        this.aggregationFunction = builder.aggregationFunction;
        this.parameterName = builder.parameterName;
        this.nullOption = builder.nullOption;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final Double value() {
        return this.value;
    }

    public final NumericFilterSelectAllOptions selectAllOptions() {
        return NumericFilterSelectAllOptions.fromValue(this.selectAllOptions);
    }

    public final String selectAllOptionsAsString() {
        return this.selectAllOptions;
    }

    public final NumericEqualityMatchOperator matchOperator() {
        return NumericEqualityMatchOperator.fromValue(this.matchOperator);
    }

    public final String matchOperatorAsString() {
        return this.matchOperator;
    }

    public final AggregationFunction aggregationFunction() {
        return this.aggregationFunction;
    }

    public final String parameterName() {
        return this.parameterName;
    }

    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(this.nullOption);
    }

    public final String nullOptionAsString() {
        return this.nullOption;
    }

    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return this.defaultFilterControlConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectAllOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultFilterControlConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericEqualityFilter)) {
            return false;
        }
        NumericEqualityFilter other = (NumericEqualityFilter)obj;
        return Objects.equals(this.filterId(), other.filterId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.selectAllOptionsAsString(), other.selectAllOptionsAsString()) && Objects.equals(this.matchOperatorAsString(), other.matchOperatorAsString()) && Objects.equals(this.aggregationFunction(), other.aggregationFunction()) && Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.nullOptionAsString(), other.nullOptionAsString()) && Objects.equals(this.defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"NumericEqualityFilter").add("FilterId", (Object)this.filterId()).add("Column", (Object)this.column()).add("Value", (Object)this.value()).add("SelectAllOptions", (Object)this.selectAllOptionsAsString()).add("MatchOperator", (Object)this.matchOperatorAsString()).add("AggregationFunction", (Object)this.aggregationFunction()).add("ParameterName", (Object)this.parameterName()).add("NullOption", (Object)this.nullOptionAsString()).add("DefaultFilterControlConfiguration", (Object)this.defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterId": {
                return Optional.ofNullable(clazz.cast(this.filterId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "SelectAllOptions": {
                return Optional.ofNullable(clazz.cast(this.selectAllOptionsAsString()));
            }
            case "MatchOperator": {
                return Optional.ofNullable(clazz.cast(this.matchOperatorAsString()));
            }
            case "AggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunction()));
            }
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "NullOption": {
                return Optional.ofNullable(clazz.cast(this.nullOptionAsString()));
            }
            case "DefaultFilterControlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultFilterControlConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumericEqualityFilter, T> g) {
        return obj -> g.apply((NumericEqualityFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterId;
        private ColumnIdentifier column;
        private Double value;
        private String selectAllOptions;
        private String matchOperator;
        private AggregationFunction aggregationFunction;
        private String parameterName;
        private String nullOption;
        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericEqualityFilter model) {
            this.filterId(model.filterId);
            this.column(model.column);
            this.value(model.value);
            this.selectAllOptions(model.selectAllOptions);
            this.matchOperator(model.matchOperator);
            this.aggregationFunction(model.aggregationFunction);
            this.parameterName(model.parameterName);
            this.nullOption(model.nullOption);
            this.defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final String getFilterId() {
            return this.filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getSelectAllOptions() {
            return this.selectAllOptions;
        }

        public final void setSelectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
        }

        @Override
        public final Builder selectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        @Override
        public final Builder selectAllOptions(NumericFilterSelectAllOptions selectAllOptions) {
            this.selectAllOptions(selectAllOptions == null ? null : selectAllOptions.toString());
            return this;
        }

        public final String getMatchOperator() {
            return this.matchOperator;
        }

        public final void setMatchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
        }

        @Override
        public final Builder matchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
            return this;
        }

        @Override
        public final Builder matchOperator(NumericEqualityMatchOperator matchOperator) {
            this.matchOperator(matchOperator == null ? null : matchOperator.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregationFunction() {
            return this.aggregationFunction != null ? this.aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(AggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getNullOption() {
            return this.nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return this.defaultFilterControlConfiguration != null ? this.defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        public NumericEqualityFilter build() {
            return new NumericEqualityFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NumericEqualityFilter> {
        public Builder filterId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder value(Double var1);

        public Builder selectAllOptions(String var1);

        public Builder selectAllOptions(NumericFilterSelectAllOptions var1);

        public Builder matchOperator(String var1);

        public Builder matchOperator(NumericEqualityMatchOperator var1);

        public Builder aggregationFunction(AggregationFunction var1);

        default public Builder aggregationFunction(Consumer<AggregationFunction.Builder> aggregationFunction) {
            return this.aggregationFunction((AggregationFunction)((AggregationFunction.Builder)AggregationFunction.builder().applyMutation(aggregationFunction)).build());
        }

        public Builder parameterName(String var1);

        public Builder nullOption(String var1);

        public Builder nullOption(FilterNullOption var1);

        public Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration var1);

        default public Builder defaultFilterControlConfiguration(Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return this.defaultFilterControlConfiguration((DefaultFilterControlConfiguration)((DefaultFilterControlConfiguration.Builder)DefaultFilterControlConfiguration.builder().applyMutation(defaultFilterControlConfiguration)).build());
        }
    }
}

