/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.SnapshotJobErrorInfo;
import software.amazon.awssdk.services.quicksight.model.SnapshotJobResult;
import software.amazon.awssdk.services.quicksight.model.SnapshotJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDashboardSnapshotJobResultResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeDashboardSnapshotJobResultResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeDashboardSnapshotJobResultResponse.getter(DescribeDashboardSnapshotJobResultResponse::arn)).setter(DescribeDashboardSnapshotJobResultResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(DescribeDashboardSnapshotJobResultResponse.getter(DescribeDashboardSnapshotJobResultResponse::jobStatusAsString)).setter(DescribeDashboardSnapshotJobResultResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeDashboardSnapshotJobResultResponse.getter(DescribeDashboardSnapshotJobResultResponse::createdTime)).setter(DescribeDashboardSnapshotJobResultResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeDashboardSnapshotJobResultResponse.getter(DescribeDashboardSnapshotJobResultResponse::lastUpdatedTime)).setter(DescribeDashboardSnapshotJobResultResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<SnapshotJobResult> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Result").getter(DescribeDashboardSnapshotJobResultResponse.getter(DescribeDashboardSnapshotJobResultResponse::result)).setter(DescribeDashboardSnapshotJobResultResponse.setter(Builder::result)).constructor(SnapshotJobResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()}).build();
    private static final SdkField<SnapshotJobErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorInfo").getter(DescribeDashboardSnapshotJobResultResponse.getter(DescribeDashboardSnapshotJobResultResponse::errorInfo)).setter(DescribeDashboardSnapshotJobResultResponse.setter(Builder::errorInfo)).constructor(SnapshotJobErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeDashboardSnapshotJobResultResponse.getter(DescribeDashboardSnapshotJobResultResponse::requestId)).setter(DescribeDashboardSnapshotJobResultResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeDashboardSnapshotJobResultResponse.getter(DescribeDashboardSnapshotJobResultResponse::status)).setter(DescribeDashboardSnapshotJobResultResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, JOB_STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RESULT_FIELD, ERROR_INFO_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String arn;
    private final String jobStatus;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final SnapshotJobResult result;
    private final SnapshotJobErrorInfo errorInfo;
    private final String requestId;
    private final Integer status;

    private DescribeDashboardSnapshotJobResultResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.jobStatus = builder.jobStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.result = builder.result;
        this.errorInfo = builder.errorInfo;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final SnapshotJobStatus jobStatus() {
        return SnapshotJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final SnapshotJobResult result() {
        return this.result;
    }

    public final SnapshotJobErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardSnapshotJobResultResponse)) {
            return false;
        }
        DescribeDashboardSnapshotJobResultResponse other = (DescribeDashboardSnapshotJobResultResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDashboardSnapshotJobResultResponse").add("Arn", (Object)this.arn()).add("JobStatus", (Object)this.jobStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Result", (Object)this.result()).add("ErrorInfo", (Object)this.errorInfo()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "ErrorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardSnapshotJobResultResponse, T> g) {
        return obj -> g.apply((DescribeDashboardSnapshotJobResultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String jobStatus;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private SnapshotJobResult result;
        private SnapshotJobErrorInfo errorInfo;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardSnapshotJobResultResponse model) {
            super(model);
            this.arn(model.arn);
            this.jobStatus(model.jobStatus);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.result(model.result);
            this.errorInfo(model.errorInfo);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(SnapshotJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final SnapshotJobResult.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        public final void setResult(SnapshotJobResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(SnapshotJobResult result) {
            this.result = result;
            return this;
        }

        public final SnapshotJobErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(SnapshotJobErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(SnapshotJobErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeDashboardSnapshotJobResultResponse build() {
            return new DescribeDashboardSnapshotJobResultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDashboardSnapshotJobResultResponse> {
        public Builder arn(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(SnapshotJobStatus var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder result(SnapshotJobResult var1);

        default public Builder result(Consumer<SnapshotJobResult.Builder> result) {
            return this.result((SnapshotJobResult)((SnapshotJobResult.Builder)SnapshotJobResult.builder().applyMutation(result)).build());
        }

        public Builder errorInfo(SnapshotJobErrorInfo var1);

        default public Builder errorInfo(Consumer<SnapshotJobErrorInfo.Builder> errorInfo) {
            return this.errorInfo((SnapshotJobErrorInfo)((SnapshotJobErrorInfo.Builder)SnapshotJobErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

