/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a waterfall visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaterfallChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WaterfallChartConfiguration.Builder, WaterfallChartConfiguration> {
    private static final SdkField<WaterfallChartFieldWells> FIELD_WELLS_FIELD = SdkField
            .<WaterfallChartFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(WaterfallChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(WaterfallChartFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<WaterfallChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<WaterfallChartSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(WaterfallChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(WaterfallChartSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<WaterfallChartOptions> WATERFALL_CHART_OPTIONS_FIELD = SdkField
            .<WaterfallChartOptions> builder(MarshallingType.SDK_POJO).memberName("WaterfallChartOptions")
            .getter(getter(WaterfallChartConfiguration::waterfallChartOptions)).setter(setter(Builder::waterfallChartOptions))
            .constructor(WaterfallChartOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaterfallChartOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> CATEGORY_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryAxisLabelOptions")
            .getter(getter(WaterfallChartConfiguration::categoryAxisLabelOptions))
            .setter(setter(Builder::categoryAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxisLabelOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO)
            .memberName("CategoryAxisDisplayOptions")
            .getter(getter(WaterfallChartConfiguration::categoryAxisDisplayOptions))
            .setter(setter(Builder::categoryAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("PrimaryYAxisLabelOptions")
            .getter(getter(WaterfallChartConfiguration::primaryYAxisLabelOptions))
            .setter(setter(Builder::primaryYAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisLabelOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryYAxisDisplayOptions")
            .getter(getter(WaterfallChartConfiguration::primaryYAxisDisplayOptions))
            .setter(setter(Builder::primaryYAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisDisplayOptions").build())
            .build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(WaterfallChartConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(WaterfallChartConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(WaterfallChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<WaterfallChartColorConfiguration> COLOR_CONFIGURATION_FIELD = SdkField
            .<WaterfallChartColorConfiguration> builder(MarshallingType.SDK_POJO).memberName("ColorConfiguration")
            .getter(getter(WaterfallChartConfiguration::colorConfiguration)).setter(setter(Builder::colorConfiguration))
            .constructor(WaterfallChartColorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorConfiguration").build())
            .build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(WaterfallChartConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, WATERFALL_CHART_OPTIONS_FIELD, CATEGORY_AXIS_LABEL_OPTIONS_FIELD,
            CATEGORY_AXIS_DISPLAY_OPTIONS_FIELD, PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD, PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD,
            LEGEND_FIELD, DATA_LABELS_FIELD, VISUAL_PALETTE_FIELD, COLOR_CONFIGURATION_FIELD, INTERACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final WaterfallChartFieldWells fieldWells;

    private final WaterfallChartSortConfiguration sortConfiguration;

    private final WaterfallChartOptions waterfallChartOptions;

    private final ChartAxisLabelOptions categoryAxisLabelOptions;

    private final AxisDisplayOptions categoryAxisDisplayOptions;

    private final ChartAxisLabelOptions primaryYAxisLabelOptions;

    private final AxisDisplayOptions primaryYAxisDisplayOptions;

    private final LegendOptions legend;

    private final DataLabelOptions dataLabels;

    private final VisualPalette visualPalette;

    private final WaterfallChartColorConfiguration colorConfiguration;

    private final VisualInteractionOptions interactions;

    private WaterfallChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.waterfallChartOptions = builder.waterfallChartOptions;
        this.categoryAxisLabelOptions = builder.categoryAxisLabelOptions;
        this.categoryAxisDisplayOptions = builder.categoryAxisDisplayOptions;
        this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
        this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.visualPalette = builder.visualPalette;
        this.colorConfiguration = builder.colorConfiguration;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field well configuration of a waterfall visual.
     * </p>
     * 
     * @return The field well configuration of a waterfall visual.
     */
    public final WaterfallChartFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a waterfall visual.
     * </p>
     * 
     * @return The sort configuration of a waterfall visual.
     */
    public final WaterfallChartSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The options that determine the presentation of a waterfall visual.
     * </p>
     * 
     * @return The options that determine the presentation of a waterfall visual.
     */
    public final WaterfallChartOptions waterfallChartOptions() {
        return waterfallChartOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the category axis label.
     * </p>
     * 
     * @return The options that determine the presentation of the category axis label.
     */
    public final ChartAxisLabelOptions categoryAxisLabelOptions() {
        return categoryAxisLabelOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the category axis.
     * </p>
     * 
     * @return The options that determine the presentation of the category axis.
     */
    public final AxisDisplayOptions categoryAxisDisplayOptions() {
        return categoryAxisDisplayOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the y-axis label.
     * </p>
     * 
     * @return The options that determine the presentation of the y-axis label.
     */
    public final ChartAxisLabelOptions primaryYAxisLabelOptions() {
        return primaryYAxisLabelOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the y-axis.
     * </p>
     * 
     * @return The options that determine the presentation of the y-axis.
     */
    public final AxisDisplayOptions primaryYAxisDisplayOptions() {
        return primaryYAxisDisplayOptions;
    }

    /**
     * <p>
     * The legend configuration of a waterfall visual.
     * </p>
     * 
     * @return The legend configuration of a waterfall visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The data label configuration of a waterfall visual.
     * </p>
     * 
     * @return The data label configuration of a waterfall visual.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The visual palette configuration of a waterfall visual.
     * </p>
     * 
     * @return The visual palette configuration of a waterfall visual.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * <p>
     * The color configuration of a waterfall visual.
     * </p>
     * 
     * @return The color configuration of a waterfall visual.
     */
    public final WaterfallChartColorConfiguration colorConfiguration() {
        return colorConfiguration;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(waterfallChartOptions());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(primaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(primaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(colorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaterfallChartConfiguration)) {
            return false;
        }
        WaterfallChartConfiguration other = (WaterfallChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(waterfallChartOptions(), other.waterfallChartOptions())
                && Objects.equals(categoryAxisLabelOptions(), other.categoryAxisLabelOptions())
                && Objects.equals(categoryAxisDisplayOptions(), other.categoryAxisDisplayOptions())
                && Objects.equals(primaryYAxisLabelOptions(), other.primaryYAxisLabelOptions())
                && Objects.equals(primaryYAxisDisplayOptions(), other.primaryYAxisDisplayOptions())
                && Objects.equals(legend(), other.legend()) && Objects.equals(dataLabels(), other.dataLabels())
                && Objects.equals(visualPalette(), other.visualPalette())
                && Objects.equals(colorConfiguration(), other.colorConfiguration())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaterfallChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("WaterfallChartOptions", waterfallChartOptions())
                .add("CategoryAxisLabelOptions", categoryAxisLabelOptions())
                .add("CategoryAxisDisplayOptions", categoryAxisDisplayOptions())
                .add("PrimaryYAxisLabelOptions", primaryYAxisLabelOptions())
                .add("PrimaryYAxisDisplayOptions", primaryYAxisDisplayOptions()).add("Legend", legend())
                .add("DataLabels", dataLabels()).add("VisualPalette", visualPalette())
                .add("ColorConfiguration", colorConfiguration()).add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "WaterfallChartOptions":
            return Optional.ofNullable(clazz.cast(waterfallChartOptions()));
        case "CategoryAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(categoryAxisLabelOptions()));
        case "CategoryAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(categoryAxisDisplayOptions()));
        case "PrimaryYAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(primaryYAxisLabelOptions()));
        case "PrimaryYAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(primaryYAxisDisplayOptions()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "ColorConfiguration":
            return Optional.ofNullable(clazz.cast(colorConfiguration()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WaterfallChartConfiguration, T> g) {
        return obj -> g.apply((WaterfallChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaterfallChartConfiguration> {
        /**
         * <p>
         * The field well configuration of a waterfall visual.
         * </p>
         * 
         * @param fieldWells
         *        The field well configuration of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(WaterfallChartFieldWells fieldWells);

        /**
         * <p>
         * The field well configuration of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaterfallChartFieldWells.Builder}
         * avoiding the need to create one manually via {@link WaterfallChartFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaterfallChartFieldWells.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldWells(WaterfallChartFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link WaterfallChartFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(WaterfallChartFieldWells)
         */
        default Builder fieldWells(Consumer<WaterfallChartFieldWells.Builder> fieldWells) {
            return fieldWells(WaterfallChartFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a waterfall visual.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(WaterfallChartSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaterfallChartSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link WaterfallChartSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaterfallChartSortConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortConfiguration(WaterfallChartSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link WaterfallChartSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(WaterfallChartSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<WaterfallChartSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(WaterfallChartSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The options that determine the presentation of a waterfall visual.
         * </p>
         * 
         * @param waterfallChartOptions
         *        The options that determine the presentation of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waterfallChartOptions(WaterfallChartOptions waterfallChartOptions);

        /**
         * <p>
         * The options that determine the presentation of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaterfallChartOptions.Builder} avoiding
         * the need to create one manually via {@link WaterfallChartOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaterfallChartOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #waterfallChartOptions(WaterfallChartOptions)}.
         * 
         * @param waterfallChartOptions
         *        a consumer that will call methods on {@link WaterfallChartOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waterfallChartOptions(WaterfallChartOptions)
         */
        default Builder waterfallChartOptions(Consumer<WaterfallChartOptions.Builder> waterfallChartOptions) {
            return waterfallChartOptions(WaterfallChartOptions.builder().applyMutation(waterfallChartOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the category axis label.
         * </p>
         * 
         * @param categoryAxisLabelOptions
         *        The options that determine the presentation of the category axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryAxisLabelOptions(ChartAxisLabelOptions categoryAxisLabelOptions);

        /**
         * <p>
         * The options that determine the presentation of the category axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param categoryAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder categoryAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryAxisLabelOptions) {
            return categoryAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(categoryAxisLabelOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the category axis.
         * </p>
         * 
         * @param categoryAxisDisplayOptions
         *        The options that determine the presentation of the category axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryAxisDisplayOptions(AxisDisplayOptions categoryAxisDisplayOptions);

        /**
         * <p>
         * The options that determine the presentation of the category axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #categoryAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param categoryAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder categoryAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> categoryAxisDisplayOptions) {
            return categoryAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(categoryAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the y-axis label.
         * </p>
         * 
         * @param primaryYAxisLabelOptions
         *        The options that determine the presentation of the y-axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions);

        /**
         * <p>
         * The options that determine the presentation of the y-axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryYAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param primaryYAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryYAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder primaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> primaryYAxisLabelOptions) {
            return primaryYAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(primaryYAxisLabelOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the y-axis.
         * </p>
         * 
         * @param primaryYAxisDisplayOptions
         *        The options that determine the presentation of the y-axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryYAxisDisplayOptions(AxisDisplayOptions primaryYAxisDisplayOptions);

        /**
         * <p>
         * The options that determine the presentation of the y-axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #primaryYAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param primaryYAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryYAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder primaryYAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> primaryYAxisDisplayOptions) {
            return primaryYAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(primaryYAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The legend configuration of a waterfall visual.
         * </p>
         * 
         * @param legend
         *        The legend configuration of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend configuration of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The data label configuration of a waterfall visual.
         * </p>
         * 
         * @param dataLabels
         *        The data label configuration of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The data label configuration of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The visual palette configuration of a waterfall visual.
         * </p>
         * 
         * @param visualPalette
         *        The visual palette configuration of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The visual palette configuration of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * The color configuration of a waterfall visual.
         * </p>
         * 
         * @param colorConfiguration
         *        The color configuration of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorConfiguration(WaterfallChartColorConfiguration colorConfiguration);

        /**
         * <p>
         * The color configuration of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaterfallChartColorConfiguration.Builder}
         * avoiding the need to create one manually via {@link WaterfallChartColorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaterfallChartColorConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #colorConfiguration(WaterfallChartColorConfiguration)}.
         * 
         * @param colorConfiguration
         *        a consumer that will call methods on {@link WaterfallChartColorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorConfiguration(WaterfallChartColorConfiguration)
         */
        default Builder colorConfiguration(Consumer<WaterfallChartColorConfiguration.Builder> colorConfiguration) {
            return colorConfiguration(WaterfallChartColorConfiguration.builder().applyMutation(colorConfiguration).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WaterfallChartFieldWells fieldWells;

        private WaterfallChartSortConfiguration sortConfiguration;

        private WaterfallChartOptions waterfallChartOptions;

        private ChartAxisLabelOptions categoryAxisLabelOptions;

        private AxisDisplayOptions categoryAxisDisplayOptions;

        private ChartAxisLabelOptions primaryYAxisLabelOptions;

        private AxisDisplayOptions primaryYAxisDisplayOptions;

        private LegendOptions legend;

        private DataLabelOptions dataLabels;

        private VisualPalette visualPalette;

        private WaterfallChartColorConfiguration colorConfiguration;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(WaterfallChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            waterfallChartOptions(model.waterfallChartOptions);
            categoryAxisLabelOptions(model.categoryAxisLabelOptions);
            categoryAxisDisplayOptions(model.categoryAxisDisplayOptions);
            primaryYAxisLabelOptions(model.primaryYAxisLabelOptions);
            primaryYAxisDisplayOptions(model.primaryYAxisDisplayOptions);
            legend(model.legend);
            dataLabels(model.dataLabels);
            visualPalette(model.visualPalette);
            colorConfiguration(model.colorConfiguration);
            interactions(model.interactions);
        }

        public final WaterfallChartFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(WaterfallChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(WaterfallChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final WaterfallChartSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(WaterfallChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(WaterfallChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final WaterfallChartOptions.Builder getWaterfallChartOptions() {
            return waterfallChartOptions != null ? waterfallChartOptions.toBuilder() : null;
        }

        public final void setWaterfallChartOptions(WaterfallChartOptions.BuilderImpl waterfallChartOptions) {
            this.waterfallChartOptions = waterfallChartOptions != null ? waterfallChartOptions.build() : null;
        }

        @Override
        public final Builder waterfallChartOptions(WaterfallChartOptions waterfallChartOptions) {
            this.waterfallChartOptions = waterfallChartOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryAxisLabelOptions() {
            return categoryAxisLabelOptions != null ? categoryAxisLabelOptions.toBuilder() : null;
        }

        public final void setCategoryAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryAxisLabelOptions) {
            this.categoryAxisLabelOptions = categoryAxisLabelOptions != null ? categoryAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryAxisLabelOptions(ChartAxisLabelOptions categoryAxisLabelOptions) {
            this.categoryAxisLabelOptions = categoryAxisLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxisDisplayOptions() {
            return categoryAxisDisplayOptions != null ? categoryAxisDisplayOptions.toBuilder() : null;
        }

        public final void setCategoryAxisDisplayOptions(AxisDisplayOptions.BuilderImpl categoryAxisDisplayOptions) {
            this.categoryAxisDisplayOptions = categoryAxisDisplayOptions != null ? categoryAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder categoryAxisDisplayOptions(AxisDisplayOptions categoryAxisDisplayOptions) {
            this.categoryAxisDisplayOptions = categoryAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getPrimaryYAxisLabelOptions() {
            return primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getPrimaryYAxisDisplayOptions() {
            return primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisDisplayOptions(AxisDisplayOptions primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final WaterfallChartColorConfiguration.Builder getColorConfiguration() {
            return colorConfiguration != null ? colorConfiguration.toBuilder() : null;
        }

        public final void setColorConfiguration(WaterfallChartColorConfiguration.BuilderImpl colorConfiguration) {
            this.colorConfiguration = colorConfiguration != null ? colorConfiguration.build() : null;
        }

        @Override
        public final Builder colorConfiguration(WaterfallChartColorConfiguration colorConfiguration) {
            this.colorConfiguration = colorConfiguration;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public WaterfallChartConfiguration build() {
            return new WaterfallChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
