/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A constant used in a category filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicCategoryFilterConstant implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicCategoryFilterConstant.Builder, TopicCategoryFilterConstant> {
    private static final SdkField<String> CONSTANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConstantType").getter(getter(TopicCategoryFilterConstant::constantTypeAsString))
            .setter(setter(Builder::constantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstantType").build()).build();

    private static final SdkField<String> SINGULAR_CONSTANT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SingularConstant").getter(getter(TopicCategoryFilterConstant::singularConstant))
            .setter(setter(Builder::singularConstant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingularConstant").build()).build();

    private static final SdkField<CollectiveConstant> COLLECTIVE_CONSTANT_FIELD = SdkField
            .<CollectiveConstant> builder(MarshallingType.SDK_POJO).memberName("CollectiveConstant")
            .getter(getter(TopicCategoryFilterConstant::collectiveConstant)).setter(setter(Builder::collectiveConstant))
            .constructor(CollectiveConstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectiveConstant").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_TYPE_FIELD,
            SINGULAR_CONSTANT_FIELD, COLLECTIVE_CONSTANT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String constantType;

    private final String singularConstant;

    private final CollectiveConstant collectiveConstant;

    private TopicCategoryFilterConstant(BuilderImpl builder) {
        this.constantType = builder.constantType;
        this.singularConstant = builder.singularConstant;
        this.collectiveConstant = builder.collectiveConstant;
    }

    /**
     * <p>
     * The type of category filter constant. This element is used to specify whether a constant is a singular or
     * collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constantType} will
     * return {@link ConstantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #constantTypeAsString}.
     * </p>
     * 
     * @return The type of category filter constant. This element is used to specify whether a constant is a singular or
     *         collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.
     * @see ConstantType
     */
    public final ConstantType constantType() {
        return ConstantType.fromValue(constantType);
    }

    /**
     * <p>
     * The type of category filter constant. This element is used to specify whether a constant is a singular or
     * collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #constantType} will
     * return {@link ConstantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #constantTypeAsString}.
     * </p>
     * 
     * @return The type of category filter constant. This element is used to specify whether a constant is a singular or
     *         collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.
     * @see ConstantType
     */
    public final String constantTypeAsString() {
        return constantType;
    }

    /**
     * <p>
     * A singular constant used in a category filter. This element is used to specify a single value for the constant.
     * </p>
     * 
     * @return A singular constant used in a category filter. This element is used to specify a single value for the
     *         constant.
     */
    public final String singularConstant() {
        return singularConstant;
    }

    /**
     * <p>
     * A collective constant used in a category filter. This element is used to specify a list of values for the
     * constant.
     * </p>
     * 
     * @return A collective constant used in a category filter. This element is used to specify a list of values for the
     *         constant.
     */
    public final CollectiveConstant collectiveConstant() {
        return collectiveConstant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(singularConstant());
        hashCode = 31 * hashCode + Objects.hashCode(collectiveConstant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicCategoryFilterConstant)) {
            return false;
        }
        TopicCategoryFilterConstant other = (TopicCategoryFilterConstant) obj;
        return Objects.equals(constantTypeAsString(), other.constantTypeAsString())
                && Objects.equals(singularConstant(), other.singularConstant())
                && Objects.equals(collectiveConstant(), other.collectiveConstant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicCategoryFilterConstant").add("ConstantType", constantTypeAsString())
                .add("SingularConstant", singularConstant()).add("CollectiveConstant", collectiveConstant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstantType":
            return Optional.ofNullable(clazz.cast(constantTypeAsString()));
        case "SingularConstant":
            return Optional.ofNullable(clazz.cast(singularConstant()));
        case "CollectiveConstant":
            return Optional.ofNullable(clazz.cast(collectiveConstant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicCategoryFilterConstant, T> g) {
        return obj -> g.apply((TopicCategoryFilterConstant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicCategoryFilterConstant> {
        /**
         * <p>
         * The type of category filter constant. This element is used to specify whether a constant is a singular or
         * collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.
         * </p>
         * 
         * @param constantType
         *        The type of category filter constant. This element is used to specify whether a constant is a singular
         *        or collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.
         * @see ConstantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConstantType
         */
        Builder constantType(String constantType);

        /**
         * <p>
         * The type of category filter constant. This element is used to specify whether a constant is a singular or
         * collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.
         * </p>
         * 
         * @param constantType
         *        The type of category filter constant. This element is used to specify whether a constant is a singular
         *        or collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code>.
         * @see ConstantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConstantType
         */
        Builder constantType(ConstantType constantType);

        /**
         * <p>
         * A singular constant used in a category filter. This element is used to specify a single value for the
         * constant.
         * </p>
         * 
         * @param singularConstant
         *        A singular constant used in a category filter. This element is used to specify a single value for the
         *        constant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singularConstant(String singularConstant);

        /**
         * <p>
         * A collective constant used in a category filter. This element is used to specify a list of values for the
         * constant.
         * </p>
         * 
         * @param collectiveConstant
         *        A collective constant used in a category filter. This element is used to specify a list of values for
         *        the constant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectiveConstant(CollectiveConstant collectiveConstant);

        /**
         * <p>
         * A collective constant used in a category filter. This element is used to specify a list of values for the
         * constant.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollectiveConstant.Builder} avoiding the
         * need to create one manually via {@link CollectiveConstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollectiveConstant.Builder#build()} is called immediately and its
         * result is passed to {@link #collectiveConstant(CollectiveConstant)}.
         * 
         * @param collectiveConstant
         *        a consumer that will call methods on {@link CollectiveConstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectiveConstant(CollectiveConstant)
         */
        default Builder collectiveConstant(Consumer<CollectiveConstant.Builder> collectiveConstant) {
            return collectiveConstant(CollectiveConstant.builder().applyMutation(collectiveConstant).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String constantType;

        private String singularConstant;

        private CollectiveConstant collectiveConstant;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicCategoryFilterConstant model) {
            constantType(model.constantType);
            singularConstant(model.singularConstant);
            collectiveConstant(model.collectiveConstant);
        }

        public final String getConstantType() {
            return constantType;
        }

        public final void setConstantType(String constantType) {
            this.constantType = constantType;
        }

        @Override
        public final Builder constantType(String constantType) {
            this.constantType = constantType;
            return this;
        }

        @Override
        public final Builder constantType(ConstantType constantType) {
            this.constantType(constantType == null ? null : constantType.toString());
            return this;
        }

        public final String getSingularConstant() {
            return singularConstant;
        }

        public final void setSingularConstant(String singularConstant) {
            this.singularConstant = singularConstant;
        }

        @Override
        public final Builder singularConstant(String singularConstant) {
            this.singularConstant = singularConstant;
            return this;
        }

        public final CollectiveConstant.Builder getCollectiveConstant() {
            return collectiveConstant != null ? collectiveConstant.toBuilder() : null;
        }

        public final void setCollectiveConstant(CollectiveConstant.BuilderImpl collectiveConstant) {
            this.collectiveConstant = collectiveConstant != null ? collectiveConstant.build() : null;
        }

        @Override
        public final Builder collectiveConstant(CollectiveConstant collectiveConstant) {
            this.collectiveConstant = collectiveConstant;
            return this;
        }

        @Override
        public TopicCategoryFilterConstant build() {
            return new TopicCategoryFilterConstant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
