/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom icon content for the table link content configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableFieldCustomIconContent implements SdkPojo, Serializable,
        ToCopyableBuilder<TableFieldCustomIconContent.Builder, TableFieldCustomIconContent> {
    private static final SdkField<String> ICON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Icon")
            .getter(getter(TableFieldCustomIconContent::iconAsString)).setter(setter(Builder::icon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Icon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String icon;

    private TableFieldCustomIconContent(BuilderImpl builder) {
        this.icon = builder.icon;
    }

    /**
     * <p>
     * The icon set type (link) of the custom icon content for table URL link content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #icon} will return
     * {@link TableFieldIconSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iconAsString}.
     * </p>
     * 
     * @return The icon set type (link) of the custom icon content for table URL link content.
     * @see TableFieldIconSetType
     */
    public final TableFieldIconSetType icon() {
        return TableFieldIconSetType.fromValue(icon);
    }

    /**
     * <p>
     * The icon set type (link) of the custom icon content for table URL link content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #icon} will return
     * {@link TableFieldIconSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iconAsString}.
     * </p>
     * 
     * @return The icon set type (link) of the custom icon content for table URL link content.
     * @see TableFieldIconSetType
     */
    public final String iconAsString() {
        return icon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iconAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldCustomIconContent)) {
            return false;
        }
        TableFieldCustomIconContent other = (TableFieldCustomIconContent) obj;
        return Objects.equals(iconAsString(), other.iconAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableFieldCustomIconContent").add("Icon", iconAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Icon":
            return Optional.ofNullable(clazz.cast(iconAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableFieldCustomIconContent, T> g) {
        return obj -> g.apply((TableFieldCustomIconContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableFieldCustomIconContent> {
        /**
         * <p>
         * The icon set type (link) of the custom icon content for table URL link content.
         * </p>
         * 
         * @param icon
         *        The icon set type (link) of the custom icon content for table URL link content.
         * @see TableFieldIconSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableFieldIconSetType
         */
        Builder icon(String icon);

        /**
         * <p>
         * The icon set type (link) of the custom icon content for table URL link content.
         * </p>
         * 
         * @param icon
         *        The icon set type (link) of the custom icon content for table URL link content.
         * @see TableFieldIconSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableFieldIconSetType
         */
        Builder icon(TableFieldIconSetType icon);
    }

    static final class BuilderImpl implements Builder {
        private String icon;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldCustomIconContent model) {
            icon(model.icon);
        }

        public final String getIcon() {
            return icon;
        }

        public final void setIcon(String icon) {
            this.icon = icon;
        }

        @Override
        public final Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public final Builder icon(TableFieldIconSetType icon) {
            this.icon(icon == null ? null : icon.toString());
            return this;
        }

        @Override
        public TableFieldCustomIconContent build() {
            return new TableFieldCustomIconContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
