/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregated field well of a scatter plot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScatterPlotCategoricallyAggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<ScatterPlotCategoricallyAggregatedFieldWells.Builder, ScatterPlotCategoricallyAggregatedFieldWells> {
    private static final SdkField<List<MeasureField>> X_AXIS_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("XAxis")
            .getter(getter(ScatterPlotCategoricallyAggregatedFieldWells::xAxis))
            .setter(setter(Builder::xAxis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> Y_AXIS_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("YAxis")
            .getter(getter(ScatterPlotCategoricallyAggregatedFieldWells::yAxis))
            .setter(setter(Builder::yAxis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> CATEGORY_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Category")
            .getter(getter(ScatterPlotCategoricallyAggregatedFieldWells::category))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> SIZE_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("Size")
            .getter(getter(ScatterPlotCategoricallyAggregatedFieldWells::size))
            .setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> LABEL_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Label")
            .getter(getter(ScatterPlotCategoricallyAggregatedFieldWells::label))
            .setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X_AXIS_FIELD, Y_AXIS_FIELD,
            CATEGORY_FIELD, SIZE_FIELD, LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<MeasureField> xAxis;

    private final List<MeasureField> yAxis;

    private final List<DimensionField> category;

    private final List<MeasureField> size;

    private final List<DimensionField> label;

    private ScatterPlotCategoricallyAggregatedFieldWells(BuilderImpl builder) {
        this.xAxis = builder.xAxis;
        this.yAxis = builder.yAxis;
        this.category = builder.category;
        this.size = builder.size;
        this.label = builder.label;
    }

    /**
     * For responses, this returns true if the service returned a value for the XAxis property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasXAxis() {
        return xAxis != null && !(xAxis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The x-axis field well of a scatter plot.
     * </p>
     * <p>
     * The x-axis is aggregated by category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasXAxis} method.
     * </p>
     * 
     * @return The x-axis field well of a scatter plot.</p>
     *         <p>
     *         The x-axis is aggregated by category.
     */
    public final List<MeasureField> xAxis() {
        return xAxis;
    }

    /**
     * For responses, this returns true if the service returned a value for the YAxis property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasYAxis() {
        return yAxis != null && !(yAxis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The y-axis field well of a scatter plot.
     * </p>
     * <p>
     * The y-axis is aggregated by category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasYAxis} method.
     * </p>
     * 
     * @return The y-axis field well of a scatter plot.</p>
     *         <p>
     *         The y-axis is aggregated by category.
     */
    public final List<MeasureField> yAxis() {
        return yAxis;
    }

    /**
     * For responses, this returns true if the service returned a value for the Category property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategory() {
        return category != null && !(category instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The category field well of a scatter plot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategory} method.
     * </p>
     * 
     * @return The category field well of a scatter plot.
     */
    public final List<DimensionField> category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the Size property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSize() {
        return size != null && !(size instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The size field well of a scatter plot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSize} method.
     * </p>
     * 
     * @return The size field well of a scatter plot.
     */
    public final List<MeasureField> size() {
        return size;
    }

    /**
     * For responses, this returns true if the service returned a value for the Label property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLabel() {
        return label != null && !(label instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The label field well of a scatter plot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabel} method.
     * </p>
     * 
     * @return The label field well of a scatter plot.
     */
    public final List<DimensionField> label() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasXAxis() ? xAxis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasYAxis() ? yAxis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCategory() ? category() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSize() ? size() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabel() ? label() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScatterPlotCategoricallyAggregatedFieldWells)) {
            return false;
        }
        ScatterPlotCategoricallyAggregatedFieldWells other = (ScatterPlotCategoricallyAggregatedFieldWells) obj;
        return hasXAxis() == other.hasXAxis() && Objects.equals(xAxis(), other.xAxis()) && hasYAxis() == other.hasYAxis()
                && Objects.equals(yAxis(), other.yAxis()) && hasCategory() == other.hasCategory()
                && Objects.equals(category(), other.category()) && hasSize() == other.hasSize()
                && Objects.equals(size(), other.size()) && hasLabel() == other.hasLabel()
                && Objects.equals(label(), other.label());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScatterPlotCategoricallyAggregatedFieldWells").add("XAxis", hasXAxis() ? xAxis() : null)
                .add("YAxis", hasYAxis() ? yAxis() : null).add("Category", hasCategory() ? category() : null)
                .add("Size", hasSize() ? size() : null).add("Label", hasLabel() ? label() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "XAxis":
            return Optional.ofNullable(clazz.cast(xAxis()));
        case "YAxis":
            return Optional.ofNullable(clazz.cast(yAxis()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScatterPlotCategoricallyAggregatedFieldWells, T> g) {
        return obj -> g.apply((ScatterPlotCategoricallyAggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScatterPlotCategoricallyAggregatedFieldWells> {
        /**
         * <p>
         * The x-axis field well of a scatter plot.
         * </p>
         * <p>
         * The x-axis is aggregated by category.
         * </p>
         * 
         * @param xAxis
         *        The x-axis field well of a scatter plot.</p>
         *        <p>
         *        The x-axis is aggregated by category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxis(Collection<MeasureField> xAxis);

        /**
         * <p>
         * The x-axis field well of a scatter plot.
         * </p>
         * <p>
         * The x-axis is aggregated by category.
         * </p>
         * 
         * @param xAxis
         *        The x-axis field well of a scatter plot.</p>
         *        <p>
         *        The x-axis is aggregated by category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxis(MeasureField... xAxis);

        /**
         * <p>
         * The x-axis field well of a scatter plot.
         * </p>
         * <p>
         * The x-axis is aggregated by category.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #xAxis(List<MeasureField>)}.
         * 
         * @param xAxis
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxis(java.util.Collection<MeasureField>)
         */
        Builder xAxis(Consumer<MeasureField.Builder>... xAxis);

        /**
         * <p>
         * The y-axis field well of a scatter plot.
         * </p>
         * <p>
         * The y-axis is aggregated by category.
         * </p>
         * 
         * @param yAxis
         *        The y-axis field well of a scatter plot.</p>
         *        <p>
         *        The y-axis is aggregated by category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxis(Collection<MeasureField> yAxis);

        /**
         * <p>
         * The y-axis field well of a scatter plot.
         * </p>
         * <p>
         * The y-axis is aggregated by category.
         * </p>
         * 
         * @param yAxis
         *        The y-axis field well of a scatter plot.</p>
         *        <p>
         *        The y-axis is aggregated by category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxis(MeasureField... yAxis);

        /**
         * <p>
         * The y-axis field well of a scatter plot.
         * </p>
         * <p>
         * The y-axis is aggregated by category.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #yAxis(List<MeasureField>)}.
         * 
         * @param yAxis
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #yAxis(java.util.Collection<MeasureField>)
         */
        Builder yAxis(Consumer<MeasureField.Builder>... yAxis);

        /**
         * <p>
         * The category field well of a scatter plot.
         * </p>
         * 
         * @param category
         *        The category field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(Collection<DimensionField> category);

        /**
         * <p>
         * The category field well of a scatter plot.
         * </p>
         * 
         * @param category
         *        The category field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(DimensionField... category);

        /**
         * <p>
         * The category field well of a scatter plot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #category(List<DimensionField>)}.
         * 
         * @param category
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #category(java.util.Collection<DimensionField>)
         */
        Builder category(Consumer<DimensionField.Builder>... category);

        /**
         * <p>
         * The size field well of a scatter plot.
         * </p>
         * 
         * @param size
         *        The size field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Collection<MeasureField> size);

        /**
         * <p>
         * The size field well of a scatter plot.
         * </p>
         * 
         * @param size
         *        The size field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(MeasureField... size);

        /**
         * <p>
         * The size field well of a scatter plot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #size(List<MeasureField>)}.
         * 
         * @param size
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #size(java.util.Collection<MeasureField>)
         */
        Builder size(Consumer<MeasureField.Builder>... size);

        /**
         * <p>
         * The label field well of a scatter plot.
         * </p>
         * 
         * @param label
         *        The label field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Collection<DimensionField> label);

        /**
         * <p>
         * The label field well of a scatter plot.
         * </p>
         * 
         * @param label
         *        The label field well of a scatter plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(DimensionField... label);

        /**
         * <p>
         * The label field well of a scatter plot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #label(List<DimensionField>)}.
         * 
         * @param label
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #label(java.util.Collection<DimensionField>)
         */
        Builder label(Consumer<DimensionField.Builder>... label);
    }

    static final class BuilderImpl implements Builder {
        private List<MeasureField> xAxis = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> yAxis = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> category = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> size = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> label = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScatterPlotCategoricallyAggregatedFieldWells model) {
            xAxis(model.xAxis);
            yAxis(model.yAxis);
            category(model.category);
            size(model.size);
            label(model.label);
        }

        public final List<MeasureField.Builder> getXAxis() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.xAxis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setXAxis(Collection<MeasureField.BuilderImpl> xAxis) {
            this.xAxis = MeasureFieldListCopier.copyFromBuilder(xAxis);
        }

        @Override
        public final Builder xAxis(Collection<MeasureField> xAxis) {
            this.xAxis = MeasureFieldListCopier.copy(xAxis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xAxis(MeasureField... xAxis) {
            xAxis(Arrays.asList(xAxis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xAxis(Consumer<MeasureField.Builder>... xAxis) {
            xAxis(Stream.of(xAxis).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getYAxis() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.yAxis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setYAxis(Collection<MeasureField.BuilderImpl> yAxis) {
            this.yAxis = MeasureFieldListCopier.copyFromBuilder(yAxis);
        }

        @Override
        public final Builder yAxis(Collection<MeasureField> yAxis) {
            this.yAxis = MeasureFieldListCopier.copy(yAxis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder yAxis(MeasureField... yAxis) {
            yAxis(Arrays.asList(yAxis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder yAxis(Consumer<MeasureField.Builder>... yAxis) {
            yAxis(Stream.of(yAxis).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getCategory() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.category);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategory(Collection<DimensionField.BuilderImpl> category) {
            this.category = DimensionFieldListCopier.copyFromBuilder(category);
        }

        @Override
        public final Builder category(Collection<DimensionField> category) {
            this.category = DimensionFieldListCopier.copy(category);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(DimensionField... category) {
            category(Arrays.asList(category));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(Consumer<DimensionField.Builder>... category) {
            category(Stream.of(category).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getSize() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.size);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSize(Collection<MeasureField.BuilderImpl> size) {
            this.size = MeasureFieldListCopier.copyFromBuilder(size);
        }

        @Override
        public final Builder size(Collection<MeasureField> size) {
            this.size = MeasureFieldListCopier.copy(size);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder size(MeasureField... size) {
            size(Arrays.asList(size));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder size(Consumer<MeasureField.Builder>... size) {
            size(Stream.of(size).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getLabel() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.label);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabel(Collection<DimensionField.BuilderImpl> label) {
            this.label = DimensionFieldListCopier.copyFromBuilder(label);
        }

        @Override
        public final Builder label(Collection<DimensionField> label) {
            this.label = DimensionFieldListCopier.copy(label);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(DimensionField... label) {
            label(Arrays.asList(label));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder label(Consumer<DimensionField.Builder>... label) {
            label(Stream.of(label).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ScatterPlotCategoricallyAggregatedFieldWells build() {
            return new ScatterPlotCategoricallyAggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
