/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The percent range in the visible range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PercentVisibleRange implements SdkPojo, Serializable,
        ToCopyableBuilder<PercentVisibleRange.Builder, PercentVisibleRange> {
    private static final SdkField<Double> FROM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("From")
            .getter(getter(PercentVisibleRange::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<Double> TO_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("To")
            .getter(getter(PercentVisibleRange::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, TO_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double from;

    private final Double to;

    private PercentVisibleRange(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    /**
     * <p>
     * The lower bound of the range.
     * </p>
     * 
     * @return The lower bound of the range.
     */
    public final Double from() {
        return from;
    }

    /**
     * <p>
     * The top bound of the range.
     * </p>
     * 
     * @return The top bound of the range.
     */
    public final Double to() {
        return to;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PercentVisibleRange)) {
            return false;
        }
        PercentVisibleRange other = (PercentVisibleRange) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(to(), other.to());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PercentVisibleRange").add("From", from()).add("To", to()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "To":
            return Optional.ofNullable(clazz.cast(to()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PercentVisibleRange, T> g) {
        return obj -> g.apply((PercentVisibleRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PercentVisibleRange> {
        /**
         * <p>
         * The lower bound of the range.
         * </p>
         * 
         * @param from
         *        The lower bound of the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(Double from);

        /**
         * <p>
         * The top bound of the range.
         * </p>
         * 
         * @param to
         *        The top bound of the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Double to);
    }

    static final class BuilderImpl implements Builder {
        private Double from;

        private Double to;

        private BuilderImpl() {
        }

        private BuilderImpl(PercentVisibleRange model) {
            from(model.from);
            to(model.to);
        }

        public final Double getFrom() {
            return from;
        }

        public final void setFrom(Double from) {
            this.from = from;
        }

        @Override
        public final Builder from(Double from) {
            this.from = from;
            return this;
        }

        public final Double getTo() {
            return to;
        }

        public final void setTo(Double to) {
            this.to = to;
        }

        @Override
        public final Builder to(Double to) {
            this.to = to;
            return this;
        }

        @Override
        public PercentVisibleRange build() {
            return new PercentVisibleRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
