/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetMetadata implements SdkPojo, Serializable, ToCopyableBuilder<DatasetMetadata.Builder, DatasetMetadata> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DatasetMetadata::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DatasetMetadata::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetDescription").getter(getter(DatasetMetadata::datasetDescription))
            .setter(setter(Builder::datasetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetDescription").build())
            .build();

    private static final SdkField<DataAggregation> DATA_AGGREGATION_FIELD = SdkField
            .<DataAggregation> builder(MarshallingType.SDK_POJO).memberName("DataAggregation")
            .getter(getter(DatasetMetadata::dataAggregation)).setter(setter(Builder::dataAggregation))
            .constructor(DataAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAggregation").build()).build();

    private static final SdkField<List<TopicFilter>> FILTERS_FIELD = SdkField
            .<List<TopicFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DatasetMetadata::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TopicColumn>> COLUMNS_FIELD = SdkField
            .<List<TopicColumn>> builder(MarshallingType.LIST)
            .memberName("Columns")
            .getter(getter(DatasetMetadata::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TopicCalculatedField>> CALCULATED_FIELDS_FIELD = SdkField
            .<List<TopicCalculatedField>> builder(MarshallingType.LIST)
            .memberName("CalculatedFields")
            .getter(getter(DatasetMetadata::calculatedFields))
            .setter(setter(Builder::calculatedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicCalculatedField> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicCalculatedField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TopicNamedEntity>> NAMED_ENTITIES_FIELD = SdkField
            .<List<TopicNamedEntity>> builder(MarshallingType.LIST)
            .memberName("NamedEntities")
            .getter(getter(DatasetMetadata::namedEntities))
            .setter(setter(Builder::namedEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicNamedEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicNamedEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD,
            DATASET_NAME_FIELD, DATASET_DESCRIPTION_FIELD, DATA_AGGREGATION_FIELD, FILTERS_FIELD, COLUMNS_FIELD,
            CALCULATED_FIELDS_FIELD, NAMED_ENTITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetArn;

    private final String datasetName;

    private final String datasetDescription;

    private final DataAggregation dataAggregation;

    private final List<TopicFilter> filters;

    private final List<TopicColumn> columns;

    private final List<TopicCalculatedField> calculatedFields;

    private final List<TopicNamedEntity> namedEntities;

    private DatasetMetadata(BuilderImpl builder) {
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.datasetDescription = builder.datasetDescription;
        this.dataAggregation = builder.dataAggregation;
        this.filters = builder.filters;
        this.columns = builder.columns;
        this.calculatedFields = builder.calculatedFields;
        this.namedEntities = builder.namedEntities;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The description of the dataset.
     * </p>
     * 
     * @return The description of the dataset.
     */
    public final String datasetDescription() {
        return datasetDescription;
    }

    /**
     * <p>
     * The definition of a data aggregation.
     * </p>
     * 
     * @return The definition of a data aggregation.
     */
    public final DataAggregation dataAggregation() {
        return dataAggregation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filter definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The list of filter definitions.
     */
    public final List<TopicFilter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Columns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of column definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumns} method.
     * </p>
     * 
     * @return The list of column definitions.
     */
    public final List<TopicColumn> columns() {
        return columns;
    }

    /**
     * For responses, this returns true if the service returned a value for the CalculatedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCalculatedFields() {
        return calculatedFields != null && !(calculatedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of calculated field definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalculatedFields} method.
     * </p>
     * 
     * @return The list of calculated field definitions.
     */
    public final List<TopicCalculatedField> calculatedFields() {
        return calculatedFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the NamedEntities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNamedEntities() {
        return namedEntities != null && !(namedEntities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of named entities definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamedEntities} method.
     * </p>
     * 
     * @return The list of named entities definitions.
     */
    public final List<TopicNamedEntity> namedEntities() {
        return namedEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dataAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCalculatedFields() ? calculatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNamedEntities() ? namedEntities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetMetadata)) {
            return false;
        }
        DatasetMetadata other = (DatasetMetadata) obj;
        return Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(datasetDescription(), other.datasetDescription())
                && Objects.equals(dataAggregation(), other.dataAggregation()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && hasColumns() == other.hasColumns()
                && Objects.equals(columns(), other.columns()) && hasCalculatedFields() == other.hasCalculatedFields()
                && Objects.equals(calculatedFields(), other.calculatedFields()) && hasNamedEntities() == other.hasNamedEntities()
                && Objects.equals(namedEntities(), other.namedEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetMetadata").add("DatasetArn", datasetArn()).add("DatasetName", datasetName())
                .add("DatasetDescription", datasetDescription()).add("DataAggregation", dataAggregation())
                .add("Filters", hasFilters() ? filters() : null).add("Columns", hasColumns() ? columns() : null)
                .add("CalculatedFields", hasCalculatedFields() ? calculatedFields() : null)
                .add("NamedEntities", hasNamedEntities() ? namedEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetDescription":
            return Optional.ofNullable(clazz.cast(datasetDescription()));
        case "DataAggregation":
            return Optional.ofNullable(clazz.cast(dataAggregation()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Columns":
            return Optional.ofNullable(clazz.cast(columns()));
        case "CalculatedFields":
            return Optional.ofNullable(clazz.cast(calculatedFields()));
        case "NamedEntities":
            return Optional.ofNullable(clazz.cast(namedEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetMetadata, T> g) {
        return obj -> g.apply((DatasetMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The description of the dataset.
         * </p>
         * 
         * @param datasetDescription
         *        The description of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDescription(String datasetDescription);

        /**
         * <p>
         * The definition of a data aggregation.
         * </p>
         * 
         * @param dataAggregation
         *        The definition of a data aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAggregation(DataAggregation dataAggregation);

        /**
         * <p>
         * The definition of a data aggregation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataAggregation.Builder} avoiding the
         * need to create one manually via {@link DataAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #dataAggregation(DataAggregation)}.
         * 
         * @param dataAggregation
         *        a consumer that will call methods on {@link DataAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataAggregation(DataAggregation)
         */
        default Builder dataAggregation(Consumer<DataAggregation.Builder> dataAggregation) {
            return dataAggregation(DataAggregation.builder().applyMutation(dataAggregation).build());
        }

        /**
         * <p>
         * The list of filter definitions.
         * </p>
         * 
         * @param filters
         *        The list of filter definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<TopicFilter> filters);

        /**
         * <p>
         * The list of filter definitions.
         * </p>
         * 
         * @param filters
         *        The list of filter definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(TopicFilter... filters);

        /**
         * <p>
         * The list of filter definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.TopicFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<TopicFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<TopicFilter>)
         */
        Builder filters(Consumer<TopicFilter.Builder>... filters);

        /**
         * <p>
         * The list of column definitions.
         * </p>
         * 
         * @param columns
         *        The list of column definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<TopicColumn> columns);

        /**
         * <p>
         * The list of column definitions.
         * </p>
         * 
         * @param columns
         *        The list of column definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(TopicColumn... columns);

        /**
         * <p>
         * The list of column definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicColumn.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.TopicColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicColumn.Builder#build()} is called immediately
         * and its result is passed to {@link #columns(List<TopicColumn>)}.
         * 
         * @param columns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(java.util.Collection<TopicColumn>)
         */
        Builder columns(Consumer<TopicColumn.Builder>... columns);

        /**
         * <p>
         * The list of calculated field definitions.
         * </p>
         * 
         * @param calculatedFields
         *        The list of calculated field definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFields(Collection<TopicCalculatedField> calculatedFields);

        /**
         * <p>
         * The list of calculated field definitions.
         * </p>
         * 
         * @param calculatedFields
         *        The list of calculated field definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFields(TopicCalculatedField... calculatedFields);

        /**
         * <p>
         * The list of calculated field definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicCalculatedField.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.TopicCalculatedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicCalculatedField.Builder#build()} is called
         * immediately and its result is passed to {@link #calculatedFields(List<TopicCalculatedField>)}.
         * 
         * @param calculatedFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicCalculatedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedFields(java.util.Collection<TopicCalculatedField>)
         */
        Builder calculatedFields(Consumer<TopicCalculatedField.Builder>... calculatedFields);

        /**
         * <p>
         * The list of named entities definitions.
         * </p>
         * 
         * @param namedEntities
         *        The list of named entities definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedEntities(Collection<TopicNamedEntity> namedEntities);

        /**
         * <p>
         * The list of named entities definitions.
         * </p>
         * 
         * @param namedEntities
         *        The list of named entities definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedEntities(TopicNamedEntity... namedEntities);

        /**
         * <p>
         * The list of named entities definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicNamedEntity.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.TopicNamedEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicNamedEntity.Builder#build()} is called
         * immediately and its result is passed to {@link #namedEntities(List<TopicNamedEntity>)}.
         * 
         * @param namedEntities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicNamedEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namedEntities(java.util.Collection<TopicNamedEntity>)
         */
        Builder namedEntities(Consumer<TopicNamedEntity.Builder>... namedEntities);
    }

    static final class BuilderImpl implements Builder {
        private String datasetArn;

        private String datasetName;

        private String datasetDescription;

        private DataAggregation dataAggregation;

        private List<TopicFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<TopicColumn> columns = DefaultSdkAutoConstructList.getInstance();

        private List<TopicCalculatedField> calculatedFields = DefaultSdkAutoConstructList.getInstance();

        private List<TopicNamedEntity> namedEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetMetadata model) {
            datasetArn(model.datasetArn);
            datasetName(model.datasetName);
            datasetDescription(model.datasetDescription);
            dataAggregation(model.dataAggregation);
            filters(model.filters);
            columns(model.columns);
            calculatedFields(model.calculatedFields);
            namedEntities(model.namedEntities);
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetDescription() {
            return datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DataAggregation.Builder getDataAggregation() {
            return dataAggregation != null ? dataAggregation.toBuilder() : null;
        }

        public final void setDataAggregation(DataAggregation.BuilderImpl dataAggregation) {
            this.dataAggregation = dataAggregation != null ? dataAggregation.build() : null;
        }

        @Override
        public final Builder dataAggregation(DataAggregation dataAggregation) {
            this.dataAggregation = dataAggregation;
            return this;
        }

        public final List<TopicFilter.Builder> getFilters() {
            List<TopicFilter.Builder> result = TopicFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<TopicFilter.BuilderImpl> filters) {
            this.filters = TopicFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<TopicFilter> filters) {
            this.filters = TopicFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(TopicFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<TopicFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> TopicFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicColumn.Builder> getColumns() {
            List<TopicColumn.Builder> result = TopicColumnsCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<TopicColumn.BuilderImpl> columns) {
            this.columns = TopicColumnsCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<TopicColumn> columns) {
            this.columns = TopicColumnsCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(TopicColumn... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<TopicColumn.Builder>... columns) {
            columns(Stream.of(columns).map(c -> TopicColumn.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicCalculatedField.Builder> getCalculatedFields() {
            List<TopicCalculatedField.Builder> result = TopicCalculatedFieldsCopier.copyToBuilder(this.calculatedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedFields(Collection<TopicCalculatedField.BuilderImpl> calculatedFields) {
            this.calculatedFields = TopicCalculatedFieldsCopier.copyFromBuilder(calculatedFields);
        }

        @Override
        public final Builder calculatedFields(Collection<TopicCalculatedField> calculatedFields) {
            this.calculatedFields = TopicCalculatedFieldsCopier.copy(calculatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(TopicCalculatedField... calculatedFields) {
            calculatedFields(Arrays.asList(calculatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(Consumer<TopicCalculatedField.Builder>... calculatedFields) {
            calculatedFields(Stream.of(calculatedFields).map(c -> TopicCalculatedField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TopicNamedEntity.Builder> getNamedEntities() {
            List<TopicNamedEntity.Builder> result = TopicNamedEntitiesCopier.copyToBuilder(this.namedEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNamedEntities(Collection<TopicNamedEntity.BuilderImpl> namedEntities) {
            this.namedEntities = TopicNamedEntitiesCopier.copyFromBuilder(namedEntities);
        }

        @Override
        public final Builder namedEntities(Collection<TopicNamedEntity> namedEntities) {
            this.namedEntities = TopicNamedEntitiesCopier.copy(namedEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedEntities(TopicNamedEntity... namedEntities) {
            namedEntities(Arrays.asList(namedEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedEntities(Consumer<TopicNamedEntity.Builder>... namedEntities) {
            namedEntities(Stream.of(namedEntities).map(c -> TopicNamedEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DatasetMetadata build() {
            return new DatasetMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
