/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this structure to redact sensitive information that you provide about an anonymous user from the snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotAnonymousUserRedacted implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotAnonymousUserRedacted.Builder, SnapshotAnonymousUserRedacted> {
    private static final SdkField<List<String>> ROW_LEVEL_PERMISSION_TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RowLevelPermissionTagKeys")
            .getter(getter(SnapshotAnonymousUserRedacted::rowLevelPermissionTagKeys))
            .setter(setter(Builder::rowLevelPermissionTagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionTagKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROW_LEVEL_PERMISSION_TAG_KEYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> rowLevelPermissionTagKeys;

    private SnapshotAnonymousUserRedacted(BuilderImpl builder) {
        this.rowLevelPermissionTagKeys = builder.rowLevelPermissionTagKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the RowLevelPermissionTagKeys property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRowLevelPermissionTagKeys() {
        return rowLevelPermissionTagKeys != null && !(rowLevelPermissionTagKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys for the <code>RowLevelPermissionTags</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRowLevelPermissionTagKeys} method.
     * </p>
     * 
     * @return The tag keys for the <code>RowLevelPermissionTags</code>.
     */
    public final List<String> rowLevelPermissionTagKeys() {
        return rowLevelPermissionTagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRowLevelPermissionTagKeys() ? rowLevelPermissionTagKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotAnonymousUserRedacted)) {
            return false;
        }
        SnapshotAnonymousUserRedacted other = (SnapshotAnonymousUserRedacted) obj;
        return hasRowLevelPermissionTagKeys() == other.hasRowLevelPermissionTagKeys()
                && Objects.equals(rowLevelPermissionTagKeys(), other.rowLevelPermissionTagKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotAnonymousUserRedacted")
                .add("RowLevelPermissionTagKeys", hasRowLevelPermissionTagKeys() ? rowLevelPermissionTagKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RowLevelPermissionTagKeys":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionTagKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotAnonymousUserRedacted, T> g) {
        return obj -> g.apply((SnapshotAnonymousUserRedacted) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotAnonymousUserRedacted> {
        /**
         * <p>
         * The tag keys for the <code>RowLevelPermissionTags</code>.
         * </p>
         * 
         * @param rowLevelPermissionTagKeys
         *        The tag keys for the <code>RowLevelPermissionTags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionTagKeys(Collection<String> rowLevelPermissionTagKeys);

        /**
         * <p>
         * The tag keys for the <code>RowLevelPermissionTags</code>.
         * </p>
         * 
         * @param rowLevelPermissionTagKeys
         *        The tag keys for the <code>RowLevelPermissionTags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionTagKeys(String... rowLevelPermissionTagKeys);
    }

    static final class BuilderImpl implements Builder {
        private List<String> rowLevelPermissionTagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotAnonymousUserRedacted model) {
            rowLevelPermissionTagKeys(model.rowLevelPermissionTagKeys);
        }

        public final Collection<String> getRowLevelPermissionTagKeys() {
            if (rowLevelPermissionTagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return rowLevelPermissionTagKeys;
        }

        public final void setRowLevelPermissionTagKeys(Collection<String> rowLevelPermissionTagKeys) {
            this.rowLevelPermissionTagKeys = SessionTagKeyListCopier.copy(rowLevelPermissionTagKeys);
        }

        @Override
        public final Builder rowLevelPermissionTagKeys(Collection<String> rowLevelPermissionTagKeys) {
            this.rowLevelPermissionTagKeys = SessionTagKeyListCopier.copy(rowLevelPermissionTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowLevelPermissionTagKeys(String... rowLevelPermissionTagKeys) {
            rowLevelPermissionTagKeys(Arrays.asList(rowLevelPermissionTagKeys));
            return this;
        }

        @Override
        public SnapshotAnonymousUserRedacted build() {
            return new SnapshotAnonymousUserRedacted(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
