/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the presentation of the <code>GaugeChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GaugeChartOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<GaugeChartOptions.Builder, GaugeChartOptions> {
    private static final SdkField<String> PRIMARY_VALUE_DISPLAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryValueDisplayType").getter(getter(GaugeChartOptions::primaryValueDisplayTypeAsString))
            .setter(setter(Builder::primaryValueDisplayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValueDisplayType").build())
            .build();

    private static final SdkField<ComparisonConfiguration> COMPARISON_FIELD = SdkField
            .<ComparisonConfiguration> builder(MarshallingType.SDK_POJO).memberName("Comparison")
            .getter(getter(GaugeChartOptions::comparison)).setter(setter(Builder::comparison))
            .constructor(ComparisonConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").build()).build();

    private static final SdkField<ArcAxisConfiguration> ARC_AXIS_FIELD = SdkField
            .<ArcAxisConfiguration> builder(MarshallingType.SDK_POJO).memberName("ArcAxis")
            .getter(getter(GaugeChartOptions::arcAxis)).setter(setter(Builder::arcAxis))
            .constructor(ArcAxisConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArcAxis").build()).build();

    private static final SdkField<ArcConfiguration> ARC_FIELD = SdkField.<ArcConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("Arc").getter(getter(GaugeChartOptions::arc)).setter(setter(Builder::arc))
            .constructor(ArcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arc").build()).build();

    private static final SdkField<FontConfiguration> PRIMARY_VALUE_FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryValueFontConfiguration")
            .getter(getter(GaugeChartOptions::primaryValueFontConfiguration))
            .setter(setter(Builder::primaryValueFontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValueFontConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRIMARY_VALUE_DISPLAY_TYPE_FIELD, COMPARISON_FIELD, ARC_AXIS_FIELD, ARC_FIELD,
                    PRIMARY_VALUE_FONT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primaryValueDisplayType;

    private final ComparisonConfiguration comparison;

    private final ArcAxisConfiguration arcAxis;

    private final ArcConfiguration arc;

    private final FontConfiguration primaryValueFontConfiguration;

    private GaugeChartOptions(BuilderImpl builder) {
        this.primaryValueDisplayType = builder.primaryValueDisplayType;
        this.comparison = builder.comparison;
        this.arcAxis = builder.arcAxis;
        this.arc = builder.arc;
        this.primaryValueFontConfiguration = builder.primaryValueFontConfiguration;
    }

    /**
     * <p>
     * The options that determine the primary value display type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #primaryValueDisplayType} will return {@link PrimaryValueDisplayType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #primaryValueDisplayTypeAsString}.
     * </p>
     * 
     * @return The options that determine the primary value display type.
     * @see PrimaryValueDisplayType
     */
    public final PrimaryValueDisplayType primaryValueDisplayType() {
        return PrimaryValueDisplayType.fromValue(primaryValueDisplayType);
    }

    /**
     * <p>
     * The options that determine the primary value display type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #primaryValueDisplayType} will return {@link PrimaryValueDisplayType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #primaryValueDisplayTypeAsString}.
     * </p>
     * 
     * @return The options that determine the primary value display type.
     * @see PrimaryValueDisplayType
     */
    public final String primaryValueDisplayTypeAsString() {
        return primaryValueDisplayType;
    }

    /**
     * <p>
     * The comparison configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The comparison configuration of a <code>GaugeChartVisual</code>.
     */
    public final ComparisonConfiguration comparison() {
        return comparison;
    }

    /**
     * <p>
     * The arc axis configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The arc axis configuration of a <code>GaugeChartVisual</code>.
     */
    public final ArcAxisConfiguration arcAxis() {
        return arcAxis;
    }

    /**
     * <p>
     * The arc configuration of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The arc configuration of a <code>GaugeChartVisual</code>.
     */
    public final ArcConfiguration arc() {
        return arc;
    }

    /**
     * <p>
     * The options that determine the primary value font configuration.
     * </p>
     * 
     * @return The options that determine the primary value font configuration.
     */
    public final FontConfiguration primaryValueFontConfiguration() {
        return primaryValueFontConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryValueDisplayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comparison());
        hashCode = 31 * hashCode + Objects.hashCode(arcAxis());
        hashCode = 31 * hashCode + Objects.hashCode(arc());
        hashCode = 31 * hashCode + Objects.hashCode(primaryValueFontConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GaugeChartOptions)) {
            return false;
        }
        GaugeChartOptions other = (GaugeChartOptions) obj;
        return Objects.equals(primaryValueDisplayTypeAsString(), other.primaryValueDisplayTypeAsString())
                && Objects.equals(comparison(), other.comparison()) && Objects.equals(arcAxis(), other.arcAxis())
                && Objects.equals(arc(), other.arc())
                && Objects.equals(primaryValueFontConfiguration(), other.primaryValueFontConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GaugeChartOptions").add("PrimaryValueDisplayType", primaryValueDisplayTypeAsString())
                .add("Comparison", comparison()).add("ArcAxis", arcAxis()).add("Arc", arc())
                .add("PrimaryValueFontConfiguration", primaryValueFontConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryValueDisplayType":
            return Optional.ofNullable(clazz.cast(primaryValueDisplayTypeAsString()));
        case "Comparison":
            return Optional.ofNullable(clazz.cast(comparison()));
        case "ArcAxis":
            return Optional.ofNullable(clazz.cast(arcAxis()));
        case "Arc":
            return Optional.ofNullable(clazz.cast(arc()));
        case "PrimaryValueFontConfiguration":
            return Optional.ofNullable(clazz.cast(primaryValueFontConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GaugeChartOptions, T> g) {
        return obj -> g.apply((GaugeChartOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GaugeChartOptions> {
        /**
         * <p>
         * The options that determine the primary value display type.
         * </p>
         * 
         * @param primaryValueDisplayType
         *        The options that determine the primary value display type.
         * @see PrimaryValueDisplayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrimaryValueDisplayType
         */
        Builder primaryValueDisplayType(String primaryValueDisplayType);

        /**
         * <p>
         * The options that determine the primary value display type.
         * </p>
         * 
         * @param primaryValueDisplayType
         *        The options that determine the primary value display type.
         * @see PrimaryValueDisplayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrimaryValueDisplayType
         */
        Builder primaryValueDisplayType(PrimaryValueDisplayType primaryValueDisplayType);

        /**
         * <p>
         * The comparison configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param comparison
         *        The comparison configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparison(ComparisonConfiguration comparison);

        /**
         * <p>
         * The comparison configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComparisonConfiguration.Builder} avoiding
         * the need to create one manually via {@link ComparisonConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComparisonConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #comparison(ComparisonConfiguration)}.
         * 
         * @param comparison
         *        a consumer that will call methods on {@link ComparisonConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparison(ComparisonConfiguration)
         */
        default Builder comparison(Consumer<ComparisonConfiguration.Builder> comparison) {
            return comparison(ComparisonConfiguration.builder().applyMutation(comparison).build());
        }

        /**
         * <p>
         * The arc axis configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param arcAxis
         *        The arc axis configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arcAxis(ArcAxisConfiguration arcAxis);

        /**
         * <p>
         * The arc axis configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArcAxisConfiguration.Builder} avoiding
         * the need to create one manually via {@link ArcAxisConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArcAxisConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #arcAxis(ArcAxisConfiguration)}.
         * 
         * @param arcAxis
         *        a consumer that will call methods on {@link ArcAxisConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arcAxis(ArcAxisConfiguration)
         */
        default Builder arcAxis(Consumer<ArcAxisConfiguration.Builder> arcAxis) {
            return arcAxis(ArcAxisConfiguration.builder().applyMutation(arcAxis).build());
        }

        /**
         * <p>
         * The arc configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param arc
         *        The arc configuration of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arc(ArcConfiguration arc);

        /**
         * <p>
         * The arc configuration of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArcConfiguration.Builder} avoiding the
         * need to create one manually via {@link ArcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #arc(ArcConfiguration)}.
         * 
         * @param arc
         *        a consumer that will call methods on {@link ArcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arc(ArcConfiguration)
         */
        default Builder arc(Consumer<ArcConfiguration.Builder> arc) {
            return arc(ArcConfiguration.builder().applyMutation(arc).build());
        }

        /**
         * <p>
         * The options that determine the primary value font configuration.
         * </p>
         * 
         * @param primaryValueFontConfiguration
         *        The options that determine the primary value font configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValueFontConfiguration(FontConfiguration primaryValueFontConfiguration);

        /**
         * <p>
         * The options that determine the primary value font configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #primaryValueFontConfiguration(FontConfiguration)}.
         * 
         * @param primaryValueFontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValueFontConfiguration(FontConfiguration)
         */
        default Builder primaryValueFontConfiguration(Consumer<FontConfiguration.Builder> primaryValueFontConfiguration) {
            return primaryValueFontConfiguration(FontConfiguration.builder().applyMutation(primaryValueFontConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String primaryValueDisplayType;

        private ComparisonConfiguration comparison;

        private ArcAxisConfiguration arcAxis;

        private ArcConfiguration arc;

        private FontConfiguration primaryValueFontConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GaugeChartOptions model) {
            primaryValueDisplayType(model.primaryValueDisplayType);
            comparison(model.comparison);
            arcAxis(model.arcAxis);
            arc(model.arc);
            primaryValueFontConfiguration(model.primaryValueFontConfiguration);
        }

        public final String getPrimaryValueDisplayType() {
            return primaryValueDisplayType;
        }

        public final void setPrimaryValueDisplayType(String primaryValueDisplayType) {
            this.primaryValueDisplayType = primaryValueDisplayType;
        }

        @Override
        public final Builder primaryValueDisplayType(String primaryValueDisplayType) {
            this.primaryValueDisplayType = primaryValueDisplayType;
            return this;
        }

        @Override
        public final Builder primaryValueDisplayType(PrimaryValueDisplayType primaryValueDisplayType) {
            this.primaryValueDisplayType(primaryValueDisplayType == null ? null : primaryValueDisplayType.toString());
            return this;
        }

        public final ComparisonConfiguration.Builder getComparison() {
            return comparison != null ? comparison.toBuilder() : null;
        }

        public final void setComparison(ComparisonConfiguration.BuilderImpl comparison) {
            this.comparison = comparison != null ? comparison.build() : null;
        }

        @Override
        public final Builder comparison(ComparisonConfiguration comparison) {
            this.comparison = comparison;
            return this;
        }

        public final ArcAxisConfiguration.Builder getArcAxis() {
            return arcAxis != null ? arcAxis.toBuilder() : null;
        }

        public final void setArcAxis(ArcAxisConfiguration.BuilderImpl arcAxis) {
            this.arcAxis = arcAxis != null ? arcAxis.build() : null;
        }

        @Override
        public final Builder arcAxis(ArcAxisConfiguration arcAxis) {
            this.arcAxis = arcAxis;
            return this;
        }

        public final ArcConfiguration.Builder getArc() {
            return arc != null ? arc.toBuilder() : null;
        }

        public final void setArc(ArcConfiguration.BuilderImpl arc) {
            this.arc = arc != null ? arc.build() : null;
        }

        @Override
        public final Builder arc(ArcConfiguration arc) {
            this.arc = arc;
            return this;
        }

        public final FontConfiguration.Builder getPrimaryValueFontConfiguration() {
            return primaryValueFontConfiguration != null ? primaryValueFontConfiguration.toBuilder() : null;
        }

        public final void setPrimaryValueFontConfiguration(FontConfiguration.BuilderImpl primaryValueFontConfiguration) {
            this.primaryValueFontConfiguration = primaryValueFontConfiguration != null ? primaryValueFontConfiguration.build()
                    : null;
        }

        @Override
        public final Builder primaryValueFontConfiguration(FontConfiguration primaryValueFontConfiguration) {
            this.primaryValueFontConfiguration = primaryValueFontConfiguration;
            return this;
        }

        @Override
        public GaugeChartOptions build() {
            return new GaugeChartOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
