/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the default settings for interactive layout configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultInteractiveLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultInteractiveLayoutConfiguration.Builder, DefaultInteractiveLayoutConfiguration> {
    private static final SdkField<DefaultGridLayoutConfiguration> GRID_FIELD = SdkField
            .<DefaultGridLayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("Grid")
            .getter(getter(DefaultInteractiveLayoutConfiguration::grid)).setter(setter(Builder::grid))
            .constructor(DefaultGridLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grid").build()).build();

    private static final SdkField<DefaultFreeFormLayoutConfiguration> FREE_FORM_FIELD = SdkField
            .<DefaultFreeFormLayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("FreeForm")
            .getter(getter(DefaultInteractiveLayoutConfiguration::freeForm)).setter(setter(Builder::freeForm))
            .constructor(DefaultFreeFormLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeForm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRID_FIELD, FREE_FORM_FIELD));

    private static final long serialVersionUID = 1L;

    private final DefaultGridLayoutConfiguration grid;

    private final DefaultFreeFormLayoutConfiguration freeForm;

    private DefaultInteractiveLayoutConfiguration(BuilderImpl builder) {
        this.grid = builder.grid;
        this.freeForm = builder.freeForm;
    }

    /**
     * <p>
     * The options that determine the default settings for a grid layout configuration.
     * </p>
     * 
     * @return The options that determine the default settings for a grid layout configuration.
     */
    public final DefaultGridLayoutConfiguration grid() {
        return grid;
    }

    /**
     * <p>
     * The options that determine the default settings of a free-form layout configuration.
     * </p>
     * 
     * @return The options that determine the default settings of a free-form layout configuration.
     */
    public final DefaultFreeFormLayoutConfiguration freeForm() {
        return freeForm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grid());
        hashCode = 31 * hashCode + Objects.hashCode(freeForm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultInteractiveLayoutConfiguration)) {
            return false;
        }
        DefaultInteractiveLayoutConfiguration other = (DefaultInteractiveLayoutConfiguration) obj;
        return Objects.equals(grid(), other.grid()) && Objects.equals(freeForm(), other.freeForm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultInteractiveLayoutConfiguration").add("Grid", grid()).add("FreeForm", freeForm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Grid":
            return Optional.ofNullable(clazz.cast(grid()));
        case "FreeForm":
            return Optional.ofNullable(clazz.cast(freeForm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultInteractiveLayoutConfiguration, T> g) {
        return obj -> g.apply((DefaultInteractiveLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultInteractiveLayoutConfiguration> {
        /**
         * <p>
         * The options that determine the default settings for a grid layout configuration.
         * </p>
         * 
         * @param grid
         *        The options that determine the default settings for a grid layout configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grid(DefaultGridLayoutConfiguration grid);

        /**
         * <p>
         * The options that determine the default settings for a grid layout configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultGridLayoutConfiguration.Builder}
         * avoiding the need to create one manually via {@link DefaultGridLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultGridLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #grid(DefaultGridLayoutConfiguration)}.
         * 
         * @param grid
         *        a consumer that will call methods on {@link DefaultGridLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grid(DefaultGridLayoutConfiguration)
         */
        default Builder grid(Consumer<DefaultGridLayoutConfiguration.Builder> grid) {
            return grid(DefaultGridLayoutConfiguration.builder().applyMutation(grid).build());
        }

        /**
         * <p>
         * The options that determine the default settings of a free-form layout configuration.
         * </p>
         * 
         * @param freeForm
         *        The options that determine the default settings of a free-form layout configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeForm(DefaultFreeFormLayoutConfiguration freeForm);

        /**
         * <p>
         * The options that determine the default settings of a free-form layout configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultFreeFormLayoutConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultFreeFormLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFreeFormLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #freeForm(DefaultFreeFormLayoutConfiguration)}.
         * 
         * @param freeForm
         *        a consumer that will call methods on {@link DefaultFreeFormLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #freeForm(DefaultFreeFormLayoutConfiguration)
         */
        default Builder freeForm(Consumer<DefaultFreeFormLayoutConfiguration.Builder> freeForm) {
            return freeForm(DefaultFreeFormLayoutConfiguration.builder().applyMutation(freeForm).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DefaultGridLayoutConfiguration grid;

        private DefaultFreeFormLayoutConfiguration freeForm;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultInteractiveLayoutConfiguration model) {
            grid(model.grid);
            freeForm(model.freeForm);
        }

        public final DefaultGridLayoutConfiguration.Builder getGrid() {
            return grid != null ? grid.toBuilder() : null;
        }

        public final void setGrid(DefaultGridLayoutConfiguration.BuilderImpl grid) {
            this.grid = grid != null ? grid.build() : null;
        }

        @Override
        public final Builder grid(DefaultGridLayoutConfiguration grid) {
            this.grid = grid;
            return this;
        }

        public final DefaultFreeFormLayoutConfiguration.Builder getFreeForm() {
            return freeForm != null ? freeForm.toBuilder() : null;
        }

        public final void setFreeForm(DefaultFreeFormLayoutConfiguration.BuilderImpl freeForm) {
            this.freeForm = freeForm != null ? freeForm.build() : null;
        }

        @Override
        public final Builder freeForm(DefaultFreeFormLayoutConfiguration freeForm) {
            this.freeForm = freeForm;
            return this;
        }

        @Override
        public DefaultInteractiveLayoutConfiguration build() {
            return new DefaultInteractiveLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
